/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.ScaleData;
import jspecview.common.Spectrum;
import jspecview.common.ViewData;
import jspecview.common.XYScaleConverter;

class ImageView
implements XYScaleConverter {
    private int[] buf2d;
    private double grayFactorLast;
    private double averageGray;
    int xPixel0;
    int yPixel0;
    int xPixel1;
    int yPixel1;
    int imageWidth;
    int imageHeight;
    int xPixels;
    int yPixels;
    int xPixelZoom1;
    int yPixelZoom1;
    int xPixelZoom2;
    int yPixelZoom2;
    int xView1;
    int yView1;
    int xView2;
    int yView2;
    double minX = Double.NaN;
    double maxX;
    double minY;
    double maxY;
    double minZ;
    double maxZ;
    private ScaleData scaleData;
    private static final double DEFAULT_MIN_GRAY = 0.05;
    private static final double DEFAULT_MAX_GRAY = 0.3;

    ImageView() {
    }

    void set(ScaleData view) {
        if (Double.isNaN(this.minX)) {
            this.minX = view.minX;
            this.maxX = view.maxX;
        }
        this.minZ = view.minY;
        this.maxZ = view.maxY;
        this.scaleData = new ScaleData();
    }

    void setZoom(int xPixel1, int yPixel1, int xPixel2, int yPixel2) {
        this.xPixelZoom1 = Math.min(xPixel1, xPixel2);
        this.yPixelZoom1 = Math.min(yPixel1, yPixel2);
        this.xPixelZoom2 = Math.max(xPixel1, xPixel2);
        this.yPixelZoom2 = Math.max(yPixel1, yPixel2);
        this.setView();
    }

    void setXY0(Spectrum spec, int xPixel, int yPixel) {
        this.xPixel0 = xPixel;
        this.yPixel0 = yPixel;
        this.xPixel1 = this.xPixel0 + this.xPixels - 1;
        this.yPixel1 = this.yPixel0 + this.yPixels - 1;
        this.setMinMaxY(spec);
    }

    void setPixelWidthHeight(int xPixels, int yPixels) {
        this.xPixels = xPixels;
        this.yPixels = yPixels;
    }

    void resetView() {
        this.xView1 = 0;
        this.yView1 = 0;
        this.xView2 = this.imageWidth - 1;
        this.yView2 = this.imageHeight - 1;
    }

    void setView() {
        if (this.xPixelZoom1 == 0) {
            this.resetZoom();
        }
        int x1 = this.toImageX(this.xPixelZoom1);
        int y1 = this.toImageY(this.yPixelZoom1);
        int x2 = this.toImageX(this.xPixelZoom2);
        int y2 = this.toImageY(this.yPixelZoom2);
        this.xView1 = Math.min(x1, x2);
        this.yView1 = Math.min(y1, y2);
        this.xView2 = Math.max(x1, x2);
        this.yView2 = Math.max(y1, y2);
        this.setScaleData();
        this.resetZoom();
    }

    void resetZoom() {
        this.xPixelZoom1 = this.xPixel0;
        this.yPixelZoom1 = this.yPixel0;
        this.xPixelZoom2 = this.xPixel1;
        this.yPixelZoom2 = this.yPixel1;
    }

    int toImageX(int xPixel) {
        return this.xView1 + (int)Math.floor((double)(xPixel - this.xPixel0) / ((double)this.xPixels - 1.0) * (double)(this.xView2 - this.xView1));
    }

    int toImageY(int yPixel) {
        return this.yView1 + (int)Math.floor((double)(yPixel - this.yPixel0) / ((double)this.yPixels - 1.0) * (double)(this.yView2 - this.yView1));
    }

    int toImageX0(int xPixel) {
        return Coordinate.intoRange((int)((1.0 * (double)xPixel - (double)this.xPixel0) / (double)(this.xPixels - 1) * (double)(this.imageWidth - 1)), 0, this.imageWidth - 1);
    }

    int toImageY0(int yPixel) {
        return Coordinate.intoRange((int)((1.0 * (double)yPixel - (double)this.yPixel0) / (double)(this.yPixels - 1) * (double)(this.imageHeight - 1)), 0, this.imageHeight - 1);
    }

    boolean isXWithinRange(int xPixel) {
        return xPixel >= this.xPixel0 - 5 && xPixel < this.xPixel0 + this.xPixels + 5;
    }

    int toSubspectrumIndex(int yPixel) {
        return Coordinate.intoRange(this.imageHeight - 1 - this.toImageY(yPixel), 0, this.imageHeight - 1);
    }

    double toX0(int xPixel) {
        return this.maxX + (this.minX - this.maxX) * (double)(this.fixX(xPixel) - this.xPixel0) / (double)(this.xPixels - 1);
    }

    int toPixelX0(double x) {
        return this.xPixel1 - (int)((x - this.minX) / (this.maxX - this.minX) * (double)(this.xPixels - 1));
    }

    int toPixelY0(double ysub) {
        return this.yPixel1 - (int)(ysub / (double)(this.imageHeight - 1) * (double)(this.yPixels - 1));
    }

    int subIndexToPixelY(int subIndex) {
        double f = 1.0 * (double)(this.imageHeight - 1 - subIndex - this.yView1) / (double)(this.yView2 - this.yView1);
        int y = this.yPixel0 + (int)(f * (double)(this.yPixels - 1));
        return y;
    }

    int fixSubIndex(int subIndex) {
        return Coordinate.intoRange(subIndex, this.imageHeight - 1 - this.yView2, this.imageHeight - 1 - this.yView1);
    }

    void setView0(int xp1, int yp1, int xp2, int yp2) {
        int x1 = this.toImageX0(xp1);
        int y1 = this.toImageY0(yp1);
        int x2 = this.toImageX0(xp2);
        int y2 = this.toImageY0(yp2);
        this.xView1 = Math.min(x1, x2);
        this.yView1 = Math.min(y1, y2);
        this.xView2 = Math.max(x1, x2);
        this.yView2 = Math.max(y1, y2);
        this.resetZoom();
    }

    synchronized int[] get2dBuffer(Spectrum spec, boolean forceNew) {
        Lst<Spectrum> subSpectra = spec.getSubSpectra();
        if (subSpectra == null || !((Spectrum)subSpectra.get(0)).isContinuous()) {
            return null;
        }
        Coordinate[] xyCoords = spec.getXYCoords();
        int nSpec = subSpectra.size();
        this.imageWidth = xyCoords.length;
        this.imageHeight = nSpec;
        double grayFactor = 255.0 / (this.maxZ - this.minZ);
        if (!forceNew && this.buf2d != null && grayFactor == this.grayFactorLast) {
            return this.buf2d;
        }
        this.grayFactorLast = grayFactor;
        int pt = this.imageWidth * this.imageHeight;
        int[] buf = this.buf2d == null || this.buf2d.length != pt ? new int[pt] : this.buf2d;
        double totalGray = 0.0;
        for (int i = 0; i < nSpec; ++i) {
            Coordinate[] points = ((Spectrum)subSpectra.get((int)i)).xyCoords;
            if (points.length != xyCoords.length) {
                return null;
            }
            for (int j = 0; j < xyCoords.length; ++j) {
                double y = points[j].getYVal();
                int gray = 255 - Coordinate.intoRange((int)((y - this.minZ) * grayFactor), 0, 255);
                buf[--pt] = gray;
                totalGray += (double)gray;
            }
        }
        this.averageGray = 1.0 - totalGray / (double)(this.imageWidth * this.imageHeight) / 255.0;
        System.out.println("Average gray = " + this.averageGray);
        this.buf2d = buf;
        return buf;
    }

    int[] adjustView(Spectrum spec, ViewData view) {
        int i = 0;
        boolean isLow = false;
        while (((isLow = this.averageGray < 0.05) || this.averageGray > 0.3) && i++ < 10) {
            view.scaleSpectrum(-2, isLow ? 2.0 : 0.5);
            this.set(view.getScale());
            this.get2dBuffer(spec, false);
        }
        return this.buf2d;
    }

    int[] getBuffer() {
        return this.buf2d;
    }

    void setMinMaxY(Spectrum spec) {
        Lst<Spectrum> subSpectra = spec.getSubSpectra();
        Spectrum spec0 = (Spectrum)subSpectra.get(0);
        this.maxY = spec0.getY2D();
        this.minY = ((Spectrum)subSpectra.get(subSpectra.size() - 1)).getY2D();
        if (spec0.y2DUnits.equalsIgnoreCase("Hz")) {
            this.maxY /= spec0.freq2dY;
            this.minY /= spec0.freq2dY;
        }
        this.setScaleData();
    }

    private void setScaleData() {
        this.scaleData.minY = this.minY;
        this.scaleData.maxY = this.maxY;
        this.scaleData.setYScale(this.toY(this.yPixel0), this.toY(this.yPixel1), false, false);
    }

    @Override
    public int fixX(int xPixel) {
        return xPixel < this.xPixel0 ? this.xPixel0 : (xPixel > this.xPixel1 ? this.xPixel1 : xPixel);
    }

    @Override
    public int fixY(int yPixel) {
        return Coordinate.intoRange(yPixel, this.yPixel0, this.yPixel1);
    }

    @Override
    public ScaleData getScale() {
        return this.scaleData;
    }

    @Override
    public double toX(int xPixel) {
        return this.maxX + (this.minX - this.maxX) * (double)this.toImageX(this.fixX(xPixel)) / (double)(this.imageWidth - 1);
    }

    @Override
    public double toY(int yPixel) {
        int isub = this.toSubspectrumIndex(yPixel);
        return this.maxY + (this.minY - this.maxY) * (double)isub / (double)(this.imageHeight - 1);
    }

    @Override
    public int toPixelX(double x) {
        double x0 = this.toX(this.xPixel0);
        double x1 = this.toX(this.xPixel1);
        return this.xPixel0 + (int)((x - x0) / (x1 - x0) * (double)(this.xPixels - 1));
    }

    @Override
    public int toPixelY(double y) {
        double f = (y - this.scaleData.minYOnScale) / (this.scaleData.maxYOnScale - this.scaleData.minYOnScale);
        return (int)((double)this.yPixel0 + f * (double)this.yPixels);
    }

    @Override
    public int getXPixels() {
        return this.xPixels;
    }

    @Override
    public int getYPixels() {
        return this.yPixels;
    }

    @Override
    public int getXPixel0() {
        return this.xPixel0;
    }
}

