/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;

public class ExecutionEnvironmentProfileProvider {
    private Map profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();

    private static Map loadDefaultProfileList() {
        InputStream inputStream = ExecutionEnvironmentProfileProvider.class.getClassLoader().getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties");
        if (inputStream == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        HashMap hashMap = new HashMap();
        Iterator<Map.Entry<Object, Object>> iterator2 = properties.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            String string2 = (String)iterator2.next().getKey();
            if (!string2.endsWith(".pkglist") || hashMap.containsKey(string = string2.substring(0, string2.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(properties, hashMap, string);
        }
        return hashMap;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties properties, Map map2, String string) {
        String[] stringArray;
        ExecutionEnvironmentProfile executionEnvironmentProfile = new ExecutionEnvironmentProfile(string);
        String string2 = properties.getProperty(string + ".extends");
        if (string2 != null) {
            ExecutionEnvironmentProfile executionEnvironmentProfile2 = (ExecutionEnvironmentProfile)map2.get(string2);
            if (executionEnvironmentProfile2 == null) {
                executionEnvironmentProfile2 = ExecutionEnvironmentProfileProvider.loadProfile(properties, map2, string2);
            }
            stringArray = executionEnvironmentProfile2.getPkgNames().iterator();
            while (stringArray.hasNext()) {
                executionEnvironmentProfile.addPkgName((String)stringArray.next());
            }
        }
        stringArray = properties.getProperty(string + ".pkglist").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.length() == 0) continue;
            executionEnvironmentProfile.addPkgName(string3);
        }
        map2.put(string, executionEnvironmentProfile);
        Message.verbose("Execution environment profile " + executionEnvironmentProfile.getName() + " loaded");
        return executionEnvironmentProfile;
    }

    static {
        try {
            new ExecutionEnvironmentProfileProvider();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

