/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.ClonePasteAction;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.hooks.PermanentMindMapNodeHookAdapter;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClonePlugin
extends PermanentMindMapNodeHookAdapter
implements ModeController.NodeLifetimeListener,
ClonePasteAction.ClonePropertiesObserver {
    public static final String CLONE_ITSELF_FALSE = "false";
    public static final String CLONE_ITSELF_TRUE = "true";
    public static final String PLUGIN_LABEL = "accessories/plugins/ClonePlugin.properties";
    public static final String XML_STORAGE_CLONES = "CLONE_IDS";
    public static final String XML_STORAGE_CLONE_ID = "CLONE_ID";
    public static final String XML_STORAGE_CLONE_ITSELF = "CLONE_ITSELF";
    private HashSet mCloneNodeIds;
    private HashSet mCloneNodes;
    private String mCloneId;
    private boolean mDisabled = false;
    private Boolean mCloneItself = null;
    private ClonePasteAction.CloneProperties mClonePropertiesHolder;

    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.registerPlugin();
    }

    public void addClone(MindMapNode cloneNode) {
        this.mCloneNodeIds.add(this.getMindMapController().getNodeID(cloneNode));
        this.clearCloneCache();
    }

    public void clearCloneCache() {
        this.mCloneNodes = new HashSet();
    }

    private void disablePlugin() {
        this.mDisabled = true;
        this.getMindMapController().getController().errorMessage(this.getMindMapController().getText("clone_plugin_impossible"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ClonePlugin.getHook(ClonePlugin.this.getNode()) != null) {
                    ClonePlugin.this.removeHook();
                }
            }
        });
    }

    protected void removeHook() {
        this.deregisterCloning();
        Vector selecteds = Tools.getVectorWithSingleElement(this.getNode());
        this.getMindMapController().addHook(this.getNode(), selecteds, PLUGIN_LABEL, null);
    }

    @Override
    public void save(XMLElement xml) {
        super.save(xml);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(XML_STORAGE_CLONES, this.getCloneIdsAsString());
        values.put(XML_STORAGE_CLONE_ID, this.mCloneId);
        String cloneItselfValue = this.getCloneItselfValue();
        values.put(XML_STORAGE_CLONE_ITSELF, cloneItselfValue);
        this.logger.finest("Saved mCloneItself to " + cloneItselfValue);
        this.saveNameValuePairs(values, xml);
        this.logger.fine("Saved clone plugin");
    }

    protected String getCloneItselfValue() {
        return this.mClonePropertiesHolder.isCloneItself() ? CLONE_ITSELF_TRUE : CLONE_ITSELF_FALSE;
    }

    public String getCloneIdsAsString() {
        StringBuffer cloneIds = new StringBuffer();
        for (String cloneId : this.mCloneNodeIds) {
            cloneIds.append(cloneId);
            cloneIds.append(",");
        }
        return cloneIds.toString();
    }

    @Override
    public void loadFrom(XMLElement child) {
        super.loadFrom(child);
        this.mCloneNodes = null;
        this.mCloneNodeIds = new HashSet();
        HashMap values = this.loadNameValuePairs(child);
        String cloneIds = (String)values.get(XML_STORAGE_CLONES);
        if (cloneIds != null) {
            StringTokenizer st = new StringTokenizer(cloneIds, ",");
            while (st.hasMoreTokens()) {
                String cloneId = st.nextToken();
                this.mCloneNodeIds.add(cloneId);
            }
        }
        this.mCloneId = (String)values.get(XML_STORAGE_CLONE_ID);
        this.mCloneItself = values.containsKey(XML_STORAGE_CLONE_ITSELF) ? Boolean.valueOf(Tools.safeEquals((Object)CLONE_ITSELF_TRUE, values.get(XML_STORAGE_CLONE_ITSELF))) : Boolean.FALSE;
        this.logger.finest("Loaded mCloneItself to " + this.mCloneItself);
    }

    @Override
    public void shutdownMapHook() {
        this.logger.fine("Shutdown of clones");
        this.deregisterPlugin();
        super.shutdownMapHook();
    }

    private void registerPlugin() {
        if (this.mDisabled) {
            return;
        }
        MindMapNode originalNode = this.getNode();
        HashSet cloneNodes = this.getCloneNodes();
        this.logger.fine("Invoke shadow class with orig: " + this.printNodeId(originalNode) + " and clones " + this.printNodeIds(cloneNodes));
        for (MindMapNode cloneNode : cloneNodes) {
            if (originalNode == null || !originalNode.isDescendantOf(cloneNode)) continue;
            this.disablePlugin();
            return;
        }
        this.getMindMapController().registerNodeLifetimeListener(this, false);
        ClonePasteAction.Registration registration = this.getRegistration();
        if (this.mCloneId == null) {
            this.mCloneId = registration.generateNewCloneId(null);
        }
        registration.registerClone(this.mCloneId, this);
        this.addClone(this.getNode());
        this.mClonePropertiesHolder = registration.getCloneProperties(this.mCloneId);
        if (this.mCloneItself != null) {
            this.mClonePropertiesHolder.setCloneItself(this.mCloneItself);
        }
        this.mClonePropertiesHolder.registerObserver(this);
    }

    protected ClonePasteAction.Registration getRegistration() {
        return (ClonePasteAction.Registration)this.getPluginBaseClass();
    }

    private void deregisterPlugin() {
        this.mClonePropertiesHolder.deregisterObserver(this);
        this.deregisterCloning();
        this.getMindMapController().deregisterNodeLifetimeListener(this);
        this.getNode().setStateIcon(this.getName(), null);
        this.getMindMapController().nodeRefresh(this.getNode());
    }

    protected void deregisterCloning() {
        this.getRegistration().deregisterClone(this.mCloneId, this);
    }

    @Override
    public void onCreateNodeHook(MindMapNode node) {
        HashSet cloneNodes = this.getCloneNodes();
        for (MindMapNode clone : cloneNodes) {
            for (MindMapNode clone2 : cloneNodes) {
                if (clone == clone2) continue;
                this.checkForChainError(clone, node, clone2);
            }
        }
    }

    @Override
    public void onPreDeleteNode(MindMapNode node) {
    }

    @Override
    public void onPostDeleteNode(MindMapNode node, MindMapNode parent) {
    }

    HashSet getCloneNodes() {
        if (this.mCloneNodes != null) {
            for (MindMapNode cloneNode : this.mCloneNodes) {
                if (cloneNode.getParentNode() != null) continue;
                this.clearCloneCache();
            }
        } else {
            this.clearCloneCache();
        }
        if (this.mCloneNodes.isEmpty()) {
            this.mCloneNodes.add(this.getNode());
            Iterator it = this.mCloneNodeIds.iterator();
            while (it.hasNext()) {
                String cloneId = (String)it.next();
                try {
                    this.mCloneNodes.add(this.getMindMapController().getNodeFromID(cloneId));
                }
                catch (IllegalArgumentException e) {
                    it.remove();
                }
            }
        }
        return this.mCloneNodes;
    }

    private String printNodeId(MindMapNode pCloneNode) {
        try {
            return this.getMindMapController().getNodeID(pCloneNode) + ": '" + pCloneNode.getShortText(this.getMindMapController()) + "'";
        }
        catch (Exception e) {
            return "NOT FOUND: '" + pCloneNode + "'";
        }
    }

    private String printNodeIds(Collection pTargets) {
        Vector<String> strings = new Vector<String>();
        for (MindMapNode node : pTargets) {
            strings.add(this.printNodeId(node));
        }
        return "" + strings;
    }

    private void checkForChainError(MindMapNode originalNode, MindMapNode node, MindMapNode cloneNode) {
        if (cloneNode.isDescendantOfOrEqual(node) && node.isDescendantOfOrEqual(originalNode)) {
            this.disablePlugin();
        }
    }

    public void removeClone(MindMapNode pCloneNode) {
        String nodeID = this.getMindMapController().getNodeID(pCloneNode);
        this.mCloneNodeIds.remove(nodeID);
        this.clearCloneCache();
        if (this.mCloneNodeIds.isEmpty() || this.mCloneNodeIds.size() == 1 && this.mCloneNodeIds.contains(this.getNodeId())) {
            this.logger.info("I'm the last clone " + nodeID);
            this.removeHook();
        }
    }

    public static ClonePlugin getHook(MindMapNode originalNode) {
        if (originalNode == null) {
            return null;
        }
        for (PermanentNodeHook hook : originalNode.getActivatedHooks()) {
            if (!(hook instanceof ClonePlugin)) continue;
            ClonePlugin cloneHook = (ClonePlugin)hook;
            return cloneHook;
        }
        return null;
    }

    @Override
    public void processUnfinishedLinks() {
        super.processUnfinishedLinks();
        if (this.mDisabled) {
            return;
        }
        HashSet cloneNodes = this.getCloneNodes();
        for (MindMapNode cloneNode : cloneNodes) {
            ClonePlugin hook = ClonePlugin.getHook(cloneNode);
            if (hook != null || cloneNode == null) continue;
            Vector selecteds = Tools.getVectorWithSingleElement(cloneNode);
            Properties hookProperties = new Properties();
            hookProperties.setProperty(XML_STORAGE_CLONE_ID, this.mCloneId);
            hookProperties.setProperty(XML_STORAGE_CLONES, this.getCloneIdsAsString());
            hookProperties.setProperty(XML_STORAGE_CLONE_ITSELF, this.getCloneItselfValue());
            this.getMindMapController().addHook(cloneNode, selecteds, PLUGIN_LABEL, hookProperties);
        }
    }

    @Override
    public void propertiesChanged(ClonePasteAction.CloneProperties pCloneProperties) {
        this.mCloneItself = pCloneProperties.isCloneItself();
    }

    public String getCloneId() {
        return this.mCloneId;
    }
}

