/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.toolchain;

import java.util.Collection;
import java.util.Collections;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.util.TreeVisitor;

public class ComponentNotFound<T>
implements SearchResult<T> {
    private final String message;
    private final Collection<String> locations;

    public ComponentNotFound(String message) {
        this.message = message;
        this.locations = Collections.emptyList();
    }

    public ComponentNotFound(String message, Collection<String> locations) {
        this.message = message;
        this.locations = locations;
    }

    @Override
    public T getComponent() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public void explain(TreeVisitor<? super String> visitor) {
        visitor.node((Object)this.message);
        if (!this.locations.isEmpty()) {
            visitor.startChildren();
            for (String location : this.locations) {
                visitor.node((Object)location);
            }
            visitor.endChildren();
        }
    }
}

