/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.annotation.Nullable;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.sink.AnsiConsoleUtil;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.console.TestConsoleMetadata;
import org.gradle.internal.nativeintegration.services.NativeServices;

public class ConsoleConfigureAction {
    public static void execute(OutputEventRenderer renderer, ConsoleOutput consoleOutput) {
        if (consoleOutput == ConsoleOutput.Auto) {
            ConsoleConfigureAction.configureAutoConsole(renderer);
        } else if (consoleOutput == ConsoleOutput.Rich) {
            ConsoleConfigureAction.configureRichConsole(renderer, false);
        } else if (consoleOutput == ConsoleOutput.Verbose) {
            ConsoleConfigureAction.configureRichConsole(renderer, true);
        } else if (consoleOutput == ConsoleOutput.Plain) {
            ConsoleConfigureAction.configurePlainConsole(renderer);
        }
    }

    private static void configureRichConsole(OutputEventRenderer renderer, boolean verbose) {
        ConsoleMetaData consoleMetaData = ConsoleConfigureAction.getConsoleMetaData();
        ConsoleConfigureAction.configureRichConsole(renderer, consoleMetaData, ConsoleConfigureAction.shouldForce(consoleMetaData), verbose);
    }

    private static boolean shouldForce(ConsoleMetaData consoleMetaData) {
        return consoleMetaData == null || consoleMetaData instanceof TestConsoleMetadata;
    }

    private static void configureAutoConsole(OutputEventRenderer renderer) {
        ConsoleMetaData consoleMetaData = ConsoleConfigureAction.getConsoleMetaData();
        if (consoleMetaData != null) {
            ConsoleConfigureAction.configureRichConsole(renderer, consoleMetaData, false, false);
        } else {
            ConsoleConfigureAction.configurePlainConsole(renderer, null);
        }
    }

    private static void configurePlainConsole(OutputEventRenderer renderer) {
        ConsoleMetaData consoleMetaData = ConsoleConfigureAction.getConsoleMetaData();
        ConsoleConfigureAction.configurePlainConsole(renderer, consoleMetaData);
    }

    private static ConsoleMetaData getConsoleMetaData() {
        String testConsole = System.getProperty("org.gradle.internal.console.test-console");
        if (testConsole != null) {
            return TestConsoleMetadata.valueOf((String)testConsole);
        }
        ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
        return consoleDetector.getConsole();
    }

    private static void configurePlainConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData) {
        renderer.addPlainConsole(consoleMetaData != null && consoleMetaData.isStdOut() && consoleMetaData.isStdErr());
    }

    private static void configureRichConsole(OutputEventRenderer renderer, @Nullable ConsoleMetaData consoleMetaData, boolean force, boolean verbose) {
        if (consoleMetaData == null) {
            consoleMetaData = FallbackConsoleMetaData.ATTACHED;
        }
        if (consoleMetaData.isStdOut()) {
            OutputStream originalStdOut = renderer.getOriginalStdOut();
            OutputStreamWriter outStr = new OutputStreamWriter(force ? originalStdOut : AnsiConsoleUtil.wrapOutputStream(originalStdOut));
            AnsiConsole console = new AnsiConsole((Appendable)outStr, (Flushable)outStr, renderer.getColourMap(), consoleMetaData, force);
            renderer.addRichConsole(console, consoleMetaData, verbose);
        } else if (consoleMetaData.isStdErr()) {
            OutputStream originalStdErr = renderer.getOriginalStdErr();
            OutputStreamWriter errStr = new OutputStreamWriter(force ? originalStdErr : AnsiConsoleUtil.wrapOutputStream(originalStdErr));
            AnsiConsole console = new AnsiConsole((Appendable)errStr, (Flushable)errStr, renderer.getColourMap(), consoleMetaData, force);
            renderer.addRichConsole(console, consoleMetaData, verbose);
        } else {
            renderer.addRichConsole(null, consoleMetaData, verbose);
        }
    }
}

