/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.formatting.FormattingMode;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.ChangedRangesInfo;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.DocCommentSettings;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.Indent;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(0);
        }
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            CodeStyleManager.$$$reportNull$$$0(1);
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<TextRange> var2) throws IncorrectOperationException;

    public abstract void reformatTextWithContext(@NotNull PsiFile var1, @NotNull ChangedRangesInfo var2) throws IncorrectOperationException;

    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges2) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(2);
        }
        if (ranges2 == null) {
            CodeStyleManager.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> rangesList = ContainerUtil.newArrayList(ranges2);
        this.reformatTextWithContext(file2, new ChangedRangesInfo(rangesList, null));
    }

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset2, FormattingMode mode) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(4);
        }
        return this.getLineIndent(file2, offset2);
    }

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    public abstract Indent getIndent(String var1, FileType var2);

    public abstract String fillIndent(Indent var1, FileType var2);

    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);

    public int getSpacing(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(5);
        }
        return -1;
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(6);
        }
        return -1;
    }

    public static FormattingMode getCurrentFormattingMode(@NotNull Project project) {
        CodeStyleManager instance;
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(7);
        }
        if (!project.isDisposed() && (instance = CodeStyleManager.getInstance(project)) instanceof FormattingModeAwareIndentAdjuster) {
            return ((FormattingModeAwareIndentAdjuster)((Object)instance)).getCurrentFormattingMode();
        }
        return FormattingMode.REFORMAT;
    }

    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            CodeStyleManager.$$$reportNull$$$0(9);
        }
        runnable.run();
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(10);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManager.$$$reportNull$$$0(11);
        }
        return docCommentSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentFormattingMode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

