/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.processors.StandardOutputRedirector;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.tasks.testing.TestOutputEvent;

class TestOutputRedirector {
    private final StandardOutputRedirector redirector;
    Forwarder outForwarder;
    Forwarder errForwarder;

    TestOutputRedirector(TestResultProcessor processor, StandardOutputRedirector redirector) {
        this.redirector = redirector;
        this.outForwarder = new Forwarder(processor, TestOutputEvent.Destination.StdOut);
        this.errForwarder = new Forwarder(processor, TestOutputEvent.Destination.StdErr);
    }

    void startRedirecting() {
        assert (this.outForwarder.outputOwner != null);
        assert (this.errForwarder.outputOwner != null);
        this.redirector.redirectStandardOutputTo(this.outForwarder);
        this.redirector.redirectStandardErrorTo(this.errForwarder);
        this.redirector.start();
    }

    void stopRedirecting() {
        this.redirector.stop();
    }

    void setOutputOwner(Object testId) {
        assert (testId != null);
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        this.outForwarder.outputOwner = testId;
        this.errForwarder.outputOwner = testId;
    }

    static class Forwarder
    implements StandardOutputListener {
        final TestResultProcessor processor;
        final TestOutputEvent.Destination dest;
        Object outputOwner;

        public Forwarder(TestResultProcessor processor, TestOutputEvent.Destination dest) {
            this.processor = processor;
            this.dest = dest;
        }

        public void onOutput(CharSequence output) {
            if (this.outputOwner == null) {
                throw new RuntimeException("Unable send output event from test executor. Please report this problem. Destination: " + (Object)((Object)this.dest) + ", event: " + output.toString());
            }
            this.processor.output(this.outputOwner, new DefaultTestOutputEvent(this.dest, output.toString()));
        }
    }
}

