/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JOptionPane;
import org.jmol.api.JmolDropEditor;
import org.jmol.api.JmolStatusListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FileDropper
implements DropTargetListener {
    private String fd_oldFileName;
    private PropertyChangeSupport fd_propSupport;
    private Viewer vwr;
    private PropertyChangeListener pcl;
    private JmolStatusListener statusListener;
    private JmolDropEditor dropEditor;

    public FileDropper(JmolStatusListener jmolStatusListener, Viewer viewer, JmolDropEditor jmolDropEditor) {
        this.statusListener = jmolStatusListener;
        this.dropEditor = jmolDropEditor;
        this.fd_oldFileName = "";
        this.fd_propSupport = new PropertyChangeSupport(this);
        this.vwr = viewer;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileDropper.this.doDrop(propertyChangeEvent);
            }
        };
        this.addPropertyChangeListener(this.pcl);
        Component component = (Component)viewer.display;
        component.setDropTarget(new DropTarget(component, this));
        component.setEnabled(true);
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
        this.vwr = null;
    }

    private void loadFile(String string, int n, int n2) {
        if (this.dropEditor != null) {
            this.dropEditor.loadFile(string);
            return;
        }
        if (string.endsWith(".URL")) {
            String string2 = this.vwr.getAsciiFileOrNull(string);
            if (string2 == null || string2.indexOf("URL=") < 0) {
                return;
            }
            string = string2.substring(string2.indexOf("URL=") + 4);
            string = string.substring(0, string.indexOf("\n"));
        }
        if ((string = string.replace('\\', '/').trim()).indexOf("://") < 0) {
            string = String.valueOf(string.startsWith("/") ? "file://" : "file:///") + string;
        }
        if (!this.vwr.setStatusDragDropped(0, n, n2, string)) {
            return;
        }
        int n3 = 1;
        boolean bl = FileManager.isScriptType(string);
        boolean bl2 = FileManager.isSurfaceType(string);
        switch (this.vwr.ms.ac > 0 && !bl && !bl2 ? JOptionPane.showConfirmDialog(null, GT.$("Would you like to replace the current model with the selected model?")) : 0) {
            case 2: {
                return;
            }
            case 0: {
                break;
            }
            default: {
                n3 += 4;
            }
        }
        if (this.statusListener != null) {
            try {
                String string3 = this.vwr.fm.getEmbeddedFileState(string, false, "state.spt");
                if (string3.indexOf("preferredWidthHeight") >= 0) {
                    this.vwr.sm.resizeInnerPanelString(string3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.vwr.openFileAsyncSpecial(string, n3);
    }

    private void loadFiles(List<File> list) {
        SB sB = new SB();
        int n = 0;
        while (n < list.size()) {
            File file = list.get(n);
            String string = file.getAbsolutePath();
            string = String.valueOf((string = string.replace('\\', '/').trim()).startsWith("/") ? "file://" : "file:///") + string;
            sB.append("load ").append(n == 0 ? "" : "APPEND ").append(PT.esc(string)).append(";\n");
            ++n;
        }
        sB.append("frame *;reset;");
        this.vwr.script(sB.toString());
    }

    protected void doDrop(PropertyChangeEvent propertyChangeEvent) {
        if ("inline".equals(propertyChangeEvent.getPropertyName())) {
            this.vwr.openStringInline((String)propertyChangeEvent.getNewValue());
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropOver detected...");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropEnter detected...");
        }
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (Logger.debugging) {
            Logger.debug("DropExit detected...");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dropactionchanged");
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        if (Logger.debugging) {
            Logger.debug("Drop detected...");
        }
        Transferable transferable = dropTargetDropEvent.getTransferable();
        boolean bl = false;
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            object2 = null;
            try {
                dropTargetDropEvent.acceptDrop(3);
                object2 = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                bl = true;
            }
            catch (Exception exception) {
                Logger.error("transfer failed");
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                int n = list.size();
                if (n == 1) {
                    object = ((File)list.get(0)).getAbsolutePath().trim();
                    if (!((String)object).endsWith(".bmp")) {
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        Point point = dropTargetDropEvent.getLocation();
                        this.loadFile((String)object, point.x, point.y);
                        return;
                    }
                } else {
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    this.loadFiles(list);
                    return;
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug("browsing supported flavours to find something useful...");
        }
        if ((object2 = transferable.getTransferDataFlavors()) == null || ((DataFlavor[])object2).length == 0) {
            return;
        }
        int n = 0;
        while (n < ((DataFlavor[])object2).length) {
            DataFlavor dataFlavor = object2[n];
            object = null;
            Logger.info("df " + n + " flavor " + dataFlavor);
            Logger.info("  class: " + dataFlavor.getRepresentationClass().getName());
            Logger.info("  mime : " + dataFlavor.getMimeType());
            if (dataFlavor.getMimeType().startsWith("text/uri-list") && dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(dataFlavor);
                }
                catch (Exception exception) {
                    Logger.errorEx(null, exception);
                }
                if (object instanceof String) {
                    if (Logger.debugging) {
                        Logger.debug("  String: " + object.toString());
                    }
                    this.loadFile(object.toString(), 0, 0);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
            } else if (dataFlavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) {
                try {
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(object2[n]);
                }
                catch (Exception exception) {
                    Logger.errorEx(null, exception);
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (Logger.debugging) {
                        Logger.debug("  String: " + string);
                    }
                    if (string.startsWith("file:/")) {
                        this.loadFile(string, 0, 0);
                    } else {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "inline", this.fd_oldFileName, string);
                        this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
            }
            ++n;
        }
        if (!bl) {
            dropTargetDropEvent.rejectDrop();
        }
    }
}

