/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

public interface MessageRenderer {
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            return null;
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            return location2.getPath();
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            return FileUtilsKt.descendantRelativeTo(new File(location2.getPath()), this.cwd).getPath();
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @Nullable CompilerMessageLocation var3);

    public String renderUsage(@NotNull String var1);

    public String renderConclusion();
}

