/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

public class Event {
    private String outcome;
    private String[] context;
    private float[] values;

    public Event(String outcome, String[] context) {
        this(outcome, context, null);
    }

    public Event(String outcome, String[] context, float[] values) {
        this.outcome = outcome;
        this.context = context;
        this.values = values;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String[] getContext() {
        return this.context;
    }

    public float[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.outcome).append(" [");
        if (this.context.length > 0) {
            sb.append(this.context[0]);
            if (this.values != null) {
                sb.append("=").append(this.values[0]);
            }
        }
        for (int ci = 1; ci < this.context.length; ++ci) {
            sb.append(" ").append(this.context[ci]);
            if (this.values == null) continue;
            sb.append("=").append(this.values[ci]);
        }
        sb.append("]");
        return sb.toString();
    }
}

