/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ivy.ant.PackageMapping;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.filters.LineContainsRegExp;
import org.apache.tools.ant.filters.TokenFilter;
import org.apache.tools.ant.taskdefs.Concat;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.RegularExpression;

public class IvyExtractFromSources
extends Task {
    private String organisation;
    private String module;
    private String revision;
    private String status;
    private List ignoredPackaged = new ArrayList();
    private Map mapping = new HashMap();
    private Concat concat = new Concat();
    private File to;

    public void addConfiguredIgnore(Ignore ignore) {
        this.ignoredPackaged.add(ignore.getPackage());
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File file) {
        this.to = file;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void addConfiguredMapping(PackageMapping packageMapping) {
        this.mapping.put(packageMapping.getPackage(), packageMapping.getModuleRevisionId());
    }

    public void addFileSet(FileSet fileSet) {
        this.concat.addFileset(fileSet);
    }

    public void execute() throws BuildException {
        this.configureConcat();
        StringWriter stringWriter = new StringWriter();
        this.concat.setWriter((Writer)stringWriter);
        this.concat.execute();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(((Object)stringWriter).toString().split("\n")));
        HashSet<ModuleRevisionId> hashSet2 = new HashSet<ModuleRevisionId>();
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            String string = ((String)object.next()).trim();
            ModuleRevisionId moduleRevisionId = this.getMapping(string);
            if (moduleRevisionId == null) continue;
            hashSet2.add(moduleRevisionId);
        }
        try {
            object = new PrintWriter(new FileOutputStream(this.to));
            ((PrintWriter)object).println("<ivy-module version=\"1.0\">");
            ((PrintWriter)object).println("\t<info organisation=\"" + this.organisation + "\"");
            ((PrintWriter)object).println("\t       module=\"" + this.module + "\"");
            if (this.revision != null) {
                ((PrintWriter)object).println("\t       revision=\"" + this.revision + "\"");
            }
            if (this.status != null) {
                ((PrintWriter)object).println("\t       status=\"" + this.status + "\"");
            } else {
                ((PrintWriter)object).println("\t       status=\"integration\"");
            }
            ((PrintWriter)object).println("\t/>");
            if (!hashSet2.isEmpty()) {
                ((PrintWriter)object).println("\t<dependencies>");
                for (ModuleRevisionId moduleRevisionId : hashSet2) {
                    ((PrintWriter)object).println("\t\t<dependency org=\"" + moduleRevisionId.getOrganisation() + "\" name=\"" + moduleRevisionId.getName() + "\" rev=\"" + moduleRevisionId.getRevision() + "\"/>");
                }
                ((PrintWriter)object).println("\t</dependencies>");
            }
            ((PrintWriter)object).println("</ivy-module>");
            ((PrintWriter)object).close();
            this.log(hashSet2.size() + " dependencies put in " + this.to);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("impossible to create file " + this.to + ": " + fileNotFoundException, (Throwable)fileNotFoundException);
        }
    }

    private ModuleRevisionId getMapping(String string) {
        String string2 = string;
        ModuleRevisionId moduleRevisionId = null;
        while (moduleRevisionId == null && string.length() > 0) {
            if (this.ignoredPackaged.contains(string)) {
                return null;
            }
            moduleRevisionId = (ModuleRevisionId)this.mapping.get(string);
            int n = string.lastIndexOf(46);
            if (n == -1) break;
            string = string.substring(0, n);
        }
        if (moduleRevisionId == null) {
            this.log("no mapping found for " + string2, 3);
        }
        return moduleRevisionId;
    }

    private void configureConcat() {
        this.concat.setProject(this.getProject());
        this.concat.setTaskName(this.getTaskName());
        FilterChain filterChain = new FilterChain();
        LineContainsRegExp lineContainsRegExp = new LineContainsRegExp();
        RegularExpression regularExpression = new RegularExpression();
        regularExpression.setPattern("^import .+;");
        lineContainsRegExp.addConfiguredRegexp(regularExpression);
        filterChain.add((ChainableReader)lineContainsRegExp);
        TokenFilter tokenFilter = new TokenFilter();
        TokenFilter.ReplaceRegex replaceRegex = new TokenFilter.ReplaceRegex();
        replaceRegex.setPattern("import (.+);.*");
        replaceRegex.setReplace("\\1");
        tokenFilter.add((TokenFilter.Filter)replaceRegex);
        filterChain.add((ChainableReader)tokenFilter);
        this.concat.addFilterChain(filterChain);
    }

    public static class Ignore {
        private String packageName;

        public String getPackage() {
            return this.packageName;
        }

        public void setPackage(String string) {
            this.packageName = string;
        }
    }
}

