/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import com.sun.j3d.audioengines.javasound.JSChannel;
import com.sun.j3d.audioengines.javasound.JSClip;
import com.sun.j3d.audioengines.javasound.JSStream;
import java.io.InputStream;
import java.net.URL;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.View;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.DataLine;

class JSSample
extends Sample {
    static final int STREAMING_AUDIO_DATA = 1;
    static final int BUFFERED_AUDIO_DATA = 2;
    static final int STREAMING_MIDI_DATA = 3;
    static final int BUFFERED_MIDI_DATA = 3;
    static final int UNSUPPORTED_DATA_TYPE = -1;
    static final int NULL_SAMPLE = -1;
    int dataType = 2;
    JSChannel channel = null;
    long dataOffset = 0L;
    long timeDeactivated = 0L;
    long positionDeactivated = 0L;
    long sampleLength = 0L;
    long loopStartOffset = 0L;
    long loopLength = 0L;
    long attackLength = 0L;
    long releaseLength = 0L;
    float rateRatio = 1.0f;
    float currentRateRatio = -1.0f;
    float targetRateRatio = -1.0f;
    boolean rampRateFlag = false;

    public void render(int n, View view, AuralParameters auralParameters) {
        float f = auralParameters.frequencyScaleFactor;
        if (auralParameters != null) {
            if (!(f <= 0.0f)) {
                this.rateRatio = this.currentRateRatio * f;
            }
        } else {
            this.rateRatio = this.currentRateRatio;
        }
    }

    public void clear() {
        super.clear();
        this.dataType = -1;
        this.dataOffset = 0L;
        this.timeDeactivated = 0L;
        this.positionDeactivated = 0L;
        this.sampleLength = 0L;
        this.loopStartOffset = 0L;
        this.loopLength = 0L;
        this.attackLength = 0L;
        this.releaseLength = 0L;
        this.rateRatio = 1.0f;
        this.channel = null;
    }

    boolean load(MediaContainer mediaContainer) {
        String string = mediaContainer.getURLString();
        URL uRL = mediaContainer.getURLObject();
        InputStream inputStream = mediaContainer.getInputStream();
        boolean bl = mediaContainer.getCacheEnable();
        AudioInputStream audioInputStream = null;
        DataLine dataLine = null;
        this.dataType = bl ? 2 : 1;
        if (uRL == null && inputStream == null && string == null) {
            return true;
        }
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                return true;
            }
        }
        if (this.dataType == 2) {
            this.channel = new JSClip();
            if (uRL != null) {
                audioInputStream = this.channel.initAudioInputStream(uRL, bl);
            } else if (inputStream != null) {
                audioInputStream = this.channel.initAudioInputStream(inputStream, bl);
            }
            if (audioInputStream == null) {
                return true;
            }
            dataLine = this.channel.initDataLine(audioInputStream);
        } else if (this.dataType == 1) {
            this.channel = new JSStream();
            if (uRL != null) {
                audioInputStream = this.channel.initAudioInputStream(uRL, bl);
            } else if (inputStream != null) {
                audioInputStream = this.channel.initAudioInputStream(inputStream, bl);
            }
            if (audioInputStream == null) {
                return true;
            }
            dataLine = this.channel.initDataLine(audioInputStream);
        }
        if (dataLine == null) {
            this.channel = null;
            return true;
        }
        this.duration = this.channel.getDuration();
        this.setDirtyFlags(65535);
        this.setSoundType(this.soundType);
        this.setSoundData(mediaContainer);
        return false;
    }

    void reset() {
        this.rateRatio = 1.0f;
    }

    boolean getFilterFlag() {
        return false;
    }

    float getFilterFreq() {
        return -1.0f;
    }

    void setCurrentRateRatio(float f) {
        this.currentRateRatio = f;
    }

    float getCurrentRateRatio() {
        return this.currentRateRatio;
    }

    void setTargetRateRatio(float f) {
        this.targetRateRatio = f;
    }

    float getTargetRateRatio() {
        return this.targetRateRatio;
    }

    void setRampRateFlag(boolean bl) {
        this.rampRateFlag = bl;
    }

    boolean getRampRateFlag() {
        return this.rampRateFlag;
    }

    void setDataType(int n) {
        this.dataType = n;
    }

    int getDataType() {
        return this.dataType;
    }
}

