/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.utils.ApiUtils;

public class SessionManagementAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SessionManagementAPI.class);
    private static final String PREFIX = "sessionManagement";
    private static final String VIEW_GET_SESSION_MANAGEMENT_METHOD = "getSessionManagementMethod";
    private static final String VIEW_GET_METHOD_CONFIG_PARAMETERS = "getSessionManagementMethodConfigParams";
    private static final String VIEW_GET_SUPPORTED_METHODS = "getSupportedSessionManagementMethods";
    private static final String ACTION_SET_METHOD = "setSessionManagementMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_METHOD_NAME = "methodName";
    private static final String PARAM_METHOD_CONFIG_PARAMS = "methodConfigParams";
    private ExtensionSessionManagement extension;
    private Map<String, ApiDynamicActionImplementor> loadedSessionManagementMethodActions;

    public SessionManagementAPI(ExtensionSessionManagement extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_GET_SUPPORTED_METHODS));
        this.addApiView(new ApiView(VIEW_GET_METHOD_CONFIG_PARAMETERS, new String[]{PARAM_METHOD_NAME}));
        this.addApiView(new ApiView(VIEW_GET_SESSION_MANAGEMENT_METHOD, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_METHOD, new String[]{PARAM_CONTEXT_ID, PARAM_METHOD_NAME}, new String[]{PARAM_METHOD_CONFIG_PARAMS}));
        this.loadedSessionManagementMethodActions = new HashMap<String, ApiDynamicActionImplementor>();
        if (extension != null) {
            for (SessionManagementMethodType t : extension.getSessionManagementMethodTypes()) {
                ApiDynamicActionImplementor i = t.getSetMethodForContextApiAction();
                if (i == null) continue;
                this.loadedSessionManagementMethodActions.put(i.getName(), i);
            }
        }
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiView " + name + " " + params.toString()));
        switch (name) {
            case "getSessionManagementMethod": {
                return this.getContext(params).getSessionManagementMethod().getApiResponseRepresentation();
            }
            case "getSupportedSessionManagementMethods": {
                ApiResponseList supportedMethods = new ApiResponseList("supportedMethods");
                for (ApiDynamicActionImplementor a : this.loadedSessionManagementMethodActions.values()) {
                    supportedMethods.addItem(new ApiResponseElement(PARAM_METHOD_NAME, a.getName()));
                }
                return supportedMethods;
            }
            case "getSessionManagementMethodConfigParams": {
                ApiDynamicActionImplementor a = this.getSetMethodActionImplementor(params);
                return a.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiAction " + name + " " + params.toString()));
        switch (name) {
            case "setSessionManagementMethod": {
                JSONObject actionParams = params.has(PARAM_METHOD_CONFIG_PARAMS) ? API.getParams(params.getString(PARAM_METHOD_CONFIG_PARAMS)) : new JSONObject();
                Context context = this.getContext(params);
                actionParams.put((Object)PARAM_CONTEXT_ID, (Object)context.getIndex());
                this.getSetMethodActionImplementor(params).handleAction(actionParams);
                context.save();
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiDynamicActionImplementor getSetMethodActionImplementor(JSONObject params) throws ApiException {
        ApiDynamicActionImplementor a = this.loadedSessionManagementMethodActions.get(ApiUtils.getNonEmptyStringParam(params, PARAM_METHOD_NAME));
        if (a == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, "No session management method type matches the provided value.");
        }
        return a;
    }

    private Context getContext(JSONObject params) throws ApiException {
        int contextId = this.getContextId(params);
        Context context = Model.getSingleton().getSession().getContext(contextId);
        if (context == null) {
            throw new ApiException(ApiException.Type.CONTEXT_NOT_FOUND, PARAM_CONTEXT_ID);
        }
        return context;
    }

    private int getContextId(JSONObject params) throws ApiException {
        try {
            return params.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException ex) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_CONTEXT_ID);
        }
    }

    private boolean hasContextId(JSONObject params) {
        try {
            params.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }
}

