/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxMode;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.layout.StackPane;

public abstract class ComboBoxBaseSkin<T>
extends SkinBase<ComboBoxBase<T>, ComboBoxBaseBehavior<T>> {
    private Node displayNode;
    protected StackPane arrowButton;
    protected StackPane arrow;
    private ComboBoxMode mode = ComboBoxMode.COMBOBOX;

    protected final ComboBoxMode getMode() {
        return this.mode;
    }

    protected final void setMode(ComboBoxMode comboBoxMode) {
        this.mode = comboBoxMode;
    }

    public ComboBoxBaseSkin(ComboBoxBase<T> comboBoxBase, ComboBoxBaseBehavior comboBoxBaseBehavior) {
        super(comboBoxBase, comboBoxBaseBehavior);
        this.arrow = new StackPane();
        this.arrow.setFocusTraversable(false);
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.setFocusTraversable(false);
        this.arrowButton.setId("arrow-button");
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.getChildren().add(this.arrowButton);
        ((ComboBoxBase)this.getSkinnable()).focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    ComboBoxBaseSkin.this.focusLost();
                }
            }
        });
        this.registerChangeListener(comboBoxBase.editableProperty(), "EDITABLE");
        this.registerChangeListener(comboBoxBase.showingProperty(), "SHOWING");
        this.registerChangeListener(comboBoxBase.focusedProperty(), "FOCUSED");
        this.registerChangeListener(comboBoxBase.valueProperty(), "VALUE");
    }

    protected void focusLost() {
        ((ComboBoxBase)this.getSkinnable()).hide();
    }

    public abstract Node getDisplayNode();

    public abstract void show();

    public abstract void hide();

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "SHOWING") {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if (string == "EDITABLE") {
            this.updateDisplayArea();
        } else if (string == "VALUE") {
            this.updateDisplayArea();
        }
    }

    private void updateDisplayArea() {
        this.displayNode = this.getDisplayNode();
        this.getChildren().setAll((Node[])new Node[]{this.displayNode, this.arrowButton});
    }

    private boolean isButton() {
        return this.getMode() == ComboBoxMode.BUTTON;
    }

    @Override
    protected void layoutChildren() {
        double d;
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        double d2 = insets.getLeft();
        double d3 = insets.getTop();
        double d4 = ((ComboBoxBase)this.getSkinnable()).getWidth() - (insets.getLeft() + insets.getRight());
        double d5 = ((ComboBoxBase)this.getSkinnable()).getHeight() - (insets.getTop() + insets.getBottom());
        double d6 = this.snapSize(this.arrow.prefWidth(-1.0));
        double d7 = d = this.isButton() ? 0.0 : this.snapSpace(insets2.getLeft()) + d6 + this.snapSpace(insets2.getRight());
        if (this.displayNode != null) {
            this.displayNode.resizeRelocate(d2, d3, d4, d5);
        }
        if (this.isButton()) {
            return;
        }
        this.arrowButton.resize(d, this.getHeight() - insets.getTop() - insets.getBottom());
        this.positionInArea(this.arrowButton, this.getWidth() - insets.getRight() - d, 0.0, d, this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computePrefWidth(double d) {
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        Insets insets = this.arrowButton.getInsets();
        double d2 = this.snapSize(this.arrow.prefWidth(-1.0));
        double d3 = this.isButton() ? 0.0 : this.snapSpace(insets.getLeft()) + d2 + this.snapSpace(insets.getRight());
        double d4 = this.displayNode == null ? 0.0 : this.displayNode.prefWidth(d) + d3;
        return this.getInsets().getLeft() + d4 + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2;
        if (this.displayNode == null) {
            this.updateDisplayArea();
            this.displayNode.impl_processCSS(true);
        }
        if (this.displayNode == null) {
            Insets insets = this.arrowButton.getInsets();
            double d3 = this.isButton() ? 0.0 : insets.getTop() + this.arrow.prefHeight(-1.0) + insets.getBottom();
            d2 = Math.max(21.0, d3);
        } else {
            d2 = this.displayNode.prefHeight(d);
        }
        Insets insets = this.getInsets();
        return insets.getTop() + d2 + insets.getBottom();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ComboBoxBase)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ComboBoxBase)this.getSkinnable()).prefHeight(d);
    }
}

