/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.xcode.internal.XcodeBinary;
import org.gradle.ide.xcode.internal.xcodeproj.FileTypes;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.language.swift.SwiftVersion;

public class XcodeTarget
implements Named {
    private final String id;
    private final String name;
    private final ConfigurableFileCollection headerSearchPaths;
    private final ConfigurableFileCollection compileModules;
    private final ConfigurableFileCollection sources;
    private final List<TaskDependency> taskDependencies = Lists.newArrayList();
    private String taskName;
    private String gradleCommand;
    private List<XcodeBinary> binaries = Lists.newArrayList();
    private Provider<? extends FileSystemLocation> debugOutputFile;
    private PBXTarget.ProductType productType;
    private String productName;
    private Property<SwiftVersion> swiftSourceCompatibility;
    private Property<String> defaultConfigurationName;

    @Inject
    public XcodeTarget(String name, String id, FileOperations fileOperations, ObjectFactory objectFactory) {
        this.name = name;
        this.id = id;
        this.sources = fileOperations.configurableFiles();
        this.headerSearchPaths = fileOperations.configurableFiles();
        this.compileModules = fileOperations.configurableFiles();
        this.swiftSourceCompatibility = objectFactory.property(SwiftVersion.class);
        this.defaultConfigurationName = objectFactory.property(String.class);
        this.defaultConfigurationName.set((Object)"Debug");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Provider<? extends FileSystemLocation> getDebugOutputFile() {
        return this.debugOutputFile;
    }

    public String getOutputFileType() {
        return XcodeTarget.toFileType(this.productType);
    }

    public PBXTarget.ProductType getProductType() {
        return this.productType;
    }

    public void setProductType(PBXTarget.ProductType productType) {
        this.productType = productType;
    }

    public boolean isRunnable() {
        return PBXTarget.ProductType.TOOL.equals((Object)this.getProductType());
    }

    public boolean isUnitTest() {
        return PBXTarget.ProductType.UNIT_TEST.equals((Object)this.getProductType());
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getGradleCommand() {
        return this.gradleCommand;
    }

    public void setGradleCommand(String gradleCommand) {
        this.gradleCommand = gradleCommand;
    }

    public ConfigurableFileCollection getSources() {
        return this.sources;
    }

    public ConfigurableFileCollection getHeaderSearchPaths() {
        return this.headerSearchPaths;
    }

    public ConfigurableFileCollection getCompileModules() {
        return this.compileModules;
    }

    public void addTaskDependency(TaskDependency taskDependency) {
        this.taskDependencies.add(taskDependency);
    }

    public List<TaskDependency> getTaskDependencies() {
        return this.taskDependencies;
    }

    public List<XcodeBinary> getBinaries() {
        return this.binaries;
    }

    private static String toFileType(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return FileTypes.MACH_O_EXECUTABLE.identifier;
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.MACH_O_DYNAMIC_LIBRARY.identifier;
        }
        if (PBXTarget.ProductType.STATIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.ARCHIVE_LIBRARY.identifier;
        }
        return "compiled";
    }

    public Property<SwiftVersion> getSwiftSourceCompatibility() {
        return this.swiftSourceCompatibility;
    }

    public void addBinary(String configuration, Provider<? extends FileSystemLocation> outputFile, String architectureName) {
        this.binaries.add(new XcodeBinary(configuration, outputFile, architectureName));
        if (configuration.contains("Debug")) {
            this.debugOutputFile = outputFile;
        }
    }

    public Property<String> getDefaultConfigurationName() {
        return this.defaultConfigurationName;
    }
}

