/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import com.google.common.base.Preconditions;
import org.gradle.internal.id.UniqueId;

public class OriginMetadata {
    private final UniqueId buildInvocationId;
    private final long executionTime;
    private final boolean producedByCurrentBuild;

    public static OriginMetadata fromCurrentBuild(UniqueId buildInvocationId, long executionTime) {
        return new OriginMetadata(buildInvocationId, executionTime, true);
    }

    public static OriginMetadata fromPreviousBuild(UniqueId buildInvocationId, long executionTime) {
        return new OriginMetadata(buildInvocationId, executionTime, false);
    }

    @Deprecated
    protected OriginMetadata(UniqueId buildInvocationId, long executionTime) {
        this(buildInvocationId, executionTime, true);
    }

    private OriginMetadata(UniqueId buildInvocationId, long executionTime, boolean producedByCurrentBuild) {
        this.buildInvocationId = (UniqueId)Preconditions.checkNotNull((Object)buildInvocationId, (Object)"buildInvocationId");
        this.executionTime = executionTime;
        this.producedByCurrentBuild = producedByCurrentBuild;
    }

    public UniqueId getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public boolean isProducedByCurrentBuild() {
        return this.producedByCurrentBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginMetadata that = (OriginMetadata)o;
        return this.executionTime == that.executionTime && this.buildInvocationId.equals((Object)that.buildInvocationId) && this.producedByCurrentBuild == that.producedByCurrentBuild;
    }

    public int hashCode() {
        int result = this.buildInvocationId.hashCode();
        result = 31 * result + (int)(this.executionTime ^ this.executionTime >>> 32);
        result = 31 * result + (this.producedByCurrentBuild ? 1 : 0);
        return result;
    }

    public String toString() {
        return "OriginMetadata{buildInvocationId=" + this.buildInvocationId + ", executionTime=" + this.executionTime + ", producedByCurrentBuild=" + this.producedByCurrentBuild + '}';
    }
}

