"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const miscellaneous_1 = require("../utils/miscellaneous");
const debug_1 = require("debug");
const debug = debug_1.default('axm:metricfromdump');
class MetricFromDump {
    constructor(metricFeature, conf) {
        this.conf = Array.isArray(conf) ? conf : [conf];
        this.metricFeature = metricFeature;
    }
    init() {
        const self = this;
        for (let i = 0; i < this.conf.length; i++) {
            (function (index) {
                self.metricFeature.metric({
                    name: self.conf[index].name,
                    type: `internal/libuv/${self.conf[index].name}`,
                    value: () => {
                        return miscellaneous_1.default.getValueFromDump(self.conf[index].property, self.conf[index].parentProperty);
                    }
                });
            })(i);
        }
    }
    destroy() {
        debug(`${this.conf.name} metric destroyed !`);
    }
}
exports.default = MetricFromDump;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0cmljRnJvbUR1bXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbWV0cmljcy9tZXRyaWNGcm9tRHVtcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBLDBEQUE4QztBQUU5QyxpQ0FBeUI7QUFFekIsTUFBTSxLQUFLLEdBQUcsZUFBSyxDQUFDLG9CQUFvQixDQUFDLENBQUE7QUFFekM7SUFJRSxZQUFhLGFBQTZCLEVBQUUsSUFBSTtRQUM5QyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQTtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQTtJQUNwQyxDQUFDO0lBRUQsSUFBSTtRQUNGLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQTtRQUVqQixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUU7WUFDekMsQ0FBQyxVQUFVLEtBQUs7Z0JBQ2QsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUM7b0JBQ3hCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLElBQUk7b0JBQzNCLElBQUksRUFBRSxrQkFBa0IsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLEVBQUU7b0JBQy9DLEtBQUssRUFBRSxHQUFHLEVBQUU7d0JBQ1YsT0FBTyx1QkFBUyxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLENBQUE7b0JBQy9GLENBQUM7aUJBQ0YsQ0FBQyxDQUFBO1lBQ0osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7U0FDTjtJQUNILENBQUM7SUFFRCxPQUFPO1FBQ0wsS0FBSyxDQUFDLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLHFCQUFxQixDQUFDLENBQUE7SUFDL0MsQ0FBQztDQUNGO0FBNUJELGlDQTRCQyJ9