/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLOntologyChangeRecord
implements Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLOntologyID ontologyID;
    @Nonnull
    private final OWLOntologyChangeData data;

    public OWLOntologyChangeRecord(@Nonnull OWLOntologyID ontologyID, @Nonnull OWLOntologyChangeData data) {
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ontologyID, "ontologyID must not be null");
        this.data = OWLAPIPreconditions.checkNotNull(data, "data must not be null");
    }

    @Nonnull
    public static OWLOntologyChangeRecord createFromOWLOntologyChange(@Nonnull OWLOntologyChange change) {
        OWLAPIPreconditions.checkNotNull(change, "change must not be null");
        OWLOntologyID ontologyId = change.getOntology().getOntologyID();
        OWLOntologyChangeData data = change.getChangeData();
        return new OWLOntologyChangeRecord(ontologyId, data);
    }

    @Nonnull
    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    @Nonnull
    public OWLOntologyChangeData getData() {
        return this.data;
    }

    public OWLOntologyChange createOntologyChange(OWLOntologyManager manager) {
        OWLOntology ontology = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null").getOntology(this.ontologyID);
        if (ontology == null) {
            throw new UnknownOWLOntologyException(this.ontologyID);
        }
        return this.data.createOntologyChange(ontology);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyChangeRecord)) {
            return false;
        }
        OWLOntologyChangeRecord other = (OWLOntologyChangeRecord)obj;
        return this.ontologyID.equals(other.ontologyID) && this.data.equals(other.data);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.ontologyID.hashCode() + this.data.hashCode();
    }

    public String toString() {
        return this.getName() + '(' + this.ontologyID + ' ' + this.data + ')';
    }

    public String getName() {
        return "OWLOntologyChangeRecord";
    }
}

