/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.util.BitUtil;

public final class Tessellator {
    private static final int VERTEX_THRESHOLD = 80;

    private Tessellator() {
    }

    public static final List<Triangle> tessellate(Polygon polygon) {
        List<Triangle> result;
        boolean mortonOptimized;
        Node outerNode = Tessellator.createDoublyLinkedList(polygon, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in Tessellator!");
        }
        if (polygon.numHoles() > 0) {
            outerNode = Tessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.sortByMorton(outerNode);
        }
        if ((result = Tessellator.earcutLinkedList(outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized)).size() == 0) {
            throw new IllegalArgumentException("Unable to Tessellate shape [" + polygon + "]. Possible malformed shape detected.");
        }
        return result;
    }

    private static final Node createDoublyLinkedList(Polygon polygon, int startIndex, GeoUtils.WindingOrder windingOrder) {
        Node lastNode = null;
        if (windingOrder == polygon.getWindingOrder()) {
            for (int i = 0; i < polygon.numPoints(); ++i) {
                if (lastNode != null && Tessellator.filter(polygon, i, lastNode)) continue;
                lastNode = Tessellator.insertNode(polygon, startIndex++, i, lastNode);
            }
        } else {
            for (int i = polygon.numPoints() - 1; i >= 0; --i) {
                if (lastNode != null && Tessellator.filter(polygon, i, lastNode)) continue;
                lastNode = Tessellator.insertNode(polygon, startIndex++, i, lastNode);
            }
        }
        if (lastNode != null && Tessellator.isVertexEquals(lastNode, lastNode.next)) {
            Tessellator.removeNode(lastNode);
            lastNode = lastNode.next;
        }
        return lastNode;
    }

    private static final Node eliminateHoles(Polygon polygon, Node outerNode) {
        int i;
        ArrayList<Node> holeList = new ArrayList<Node>();
        Polygon[] holes = polygon.getHoles();
        int nodeIndex = 0;
        for (i = 0; i < polygon.numHoles(); ++i) {
            Node list = Tessellator.createDoublyLinkedList(holes[i], nodeIndex += holes[i].numPoints(), GeoUtils.WindingOrder.CCW);
            if (list == list.next) {
                list.isSteiner = true;
            }
            if (list == null) continue;
            holeList.add(Tessellator.fetchLeftmost(list));
        }
        holeList.sort((pNodeA, pNodeB) -> pNodeA.getX() < pNodeB.getX() ? -1 : (pNodeA.getX() == pNodeB.getX() ? 0 : 1));
        for (i = 0; i < holeList.size(); ++i) {
            Node holeNode = (Node)holeList.get(i);
            Tessellator.eliminateHole(holeNode, outerNode);
            outerNode = Tessellator.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static final void eliminateHole(Node holeNode, Node outerNode) {
        if ((outerNode = Tessellator.fetchHoleBridge(holeNode, outerNode)) != null) {
            Node node = Tessellator.splitPolygon(outerNode, holeNode);
            Tessellator.filterPoints(node, node.next);
        }
    }

    private static final Node fetchHoleBridge(Node holeNode, Node outerNode) {
        Node p = outerNode;
        double qx = Double.NEGATIVE_INFINITY;
        double hx = holeNode.getX();
        double hy = holeNode.getY();
        Node connection = null;
        do {
            double x;
            if (!(hy <= p.getY()) || !(hy >= p.next.getY()) || !((x = p.getX() + (hy - p.getY()) * (p.next.getX() - p.getX()) / (p.next.getY() - p.getY())) <= hx) || !(x > qx)) continue;
            qx = x;
            Node node = connection = p.getX() < p.next.getX() ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (connection == null) {
            return null;
        }
        if (hx == connection.getX()) {
            return connection.previous;
        }
        Node stop = connection;
        double mx = connection.getX();
        double my = connection.getY();
        double tanMin = Double.POSITIVE_INFINITY;
        p = connection.next;
        while (p != stop) {
            double tan;
            if (hx > p.getX() && p.getX() >= mx && Tessellator.pointInEar(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, mx, my) && ((tan = Math.abs(hy - my) / (hx - mx)) < tanMin || tan == tanMin && p.getX() > connection.getX()) && Tessellator.isLocallyInside(p, holeNode)) {
                connection = p;
                tanMin = tan;
            }
            p = p.next;
        }
        return connection;
    }

    private static final Node fetchLeftmost(Node start) {
        Node node = start;
        Node leftMost = start;
        do {
            if (!(node.getX() < leftMost.getX())) continue;
            leftMost = node;
        } while ((node = node.next) != start);
        return leftMost;
    }

    private static final List<Triangle> earcutLinkedList(Node currEar, List<Triangle> tessellation, State state, boolean mortonOptimized) {
        block9: {
            block5: while (true) {
                if (currEar == null || currEar.previous == currEar.next) {
                    return tessellation;
                }
                Node stop = currEar;
                do {
                    boolean isReflex;
                    Node prevNode = currEar.previous;
                    Node nextNode = currEar.next;
                    boolean bl = isReflex = Tessellator.area(prevNode.getX(), prevNode.getY(), currEar.getX(), currEar.getY(), nextNode.getX(), nextNode.getY()) >= 0.0;
                    if (!isReflex && Tessellator.isEar(currEar, mortonOptimized)) {
                        tessellation.add(new Triangle(prevNode, currEar, nextNode));
                        Tessellator.removeNode(currEar);
                        currEar = nextNode.next;
                        stop = nextNode.next;
                        continue;
                    }
                    currEar = nextNode;
                    if (currEar != stop) continue;
                    switch (state) {
                        case INIT: {
                            currEar = Tessellator.filterPoints(currEar, null);
                            state = State.CURE;
                            continue block5;
                        }
                        case CURE: {
                            currEar = Tessellator.cureLocalIntersections(currEar, tessellation);
                            state = State.SPLIT;
                            continue block5;
                        }
                        case SPLIT: {
                            Tessellator.splitEarcut(currEar, tessellation, mortonOptimized);
                        }
                    }
                    break block9;
                } while (currEar.previous != currEar.next);
                break;
            }
        }
        return tessellation;
    }

    private static final boolean isEar(Node ear, boolean mortonOptimized) {
        if (mortonOptimized) {
            return Tessellator.mortonIsEar(ear);
        }
        Node node = ear.next.next;
        while (node != ear.previous) {
            if (Tessellator.pointInEar(node.getX(), node.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(node.previous.getX(), node.previous.getY(), node.getX(), node.getY(), node.next.getX(), node.next.getY()) >= 0.0) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    private static final boolean mortonIsEar(Node ear) {
        int idx;
        double ax = ear.previous.x;
        double ay = ear.previous.y;
        double bx = ear.x;
        double by = ear.y;
        double cx = ear.next.x;
        double cy = ear.next.y;
        int minTX = StrictMath.min(StrictMath.min(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(StrictMath.min(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(StrictMath.max(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(StrictMath.max(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave((int)minTX, (int)minTY);
        long maxZ = BitUtil.interleave((int)maxTX, (int)maxTY);
        Node node = ear.nextZ;
        while (node != null && Long.compareUnsigned(node.morton, maxZ) <= 0) {
            if (Long.compareUnsigned(node.morton, maxZ) <= 0 && (idx = node.idx) != ear.previous.idx && idx != ear.next.idx && Tessellator.pointInEar(node.x, node.y, ax, ay, bx, by, cx, cy) && Tessellator.area(node.previous.x, node.previous.y, node.x, node.y, node.next.x, node.next.y) >= 0.0) {
                return false;
            }
            node = node.nextZ;
        }
        node = ear.previousZ;
        while (node != null && Long.compareUnsigned(node.morton, minZ) >= 0) {
            if (Long.compareUnsigned(node.morton, maxZ) <= 0 && (idx = node.idx) != ear.previous.idx && idx != ear.next.idx && Tessellator.pointInEar(node.x, node.y, ax, ay, bx, by, cx, cy) && Tessellator.area(node.previous.x, node.previous.y, node.x, node.y, node.next.x, node.next.y) >= 0.0) {
                return false;
            }
            node = node.previousZ;
        }
        return true;
    }

    private static final Node cureLocalIntersections(Node startNode, List<Triangle> tessellation) {
        Node node = startNode;
        do {
            Node b;
            Node nextNode = node.next;
            Node a = node.previous;
            if (Tessellator.isVertexEquals(a, b = nextNode.next) || !Tessellator.linesIntersect(a.getX(), a.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), b.getX(), b.getY()) || !Tessellator.isLocallyInside(a, b) || !Tessellator.isLocallyInside(b, a)) continue;
            tessellation.add(new Triangle(a, node, b));
            Tessellator.removeNode(node);
            Tessellator.removeNode(node.next);
            node = startNode = b;
        } while ((node = node.next) != startNode);
        return node;
    }

    private static final void splitEarcut(Node start, List<Triangle> tessellation, boolean mortonIndexed) {
        Node searchNode = start;
        do {
            Node nextNode = searchNode.next;
            Node diagonal = nextNode.next;
            while (diagonal != searchNode.previous) {
                if (Tessellator.isValidDiagonal(searchNode, diagonal)) {
                    Node splitNode = Tessellator.splitPolygon(searchNode, diagonal);
                    searchNode = Tessellator.filterPoints(searchNode, searchNode.next);
                    splitNode = Tessellator.filterPoints(splitNode, splitNode.next);
                    Tessellator.earcutLinkedList(searchNode, tessellation, State.INIT, mortonIndexed);
                    Tessellator.earcutLinkedList(splitNode, tessellation, State.INIT, mortonIndexed);
                    return;
                }
                diagonal = diagonal.next;
            }
        } while ((searchNode = searchNode.next) != start);
    }

    private static final Node splitPolygon(Node a, Node b) {
        Node a2 = new Node(a);
        Node b2 = new Node(b);
        Node an = a.next;
        Node bp = b.previous;
        a.next = b;
        a.nextZ = b;
        b.previous = a;
        b.previousZ = a;
        an.previous = a2;
        an.previousZ = a2;
        b2.next = a2;
        b2.nextZ = a2;
        a2.previous = b2;
        a2.previousZ = b2;
        bp.next = b2;
        bp.nextZ = b2;
        return b2;
    }

    private static final boolean isValidDiagonal(Node a, Node b) {
        return a.next.idx != b.idx && a.previous.idx != b.idx && !Tessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) && Tessellator.isLocallyInside(a, b) && Tessellator.isLocallyInside(b, a) && Tessellator.middleInsert(a, a.getX(), a.getY(), b.getX(), b.getY());
    }

    private static final boolean isLocallyInside(Node a, Node b) {
        if (Tessellator.area(a.previous.getX(), a.previous.getY(), a.getX(), a.getY(), a.next.getX(), a.next.getY()) < 0.0) {
            return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.next.getX(), a.next.getY()) >= 0.0 && Tessellator.area(a.getX(), a.getY(), a.previous.getX(), a.previous.getY(), b.getX(), b.getY()) >= 0.0;
        }
        return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.previous.getX(), a.previous.getY()) < 0.0 || Tessellator.area(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY()) < 0.0;
    }

    private static final boolean middleInsert(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        boolean lIsInside = false;
        double lDx = (x0 + x1) / 2.0;
        double lDy = (y0 + y1) / 2.0;
        do {
            Node nextNode = node.next;
            if (node.getY() > lDy == nextNode.getY() > lDy || !(lDx < (nextNode.getX() - node.getX()) * (lDy - node.getY()) / (nextNode.getY() - node.getY()) + node.getX())) continue;
            boolean bl = lIsInside = !lIsInside;
        } while ((node = node.next) != start);
        return lIsInside;
    }

    private static final boolean isIntersectingPolygon(Node start, double x0, double y0, double x1, double y1) {
        Node nextNode;
        Node node = start;
        do {
            nextNode = node.next;
            if (node.getX() == x0 || node.getY() == y0 || nextNode.getX() == x0 || nextNode.getY() == y0 || node.getX() == x1 || node.getY() == y1 || nextNode.getX() == x1 || nextNode.getY() == y1) continue;
            return Tessellator.linesIntersect(node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), x0, y0, x1, y1);
        } while ((node = nextNode) != start);
        return false;
    }

    public static final boolean linesIntersect(double aX0, double aY0, double aX1, double aY1, double bX0, double bY0, double bX1, double bY1) {
        return Tessellator.area(aX0, aY0, aX1, aY1, bX0, bY0) > 0.0 != Tessellator.area(aX0, aY0, aX1, aY1, bX1, bY1) > 0.0 && Tessellator.area(bX0, bY0, bX1, bY1, aX0, aY0) > 0.0 != Tessellator.area(bX0, bY0, bX1, bY1, aX1, aY1) > 0.0;
    }

    private static final void sortByMorton(Node start) {
        start.previousZ.nextZ = null;
        start.previousZ = null;
        Tessellator.tathamSort(start);
    }

    private static final void tathamSort(Node list) {
        int numMerges;
        int inSize = 1;
        if (list == null) {
            return;
        }
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int i = 0;
                int pSize = 0;
                while (i < inSize && q != null) {
                    ++i;
                    ++pSize;
                    q = q.nextZ;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e;
                    if (pSize == 0) {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else if (Long.compareUnsigned(p.morton, q.morton) <= 0) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e;
                    } else {
                        list = e;
                    }
                    e.previousZ = tail;
                    tail = e;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
    }

    private static boolean filter(Polygon polygon, int i, Node node) {
        boolean equal;
        double x = polygon.getPolyLon(i);
        double y = polygon.getPolyLat(i);
        boolean bl = equal = x == node.getX() && y == node.getY();
        if (equal) {
            return true;
        }
        if (node.previous == node || node.previous.previous == node) {
            return false;
        }
        return Tessellator.area(node.previous.previous.getX(), node.previous.previous.getY(), node.previous.getX(), node.previous.getY(), x, y) == 0.0;
    }

    private static final Node filterPoints(Node start, Node end) {
        boolean continueIteration;
        if (start == null) {
            return start;
        }
        if (end == null) {
            end = start;
        }
        Node node = start;
        do {
            continueIteration = false;
            Node nextNode = node.next;
            Node prevNode = node.previous;
            if (!node.isSteiner && Tessellator.isVertexEquals(node, nextNode) || Tessellator.area(prevNode.getX(), prevNode.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY()) == 0.0) {
                Tessellator.removeNode(node);
                node = end = prevNode;
                if (node == nextNode) break;
                continueIteration = true;
                continue;
            }
            node = nextNode;
        } while (continueIteration || node != end);
        return end;
    }

    private static final Node insertNode(Polygon polygon, int index, int vertexIndex, Node lastNode) {
        Node node = new Node(polygon, index, vertexIndex);
        if (lastNode == null) {
            node.previous = node;
            node.previousZ = node;
            node.next = node;
            node.nextZ = node;
        } else {
            node.next = lastNode.next;
            node.nextZ = lastNode.nextZ;
            node.previous = lastNode;
            node.previousZ = lastNode;
            lastNode.next.previous = node;
            lastNode.nextZ.previousZ = node;
            lastNode.next = node;
            lastNode.nextZ = node;
        }
        return node;
    }

    private static final void removeNode(Node node) {
        node.next.previous = node.previous;
        node.previous.next = node.next;
        if (node.previousZ != null) {
            node.previousZ.nextZ = node.nextZ;
        }
        if (node.nextZ != null) {
            node.nextZ.previousZ = node.previousZ;
        }
    }

    private static final boolean isVertexEquals(Node a, Node b) {
        return a.getX() == b.getX() && a.getY() == b.getY();
    }

    private static double area(double aX, double aY, double bX, double bY, double cX, double cY) {
        return (bY - aY) * (cX - bX) - (bX - aX) * (cY - bY);
    }

    private static boolean pointInEar(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        return (cx - x) * (ay - y) - (ax - x) * (cy - y) >= 0.0 && (ax - x) * (by - y) - (bx - x) * (ay - y) >= 0.0 && (bx - x) * (cy - y) - (cx - x) * (by - y) >= 0.0;
    }

    public static boolean pointInTriangle(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        int a = GeoUtils.orient((double)x, (double)y, (double)ax, (double)ay, (double)bx, (double)by);
        int b = GeoUtils.orient((double)x, (double)y, (double)bx, (double)by, (double)cx, (double)cy);
        if (a == 0 || b == 0 || a < 0 == b < 0) {
            int c = GeoUtils.orient((double)x, (double)y, (double)cx, (double)cy, (double)ax, (double)ay);
            return c == 0 || c < 0 == (b < 0 || a < 0);
        }
        return false;
    }

    public static final boolean pointInPolygon(List<Triangle> tessellation, double lat, double lon) {
        for (int i = 0; i < tessellation.size(); ++i) {
            if (!tessellation.get(i).containsPoint(lat, lon)) continue;
            return true;
        }
        return false;
    }

    public static final class Triangle {
        Node[] vertex = new Node[3];

        protected Triangle(Node a, Node b, Node c) {
            Node temp;
            Node tA = a;
            Node tB = b;
            Node tC = c;
            if (a.compare(b) > 0) {
                temp = tA;
                tA = tB;
                tB = temp;
            }
            if (b.compare(c) > 0) {
                temp = tB;
                tB = tC;
                tC = temp;
            }
            if (a.compare(b) > 0) {
                temp = tA;
                tA = tB;
                tB = temp;
            }
            this.vertex[0] = tA;
            this.vertex[1] = tB;
            this.vertex[2] = tC;
        }

        public int getEncodedX(int vertex) {
            return this.vertex[vertex].x;
        }

        public int getEncodedY(int vertex) {
            return this.vertex[vertex].y;
        }

        public double getLat(int vertex) {
            return this.vertex[vertex].getLat();
        }

        public double getLon(int vertex) {
            return this.vertex[vertex].getLon();
        }

        protected boolean containsPoint(double lat, double lon) {
            return Tessellator.pointInTriangle(lon, lat, this.vertex[0].getLon(), this.vertex[0].getLat(), this.vertex[1].getLon(), this.vertex[1].getLat(), this.vertex[2].getLon(), this.vertex[2].getLat());
        }

        public String toString() {
            String result = this.vertex[0].x + ", " + this.vertex[0].y + " " + this.vertex[1].x + ", " + this.vertex[1].y + " " + this.vertex[2].x + ", " + this.vertex[2].y;
            return result;
        }
    }

    protected static class Node {
        private final int idx;
        private final int vrtxIdx;
        private final Polygon polygon;
        private final int x;
        private final int y;
        private final long morton;
        private Node previous;
        private Node next;
        private Node previousZ;
        private Node nextZ;
        private boolean isSteiner = false;

        protected Node(Polygon polygon, int index, int vertexIndex) {
            this.idx = index;
            this.vrtxIdx = vertexIndex;
            this.polygon = polygon;
            this.y = GeoEncodingUtils.encodeLatitude((double)polygon.getPolyLat(this.vrtxIdx));
            this.x = GeoEncodingUtils.encodeLongitude((double)polygon.getPolyLon(this.vrtxIdx));
            this.morton = BitUtil.interleave((int)(this.x ^ Integer.MIN_VALUE), (int)(this.y ^ Integer.MIN_VALUE));
            this.previous = null;
            this.next = null;
            this.previousZ = null;
            this.nextZ = null;
        }

        protected Node(Node other) {
            this.idx = other.idx;
            this.vrtxIdx = other.vrtxIdx;
            this.polygon = other.polygon;
            this.morton = other.morton;
            this.x = other.x;
            this.y = other.y;
            this.previous = other.previous;
            this.next = other.next;
            this.previousZ = other.previousZ;
            this.nextZ = other.nextZ;
        }

        public final double getX() {
            return this.polygon.getPolyLon(this.vrtxIdx);
        }

        public final double getY() {
            return this.polygon.getPolyLat(this.vrtxIdx);
        }

        public final double getLon() {
            return this.polygon.getPolyLon(this.vrtxIdx);
        }

        public final double getLat() {
            return this.polygon.getPolyLat(this.vrtxIdx);
        }

        public int compare(Node other) {
            if (this.getLat() > other.getLat()) {
                return 1;
            }
            if (this.getLat() == other.getLat()) {
                if (this.getLon() > other.getLon()) {
                    return 1;
                }
                if (this.getLon() == other.getLon()) {
                    return 0;
                }
            }
            return -1;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.previous == null) {
                builder.append("||-");
            } else {
                builder.append(this.previous.idx + " <- ");
            }
            builder.append(this.idx);
            if (this.next == null) {
                builder.append(" -||");
            } else {
                builder.append(" -> " + this.next.idx);
            }
            return builder.toString();
        }
    }

    private static enum State {
        INIT,
        CURE,
        SPLIT;

    }
}

