/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ProcessorInfo;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class IngestService
implements ClusterStateApplier {
    public static final String NOOP_PIPELINE_NAME = "_none";
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory> processorFactories;
    private volatile Map<String, Pipeline> pipelines = new HashMap<String, Pipeline>();
    private final ThreadPool threadPool;
    private final IngestMetric totalMetrics = new IngestMetric();

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.processorFactories = IngestService.processorFactories(ingestPlugins, new Processor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule(TimeValue.timeValueMillis((long)delay), "generic", (Runnable)command), this));
        this.threadPool = threadPool;
    }

    private static Map<String, Processor.Factory> processorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void delete(final DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerDelete(request, currentState);
            }
        });
    }

    static ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelinesCopy)).build());
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        this.clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerPut(request, currentState);
            }
        });
    }

    public Pipeline getPipeline(String id) {
        return this.pipelines.get(id);
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, Pipeline> pipelines() {
        return this.pipelines;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        Map<String, Pipeline> originalPipelines = this.pipelines;
        this.innerUpdatePipelines(event.previousState(), state);
        if (originalPipelines != this.pipelines) {
            this.pipelines.forEach((id, pipeline) -> {
                Pipeline originalPipeline = (Pipeline)originalPipelines.get(id);
                if (originalPipeline != null) {
                    pipeline.getMetrics().add(originalPipeline.getMetrics());
                    ArrayList<Tuple<Processor, IngestMetric>> oldPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                    ArrayList<Tuple<Processor, IngestMetric>> newPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                    IngestService.getProcessorMetrics(originalPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                    IngestService.getProcessorMetrics(pipeline.getCompoundProcessor(), newPerProcessMetrics);
                    if (newPerProcessMetrics.size() == oldPerProcessMetrics.size()) {
                        Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                        for (Tuple tuple : newPerProcessMetrics) {
                            String type = ((Processor)tuple.v1()).getType();
                            IngestMetric metric = (IngestMetric)tuple.v2();
                            if (!oldMetricsIterator.hasNext()) continue;
                            Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                            String oldType = ((Processor)oldCompositeMetric.v1()).getType();
                            IngestMetric oldMetric = (IngestMetric)oldCompositeMetric.v2();
                            if (!type.equals(oldType)) continue;
                            metric.add(oldMetric);
                        }
                    }
                }
            });
        }
    }

    private static List<Tuple<Processor, IngestMetric>> getProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<Processor, IngestMetric>> processorMetrics) {
        for (Tuple<Processor, IngestMetric> processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            Processor processor = (Processor)processorWithMetric.v1();
            IngestMetric metric = (IngestMetric)processorWithMetric.v2();
            if (processor instanceof CompoundProcessor) {
                IngestService.getProcessorMetrics((CompoundProcessor)processor, processorMetrics);
                continue;
            }
            if (processor instanceof ConditionalProcessor) {
                metric = ((ConditionalProcessor)processor).getMetric();
            }
            processorMetrics.add((Tuple<Processor, IngestMetric>)new Tuple((Object)processor, (Object)metric));
        }
        return processorMetrics;
    }

    private static Pipeline substitutePipeline(String id, ElasticsearchParseException e) {
        String tag = e.getHeaderKeys().contains("processor_tag") ? e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        AbstractProcessor failureProcessor = new AbstractProcessor(tag){

            @Override
            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            @Override
            public String getType() {
                return type;
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, new CompoundProcessor(failureProcessor));
    }

    static ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getXContentType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Map pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        Pipeline pipeline = Pipeline.create(request.getId(), pipelineConfig, this.processorFactories, this.scriptService);
        ArrayList<ElasticsearchException> exceptions = new ArrayList<ElasticsearchException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + entry.getKey() + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void executeBulkRequest(final Iterable<DocWriteRequest<?>> actionRequests, final BiConsumer<IndexRequest, Exception> itemFailureHandler, final Consumer<Exception> completionHandler, final Consumer<IndexRequest> itemDroppedHandler) {
        this.threadPool.executor("write").execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                completionHandler.accept(e);
            }

            @Override
            protected void doRun() {
                for (DocWriteRequest actionRequest : actionRequests) {
                    String pipelineId;
                    IndexRequest indexRequest = null;
                    if (actionRequest instanceof IndexRequest) {
                        indexRequest = (IndexRequest)actionRequest;
                    } else if (actionRequest instanceof UpdateRequest) {
                        UpdateRequest updateRequest = (UpdateRequest)actionRequest;
                        IndexRequest indexRequest2 = indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
                    }
                    if (indexRequest == null || IngestService.NOOP_PIPELINE_NAME.equals(pipelineId = indexRequest.getPipeline())) continue;
                    try {
                        Pipeline pipeline = (Pipeline)IngestService.this.pipelines.get(pipelineId);
                        if (pipeline == null) {
                            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
                        }
                        IngestService.this.innerExecute(indexRequest, pipeline, itemDroppedHandler);
                        indexRequest.setPipeline(IngestService.NOOP_PIPELINE_NAME);
                    }
                    catch (Exception e) {
                        itemFailureHandler.accept(indexRequest, e);
                    }
                }
                completionHandler.accept(null);
            }
        });
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, pipeline) -> {
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics((String)id, pipeline.getMetrics());
            ArrayList<Tuple<Processor, IngestMetric>> processorMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
            IngestService.getProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                Processor processor = (Processor)t.v1();
                IngestMetric processorMetric = (IngestMetric)t.v2();
                statsBuilder.addProcessorMetrics((String)id, IngestService.getProcessorName(processor), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    static String getProcessorName(Processor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            processor = ((ConditionalProcessor)processor).getProcessor();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (processor instanceof PipelineProcessor) {
            String pipelineName = ((PipelineProcessor)processor).getPipelineName();
            sb.append(":");
            sb.append(pipelineName);
        }
        if ((tag = processor.getTag()) != null && !tag.isEmpty()) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private void innerExecute(IndexRequest indexRequest, Pipeline pipeline, Consumer<IndexRequest> itemDroppedHandler) throws Exception {
        if (pipeline.getProcessors().isEmpty()) {
            return;
        }
        long startTimeInNanos = System.nanoTime();
        try {
            this.totalMetrics.preIngest();
            String index = indexRequest.index();
            String type = indexRequest.type();
            String id = indexRequest.id();
            String routing = indexRequest.routing();
            Long version = indexRequest.version();
            VersionType versionType = indexRequest.versionType();
            Map<String, Object> sourceAsMap = indexRequest.sourceAsMap();
            IngestDocument ingestDocument = new IngestDocument(index, type, id, routing, null, version, versionType, sourceAsMap);
            if (pipeline.execute(ingestDocument) == null) {
                itemDroppedHandler.accept(indexRequest);
            } else {
                Map<IngestDocument.MetaData, Object> metadataMap = ingestDocument.extractMetadata();
                indexRequest.index((String)metadataMap.get((Object)IngestDocument.MetaData.INDEX));
                indexRequest.type((String)metadataMap.get((Object)IngestDocument.MetaData.TYPE));
                indexRequest.id((String)metadataMap.get((Object)IngestDocument.MetaData.ID));
                indexRequest.routing((String)metadataMap.get((Object)IngestDocument.MetaData.ROUTING));
                indexRequest.version(((Number)metadataMap.get((Object)IngestDocument.MetaData.VERSION)).longValue());
                if (metadataMap.get((Object)IngestDocument.MetaData.VERSION_TYPE) != null) {
                    indexRequest.versionType(VersionType.fromString((String)metadataMap.get((Object)IngestDocument.MetaData.VERSION_TYPE)));
                }
                indexRequest.source(ingestDocument.getSourceAndMetadata());
            }
        }
        catch (Exception e) {
            this.totalMetrics.ingestFailed();
            throw e;
        }
        finally {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
            this.totalMetrics.postIngest(ingestTimeInMillis);
        }
    }

    private void innerUpdatePipelines(ClusterState previousState, ClusterState state) {
        IngestMetadata previousIngestMetadata;
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)state.getMetaData().custom("ingest");
        if (Objects.equals(ingestMetadata, previousIngestMetadata = (IngestMetadata)previousState.getMetaData().custom("ingest"))) {
            return;
        }
        HashMap<String, Pipeline> pipelines = new HashMap<String, Pipeline>();
        ArrayList<ElasticsearchParseException> exceptions = new ArrayList<ElasticsearchParseException>();
        for (PipelineConfiguration pipeline : ingestMetadata.getPipelines().values()) {
            try {
                pipelines.put(pipeline.getId(), Pipeline.create(pipeline.getId(), pipeline.getConfigAsMap(), this.processorFactories, this.scriptService));
            }
            catch (ElasticsearchParseException e) {
                pipelines.put(pipeline.getId(), IngestService.substitutePipeline(pipeline.getId(), e));
                exceptions.add(e);
            }
            catch (Exception e) {
                ElasticsearchParseException parseException = new ElasticsearchParseException("Error updating pipeline with id [" + pipeline.getId() + "]", (Throwable)e, new Object[0]);
                pipelines.put(pipeline.getId(), IngestService.substitutePipeline(pipeline.getId(), parseException));
                exceptions.add(parseException);
            }
        }
        this.pipelines = Collections.unmodifiableMap(pipelines);
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }
}

