/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.ByteChannel;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.MakeOpenFile();
    }

    public FileDescriptorIO(Ruby runtime2, IRubyObject fd) {
        super(runtime2, runtime2.getModule("FFI").getClass(CLASS_NAME));
        this.MakeOpenFile();
        ModeFlags modes = FileDescriptorIO.newModeFlags(runtime2, ModeFlags.RDWR);
        int fileno2 = RubyNumeric.fix2int(fd);
        FileStat stat2 = runtime2.getPosix().fstat(fileno2);
        ByteChannel channel = stat2.isSocket() ? new NativeSocketChannel(fileno2) : (stat2.isBlockDev() || stat2.isCharDev() ? new NativeDeviceChannel(fileno2) : new FileDescriptorByteChannel(runtime2, fileno2));
        this.openFile.setChannel(channel);
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = runtime2.defineClassUnder(CLASS_NAME, runtime2.getClass("IO"), Allocator.INSTANCE, module);
        result2.defineAnnotatedMethods(FileDescriptorIO.class);
        result2.defineAnnotatedConstants(FileDescriptorIO.class);
        return result2;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }

    static class FileDescriptorHelper {
        static Constructor<FileDescriptor> CONSTRUCTOR;

        FileDescriptorHelper() {
        }

        public static FileDescriptor wrap(int fileno2) {
            try {
                return CONSTRUCTOR != null ? CONSTRUCTOR.newInstance(fileno2) : new FileDescriptor();
            }
            catch (IllegalAccessException iae) {
                return new FileDescriptor();
            }
            catch (InstantiationException ie) {
                return new FileDescriptor();
            }
            catch (InvocationTargetException ite) {
                return new FileDescriptor();
            }
        }

        static {
            Constructor constructor2;
            try {
                constructor2 = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
                constructor2.setAccessible(true);
            }
            catch (Throwable t) {
                constructor2 = null;
            }
            CONSTRUCTOR = constructor2;
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new FileDescriptorIO(runtime2, klass);
        }
    }
}

