/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.EndpointSelectionType;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.Observer;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.LocalException;
import IceInternal.EndpointI_connectors;
import IceInternal.Ex;
import IceInternal.IPEndpointI;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.Util;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class EndpointHostResolver {
    private final Instance _instance;
    private final int _protocol;
    private final boolean _preferIPv6;
    private boolean _destroyed;
    private ThreadObserver _observer;
    private String _threadName;
    private ExecutorService _executor;

    EndpointHostResolver(Instance instance) {
        this._instance = instance;
        this._protocol = instance.protocolSupport();
        this._preferIPv6 = instance.preferIPv6();
        try {
            this._threadName = Util.createThreadName(this._instance.initializationData().properties, "Ice.HostResolver");
            this._executor = Executors.newFixedThreadPool(1, Util.createThreadFactory(this._instance.initializationData().properties, this._threadName));
            this.updateObserver();
        }
        catch (RuntimeException ex) {
            String s = "cannot create thread for endpoint host resolver thread:\n" + Ex.toString(ex);
            this._instance.initializationData().logger.error(s);
            throw ex;
        }
    }

    synchronized void resolve(final String host, final int port, final EndpointSelectionType selType, final IPEndpointI endpoint, final EndpointI_connectors callback) {
        List<InetSocketAddress> addrs;
        assert (!this._destroyed);
        NetworkProxy networkProxy = this._instance.networkProxy();
        if (networkProxy == null && (addrs = Network.getAddresses(host, port, this._protocol, selType, this._preferIPv6, false)) != null) {
            callback.connectors(endpoint.connectors(addrs, networkProxy));
            return;
        }
        final ThreadObserver threadObserver = this._observer;
        final Observer observer = this.getObserver(endpoint);
        if (observer != null) {
            observer.attach();
        }
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EndpointHostResolver endpointHostResolver = EndpointHostResolver.this;
                synchronized (endpointHostResolver) {
                    if (EndpointHostResolver.this._destroyed) {
                        CommunicatorDestroyedException ex = new CommunicatorDestroyedException();
                        if (observer != null) {
                            observer.failed(ex.ice_id());
                            observer.detach();
                        }
                        callback.exception(ex);
                        return;
                    }
                }
                if (threadObserver != null) {
                    threadObserver.stateChanged(ThreadState.ThreadStateIdle, ThreadState.ThreadStateInUseForOther);
                }
                Observer obsv = observer;
                try {
                    int protocol = EndpointHostResolver.this._protocol;
                    NetworkProxy networkProxy = EndpointHostResolver.this._instance.networkProxy();
                    if (networkProxy != null && (networkProxy = networkProxy.resolveHost(EndpointHostResolver.this._protocol)) != null) {
                        protocol = networkProxy.getProtocolSupport();
                    }
                    List<InetSocketAddress> addresses = Network.getAddresses(host, port, protocol, selType, EndpointHostResolver.this._preferIPv6, true);
                    if (obsv != null) {
                        obsv.detach();
                        obsv = null;
                    }
                    callback.connectors(endpoint.connectors(addresses, networkProxy));
                }
                catch (LocalException ex) {
                    if (obsv != null) {
                        obsv.failed(ex.ice_id());
                        obsv.detach();
                    }
                    callback.exception(ex);
                }
                finally {
                    if (threadObserver != null) {
                        threadObserver.stateChanged(ThreadState.ThreadStateInUseForOther, ThreadState.ThreadStateIdle);
                    }
                }
            }
        });
    }

    synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._executor.shutdown();
    }

    void joinWithThread() throws InterruptedException {
        try {
            while (!this._executor.isTerminated()) {
                this._executor.awaitTermination(100000L, TimeUnit.SECONDS);
            }
        }
        finally {
            if (this._observer != null) {
                this._observer.detach();
            }
        }
    }

    synchronized void updateObserver() {
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            this._observer = obsv.getThreadObserver("Communicator", this._threadName, ThreadState.ThreadStateIdle, this._observer);
            if (this._observer != null) {
                this._observer.attach();
            }
        }
    }

    private Observer getObserver(IPEndpointI endpoint) {
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            return obsv.getEndpointLookupObserver(endpoint);
        }
        return null;
    }
}

