// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface provides access to IceGrid log file contents.
 **/
public interface FileIterator extends com.zeroc.Ice.Object
{
    public static class ReadResult
    {
        public ReadResult()
        {
        }

        /**
         * This constructor makes shallow copies of the results for operation Read.
         * @param returnValue True if EOF is encountered.
         * @param lines The lines read from the file. If there was nothing to
         * read from the file since the last call to read, an empty
         * sequence is returned. The last line of the sequence is always
         * incomplete (and therefore no '\n' should be added when writing
         * the last line to the to the output device).
         **/
        public ReadResult(boolean returnValue, String[] lines)
        {
            this.returnValue = returnValue;
            this.lines = lines;
        }

        /**
         * True if EOF is encountered.
         **/
        public boolean returnValue;
        /**
         * The lines read from the file. If there was nothing to
         * read from the file since the last call to read, an empty
         * sequence is returned. The last line of the sequence is always
         * incomplete (and therefore no '\n' should be added when writing
         * the last line to the to the output device).
         **/
        public String[] lines;

        public void write(com.zeroc.Ice.OutputStream ostr)
        {
            ostr.writeStringSeq(this.lines);
            ostr.writeBool(returnValue);
        }

        public void read(com.zeroc.Ice.InputStream istr)
        {
            this.lines = istr.readStringSeq();
            returnValue = istr.readBool();
        }
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param current The Current object for the invocation.
     * @return An instance of FileIterator.ReadResult.
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     **/
    FileIterator.ReadResult read(int size, com.zeroc.Ice.Current current)
        throws FileNotAvailableException;

    /**
     * Destroy the iterator.
     * @param current The Current object for the invocation.
     **/
    void destroy(com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::FileIterator"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::FileIterator";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_read(FileIterator obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_size;
        iceP_size = istr.readInt();
        inS.endReadParams();
        FileIterator.ReadResult ret = obj.read(iceP_size, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_destroy(FileIterator obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    final static String[] _iceOps =
    {
        "destroy",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "read"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_destroy(this, in, current);
            }
            case 1:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 5:
            {
                return _iceD_read(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
