/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XTable;

public class TableSorter
extends DefaultTableModel
implements MouseListener {
    private boolean ascending = true;
    private TableColumnModel columnModel;
    private JTable tableView;
    private Vector<TableModelListener> evtListenerList = new Vector();
    private int sortColumn = 0;
    private int[] invertedIndex;

    public TableSorter() {
    }

    public TableSorter(Object[] columnNames, int numRows) {
        super(columnNames, numRows);
    }

    @Override
    public void newDataAvailable(TableModelEvent e) {
        super.newDataAvailable(e);
        this.invertedIndex = new int[this.getRowCount()];
        for (int i = 0; i < this.invertedIndex.length; ++i) {
            this.invertedIndex[i] = i;
        }
        this.sort(this.sortColumn, this.ascending);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.evtListenerList.add(l);
        super.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.evtListenerList.remove(l);
        super.removeTableModelListener(l);
    }

    private void removeListeners() {
        for (TableModelListener tnl : this.evtListenerList) {
            super.removeTableModelListener(tnl);
        }
    }

    private void restoreListeners() {
        for (TableModelListener tnl : this.evtListenerList) {
            super.addTableModelListener(tnl);
        }
    }

    private int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.getClass().equals(o2.getClass()) && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    private void sort(int column, boolean isAscending) {
        XMBeanAttributes attrs;
        XMBeanAttributes xMBeanAttributes = attrs = this.tableView instanceof XMBeanAttributes ? (XMBeanAttributes)this.tableView : null;
        if (attrs != null && attrs.isEditing()) {
            attrs.cancelCellEditing();
        }
        this.removeListeners();
        if (JConsole.isDebug()) {
            System.err.println("sorting table against column=" + column + " ascending=" + isAscending);
        }
        this.quickSort(0, this.getRowCount() - 1, column, isAscending);
        this.restoreListeners();
        if (attrs != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector data = (Vector)this.dataVector.elementAt(i);
                attrs.updateRowHeight(data.elementAt(1), i);
            }
        }
    }

    private boolean compareS(Object s1, Object s2, boolean isAscending) {
        if (isAscending) {
            return this.compare(s1, s2) > 0;
        }
        return this.compare(s1, s2) < 0;
    }

    private boolean compareG(Object s1, Object s2, boolean isAscending) {
        if (isAscending) {
            return this.compare(s1, s2) < 0;
        }
        return this.compare(s1, s2) > 0;
    }

    private void quickSort(int lo0, int hi0, int key, boolean isAscending) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = this.getValueAt((lo0 + hi0) / 2, key);
            while (lo <= hi) {
                while (lo < hi0 && this.compareS(mid, this.getValueAt(lo, key), isAscending)) {
                    ++lo;
                }
                while (hi > lo0 && this.compareG(mid, this.getValueAt(hi, key), isAscending)) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(lo, hi, key);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(lo0, hi, key, isAscending);
            }
            if (lo <= hi0) {
                this.quickSort(lo, hi0, key, isAscending);
            }
        }
    }

    private Vector getRow(int row) {
        return (Vector)this.dataVector.elementAt(row);
    }

    private void setRow(Vector data, int row) {
        this.dataVector.setElementAt(data, row);
    }

    private void swap(int i, int j, int column) {
        Vector data = this.getRow(i);
        this.setRow(this.getRow(j), i);
        this.setRow(data, j);
        int a = this.invertedIndex[i];
        this.invertedIndex[i] = this.invertedIndex[j];
        this.invertedIndex[j] = a;
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, !this.ascending);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortColumn = column;
        this.sort(column, ascending);
    }

    public int getIndexOfRow(int row) {
        return this.invertedIndex[row];
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        this.tableView = table;
        this.columnModel = this.tableView.getColumnModel();
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int viewColumn = this.columnModel.getColumnIndexAtX(e.getX());
        int column = this.tableView.convertColumnIndexToModel(viewColumn);
        if (e.getClickCount() == 1 && column != -1) {
            if (this.tableView instanceof XTable) {
                XTable attrs = (XTable)this.tableView;
                attrs.sortRequested(column);
            }
            this.tableView.invalidate();
            this.sortByColumn(column);
            this.tableView.validate();
            this.tableView.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

