/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;

public final class ExportUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    private static final String BUTTON_EXPORT = messages.getString("ExportUtils_ButtonExport");
    private static final String NPS_FILE = messages.getString("ExportUtils_NpsFile");
    private static final String CSV_FILE = messages.getString("ExportUtils_CsvFile");
    private static final String HTML_FILE = messages.getString("ExportUtils_HtmlFile");
    private static final String XML_FILE = messages.getString("ExportUtils_XmlFile");
    private static final String PNG_FILE = messages.getString("ExportUtils_PngFile");
    private static final String FILE_FILTER_DESCR = messages.getString("ExportUtils_FileFilterDescr");
    private static final String MSG_CANNOT_OVERWRITE_SOURCE = messages.getString("ExportUtils_MsgCannotOverwriteSource");
    private static final String MSG_EXPORT_SNAPSHOT_FAILED = messages.getString("ExportUtils_MsgExportSnapshotFailed");
    private static final String MSG_EXPORT_IMAGE_FAILED = messages.getString("ExportUtils_MsgExportImageFailed");
    private static final String TITLE_OVERWRITE_FILE = messages.getString("ExportUtils_TitleOverwriteFile");
    private static final String MSG_OVERWRITE_FILE = messages.getString("ExportUtils_MsgOverwriteFile");
    private static final Logger LOGGER = Logger.getLogger(ExportUtils.class.getName());
    public static final FormatFilter NPS_FILTER = new FormatFilter(NPS_FILE, "nps");
    public static final FormatFilter CSV_FILTER = new FormatFilter(CSV_FILE, "csv");
    public static final FormatFilter HTML_FILTER = new FormatFilter(HTML_FILE, "html");
    public static final FormatFilter XML_FILTER = new FormatFilter(XML_FILE, "xml");
    public static final FormatFilter PNG_FILTER = new FormatFilter(PNG_FILE, "png");
    private static int LAST_indent = Integer.MIN_VALUE;
    private static String LAST_INDENT;

    public static AbstractButton exportButton(final Component component, String string, final Exportable ... exportableArray) {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"GeneralIcons.SaveAs")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                for (final Exportable exportable : exportableArray) {
                    if (exportable == null || !exportable.isEnabled()) continue;
                    jPopupMenu.add(new JMenuItem(exportable.getName()){

                        @Override
                        protected void fireActionPerformed(ActionEvent actionEvent) {
                            ExportProvider[] exportProviderArray;
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.setDialogType(1);
                            jFileChooser.setFileSelectionMode(2);
                            jFileChooser.setMultiSelectionEnabled(false);
                            jFileChooser.setDialogTitle(exportable.getName());
                            jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                            for (ExportProvider exportProvider : exportProviderArray = exportable.getProviders()) {
                                jFileChooser.addChoosableFileFilter(exportProvider.getFormatFilter());
                            }
                            ExportUtils.showExportDialog(jFileChooser, component, exportProviderArray);
                        }
                    });
                }
            }
        };
        popupButton.setToolTipText(string);
        return popupButton;
    }

    private static void showExportDialog(final JFileChooser jFileChooser, final Component component, final ExportProvider[] exportProviderArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jFileChooser.showDialog(component, BUTTON_EXPORT) != 0) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                FileFilter fileFilter = jFileChooser.getFileFilter();
                for (ExportProvider exportProvider : exportProviderArray) {
                    FormatFilter formatFilter = exportProvider.getFormatFilter();
                    if (!fileFilter.equals(formatFilter)) continue;
                    if (ExportUtils.checkFileExists(file = ExportUtils.checkFileExtension(file, formatFilter.getExtension()))) {
                        exportProvider.export(file);
                        break;
                    }
                    ExportUtils.showExportDialog(jFileChooser, component, exportProviderArray);
                    break;
                }
            }
        });
    }

    private static boolean checkFileExists(File file) {
        return !file.isFile() ? true : ProfilerDialogs.displayConfirmation((String)MSG_OVERWRITE_FILE, (String)TITLE_OVERWRITE_FILE);
    }

    public static File checkFileExtension(File file, String string) {
        if (file.getName().endsWith(string)) {
            return file;
        }
        return new File(file.getPath() + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportCSV(ProfilerTable profilerTable, char c, File file) {
        Exporter exporter = new Exporter(file);
        char c2 = '\"';
        int n = profilerTable.getRowCount();
        int n2 = profilerTable.getColumnCount();
        try {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                exporter.write(c2);
                exporter.write(profilerTable.getColumnName(n3));
                exporter.write(c2);
                if (n3 < n2 - 1) {
                    exporter.write(c);
                    continue;
                }
                exporter.writeln();
            }
            if (exporter.failed()) {
                n3 = 0;
                return n3 != 0;
            }
            if (profilerTable instanceof ProfilerTreeTable) {
                ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)profilerTable;
                TreePath treePath = profilerTreeTable.getNextPath(profilerTreeTable.getRootPath());
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                int n4 = treePath.getPathCount() - 2;
                TreePath treePath2 = treePath;
                do {
                    int n5;
                    if (exporter.failed()) {
                        n5 = 0;
                        return n5 != 0;
                    }
                    for (n5 = 0; n5 < n2; ++n5) {
                        exporter.write(c2);
                        if (profilerTable.getColumnClass(n5) == JTree.class) {
                            for (int i = 0; i < n4; ++i) {
                                exporter.write(' ');
                            }
                        }
                        exporter.write(profilerTreeTable.getStringValue(treeNode, n5));
                        exporter.write(c2);
                        if (n5 < n2 - 1) {
                            exporter.write(c);
                            continue;
                        }
                        exporter.writeln();
                    }
                    treePath = profilerTreeTable.getNextPath(treePath);
                    treeNode = (TreeNode)treePath.getLastPathComponent();
                    n4 = treePath.getPathCount() - 2;
                } while (!treePath2.equals(treePath));
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    int n6;
                    if (exporter.failed()) {
                        n6 = 0;
                        return n6 != 0;
                    }
                    for (n6 = 0; n6 < n2; ++n6) {
                        exporter.write(c2);
                        exporter.write(profilerTable.getStringValue(n3, n6));
                        exporter.write(c2);
                        if (n6 < n2 - 1) {
                            exporter.write(c);
                            continue;
                        }
                        exporter.writeln();
                    }
                }
            }
        }
        finally {
            exporter.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportHTML(ProfilerTable profilerTable, String string, File file) {
        Exporter exporter = new Exporter(file);
        int n = profilerTable.getColumnCount();
        try {
            int n2;
            exporter.writeln("<html>");
            if (exporter.failed()) {
                boolean bl = false;
                return bl;
            }
            exporter.writeln(" <head>");
            exporter.writeln("  <meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" />");
            exporter.write("  <title>");
            exporter.write(string);
            exporter.writeln("</title>");
            exporter.writeln(" </head>");
            exporter.writeln(" <body>");
            exporter.writeln("  <table>");
            exporter.writeln("   <tr>");
            for (n2 = 0; n2 < n; ++n2) {
                exporter.write("    <th>");
                exporter.write(ExportUtils.escapeHTML(profilerTable.getColumnName(n2)));
                exporter.writeln("</th>");
            }
            exporter.writeln("   </tr>");
            if (exporter.failed()) {
                n2 = 0;
                return n2 != 0;
            }
            if (profilerTable instanceof ProfilerTreeTable) {
                ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)profilerTable;
                TreePath treePath = profilerTreeTable.getNextPath(profilerTreeTable.getRootPath());
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                int n3 = treePath.getPathCount() - 2;
                TreePath treePath2 = treePath;
                do {
                    int n4;
                    if (exporter.failed()) {
                        n4 = 0;
                        return n4 != 0;
                    }
                    exporter.writeln("   <tr>");
                    for (n4 = 0; n4 < n; ++n4) {
                        exporter.write("    <td><pre>");
                        if (profilerTable.getColumnClass(n4) == JTree.class) {
                            for (int i = 0; i < n3; ++i) {
                                exporter.write('.');
                            }
                        }
                        exporter.write(ExportUtils.escapeHTML(profilerTreeTable.getStringValue(treeNode, n4)));
                        exporter.writeln("</pre></td>");
                    }
                    exporter.writeln("   </tr>");
                    treePath = profilerTreeTable.getNextPath(treePath);
                    treeNode = (TreeNode)treePath.getLastPathComponent();
                    n3 = treePath.getPathCount() - 2;
                } while (!treePath2.equals(treePath));
            } else {
                n2 = profilerTable.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    int n5;
                    if (exporter.failed()) {
                        n5 = 0;
                        return n5 != 0;
                    }
                    exporter.writeln("   <tr>");
                    for (n5 = 0; n5 < n; ++n5) {
                        exporter.write("    <td><pre>");
                        exporter.write(ExportUtils.escapeHTML(profilerTable.getStringValue(i, n5)));
                        exporter.writeln("</pre></td>");
                    }
                    exporter.writeln("   </tr>");
                }
            }
            exporter.writeln("  </table>");
            exporter.writeln(" </body>");
            exporter.writeln("</html>");
        }
        finally {
            exporter.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportXML(ProfilerTable profilerTable, String string, File file) {
        Exporter exporter = new Exporter(file);
        int n = profilerTable.getColumnCount();
        try {
            exporter.writeln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (exporter.failed()) {
                boolean bl = false;
                return bl;
            }
            if (profilerTable instanceof ProfilerTreeTable) {
                ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)profilerTable;
                TreePath treePath = profilerTreeTable.getNextPath(profilerTreeTable.getRootPath());
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                int n2 = treePath.getPathCount();
                TreePath treePath2 = treePath;
                exporter.write("<dataview name=\"");
                exporter.write(string);
                exporter.writeln("\" type=\"tree\">");
                exporter.writeln(" <tree>");
                do {
                    int n3;
                    if (exporter.failed()) {
                        n3 = 0;
                        return n3 != 0;
                    }
                    exporter.write(ExportUtils.indent(n2));
                    exporter.writeln("<node>");
                    for (n3 = 0; n3 < n; ++n3) {
                        exporter.write(ExportUtils.indent(n2));
                        exporter.write(" <property name=\"");
                        exporter.write(ExportUtils.escapeXML(profilerTreeTable.getColumnName(n3)));
                        exporter.write("\" value=\"");
                        exporter.write(ExportUtils.escapeXML(profilerTreeTable.getStringValue(treeNode, n3)));
                        exporter.writeln("\" />");
                    }
                    treePath = profilerTreeTable.getNextPath(treePath);
                    treeNode = (TreeNode)treePath.getLastPathComponent();
                    n3 = n2;
                    n2 = treePath.getPathCount();
                    for (int i = 0; i <= n3 - n2; ++i) {
                        exporter.write(ExportUtils.indent(n3 - i));
                        exporter.writeln("</node>");
                    }
                } while (!treePath2.equals(treePath));
                exporter.writeln(" </tree>");
                exporter.writeln("</dataview>");
            } else {
                int n4;
                int n5 = profilerTable.getRowCount();
                exporter.write("<dataview name=\"");
                exporter.write(string);
                exporter.writeln("\" type=\"table\">");
                exporter.write(" <table rows=\"");
                exporter.write(Integer.toString(n5));
                exporter.write("\" columns=\"");
                exporter.write(Integer.toString(n));
                exporter.writeln("\">");
                exporter.writeln("  <thead>");
                for (n4 = 0; n4 < n; ++n4) {
                    exporter.write("   <th><![CDATA[");
                    exporter.write(ExportUtils.escapeXML(profilerTable.getColumnName(n4)));
                    exporter.writeln("]]></th>");
                }
                exporter.writeln("  </thead>");
                if (exporter.failed()) {
                    n4 = 0;
                    return n4 != 0;
                }
                exporter.writeln("  <tbody>");
                for (n4 = 0; n4 < n5; ++n4) {
                    int n6;
                    if (exporter.failed()) {
                        n6 = 0;
                        return n6 != 0;
                    }
                    exporter.writeln("   <tr>");
                    for (n6 = 0; n6 < n; ++n6) {
                        exporter.write("    <td><![CDATA[");
                        exporter.write(ExportUtils.escapeXML(profilerTable.getStringValue(n4, n6)));
                        exporter.writeln("]]></td>");
                    }
                    exporter.writeln("   </tr>");
                }
                exporter.writeln("  </tbody>");
                exporter.writeln(" </table>");
                exporter.writeln("</dataview>");
            }
        }
        finally {
            exporter.close();
        }
        return true;
    }

    private static String indent(int n) {
        if (LAST_indent == n) {
            return LAST_INDENT;
        }
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return " ";
        }
        if (n == 2) {
            return "  ";
        }
        if (n == 3) {
            return "   ";
        }
        if (n == 4) {
            return "    ";
        }
        if (n == 5) {
            return "     ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        LAST_indent = n;
        LAST_INDENT = stringBuilder.toString();
        return LAST_INDENT;
    }

    private static String escapeHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String escapeXML(String string) {
        return string;
    }

    private static ExecutorService createExecutor(final String string) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Export thread for " + string);
            }
        });
    }

    private ExportUtils() {
    }

    private static final class Exporter {
        private static final int WRT_BUF = 16384;
        private static final int STR_BUF = 32256;
        private volatile boolean failed = false;
        private final File file;
        private StringBuilder buffer;
        private Writer writer;
        private ExecutorService executor;

        Exporter(File file) {
            this.file = file;
            this.buffer = new StringBuilder();
        }

        boolean failed() {
            return this.failed;
        }

        void write(char c) {
            if (this.failed) {
                return;
            }
            this.buffer.append(c);
            this.checkAutoFlush();
        }

        void writeln(char c) {
            if (this.failed) {
                return;
            }
            this.buffer.append(c).append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void write(String string) {
            if (this.failed) {
                return;
            }
            this.buffer.append(string);
            this.checkAutoFlush();
        }

        void writeln(String string) {
            if (this.failed) {
                return;
            }
            this.buffer.append(string).append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void writeln() {
            if (this.failed) {
                return;
            }
            this.buffer.append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void flush() {
            if (this.failed) {
                return;
            }
            if (this.buffer.length() == 0) {
                return;
            }
            final StringBuilder stringBuilder = this.buffer;
            this.buffer = new StringBuilder();
            if (this.executor == null) {
                this.executor = ExportUtils.createExecutor(this.file.getName());
            }
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Exporter.this.writer == null) {
                            Exporter.this.writer = Exporter.createWriter(Exporter.this.file);
                        }
                        Exporter.this.writer.append(stringBuilder);
                    }
                    catch (Throwable throwable) {
                        Exporter.this.failed(throwable);
                    }
                }
            });
        }

        void close() {
            if (this.failed) {
                return;
            }
            this.flush();
            if (this.executor != null) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (Exporter.this.writer != null) {
                            try {
                                Exporter.this.writer.close();
                            }
                            catch (Throwable throwable) {
                                Exporter.this.failed(throwable);
                            }
                        }
                    }
                });
            }
        }

        private void failed(Throwable throwable) {
            this.failed = true;
            LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
            String string = throwable.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
            ProfilerDialogs.displayError((String)("<html><b>" + MSG_EXPORT_SNAPSHOT_FAILED + "</b><br><br>" + string + "</html>"));
        }

        private void checkAutoFlush() {
            if (this.buffer.length() > 32256) {
                this.flush();
            }
        }

        private static Writer createWriter(File file) throws IOException {
            file.toPath();
            CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, charsetEncoder), 16384);
        }
    }

    public static class PNGExportProvider
    extends BaseExportProvider {
        private final Component component;

        public PNGExportProvider(Component component) {
            super(PNG_FILTER);
            this.component = component;
        }

        @Override
        public void export(final File file) {
            final BufferedImage bufferedImage = UIUtils.createScreenshot(this.component);
            ExportUtils.createExecutor(file.getName()).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        file.toPath();
                        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
                        String string = throwable.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                        ProfilerDialogs.displayError((String)("<html><b>" + MSG_EXPORT_IMAGE_FAILED + "</b><br><br>" + string + "</html>"));
                    }
                }
            });
        }
    }

    public static class XMLExportProvider
    extends ProfilerTableExportProvider {
        private final String name;

        public XMLExportProvider(ProfilerTable profilerTable, String string) {
            super(profilerTable, XML_FILTER);
            this.name = string;
        }

        @Override
        protected void export(ProfilerTable profilerTable, File file) {
            ExportUtils.exportXML(profilerTable, this.name, file);
        }
    }

    public static class HTMLExportProvider
    extends ProfilerTableExportProvider {
        private final String name;

        public HTMLExportProvider(ProfilerTable profilerTable, String string) {
            super(profilerTable, HTML_FILTER);
            this.name = string;
        }

        @Override
        protected void export(ProfilerTable profilerTable, File file) {
            ExportUtils.exportHTML(profilerTable, this.name, file);
        }
    }

    public static class CSVExportProvider
    extends ProfilerTableExportProvider {
        public CSVExportProvider(ProfilerTable profilerTable) {
            super(profilerTable, CSV_FILTER);
        }

        @Override
        protected void export(ProfilerTable profilerTable, File file) {
            ExportUtils.exportCSV(profilerTable, ',', file);
        }
    }

    public static abstract class AbstractNPSExportProvider
    extends BaseExportProvider {
        private final File sourceFile;

        public AbstractNPSExportProvider(File file) {
            super(NPS_FILTER);
            this.sourceFile = file;
        }

        @Override
        public void export(File file) {
            if (file.isFile() && file.equals(this.sourceFile)) {
                ProfilerDialogs.displayError((String)MSG_CANNOT_OVERWRITE_SOURCE);
            } else {
                this.doExport(file);
            }
        }

        protected abstract void doExport(File var1);
    }

    public static abstract class ProfilerTableExportProvider
    extends BaseExportProvider {
        private final ProfilerTable table;

        public ProfilerTableExportProvider(ProfilerTable profilerTable, FormatFilter formatFilter) {
            super(formatFilter);
            this.table = profilerTable;
        }

        @Override
        public void export(File file) {
            this.export(this.table, file);
        }

        protected abstract void export(ProfilerTable var1, File var2);
    }

    public static abstract class BaseExportProvider
    extends ExportProvider {
        private final FormatFilter formatFilter;

        protected BaseExportProvider(FormatFilter formatFilter) {
            this.formatFilter = formatFilter;
        }

        @Override
        public FormatFilter getFormatFilter() {
            return this.formatFilter;
        }
    }

    public static abstract class ExportProvider {
        public abstract FormatFilter getFormatFilter();

        public abstract void export(File var1);
    }

    public static abstract class Exportable {
        public abstract String getName();

        public abstract boolean isEnabled();

        public abstract ExportProvider[] getProviders();
    }

    public static class FormatFilter
    extends FileFilter {
        private final String name;
        private final String extension;

        public FormatFilter(String string, String string2) {
            this.name = string;
            this.extension = string2.startsWith(".") ? string2 : "." + string2;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return MessageFormat.format(FILE_FILTER_DESCR, this.name, this.extension);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

