/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.pop3;

import gnu.inet.pop3.POP3Connection;
import gnu.mail.providers.ReadOnlyMessage;
import gnu.mail.providers.pop3.POP3Folder;
import gnu.mail.providers.pop3.POP3Store;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Flags;
import javax.mail.IllegalWriteException;
import javax.mail.MessagingException;

public final class POP3Message
extends ReadOnlyMessage {
    int size;
    String uid;

    POP3Message(POP3Folder folder, int msgnum, int size) throws MessagingException {
        super(folder, msgnum);
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchContent() throws MessagingException {
        POP3Connection connection;
        if (this.content != null) {
            return;
        }
        POP3Connection pOP3Connection = connection = ((POP3Store)this.folder.getStore()).connection;
        synchronized (pOP3Connection) {
            try {
                InputStream retr = connection.retr(this.msgnum);
                this.parse(retr);
                int c = retr.read();
                while (c != -1) {
                    c = retr.read();
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getDataHandler();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getContentStream();
    }

    public int getSize() throws MessagingException {
        if (this.size > -1) {
            return this.size;
        }
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchHeaders() throws MessagingException {
        POP3Connection connection;
        if (this.headers != null) {
            return;
        }
        POP3Connection pOP3Connection = connection = ((POP3Store)this.folder.getStore()).connection;
        synchronized (pOP3Connection) {
            try {
                InputStream top = connection.top(this.msgnum);
                this.headers = this.createInternetHeaders(top);
                int c = top.read();
                while (c != -1) {
                    c = top.read();
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getHeader(name, delimiter);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getAllHeaders();
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaders(names);
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaderLines(names);
    }

    public void writeTo(OutputStream msgStream) throws IOException, MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if (this.content == null) {
            this.fetchContent();
        }
        super.writeTo(msgStream);
    }

    public void writeTo(OutputStream msgStream, String[] ignoreList) throws IOException, MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if (this.content == null) {
            this.fetchContent();
        }
        super.writeTo(msgStream, ignoreList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchUid() throws MessagingException {
        POP3Connection connection;
        if (this.headers != null) {
            return;
        }
        POP3Connection pOP3Connection = connection = ((POP3Store)this.folder.getStore()).connection;
        synchronized (pOP3Connection) {
            try {
                this.uid = connection.uidl(this.msgnum);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public String getUID() throws MessagingException {
        if (this.uid == null) {
            this.fetchUid();
        }
        return this.uid;
    }

    @Override
    public void setFlags(Flags flags, boolean set) throws MessagingException {
        Flags.Flag[] tabFlags = flags.getSystemFlags();
        for (int i = 0; i < tabFlags.length; ++i) {
            Flags.Flag flagToSet = tabFlags[i];
            if (set && !this.flags.contains(flagToSet)) {
                this.flags.add(flagToSet);
            } else if (!set && this.flags.contains(flagToSet)) {
                this.flags.remove(flagToSet);
            }
            if (!flagToSet.equals(Flags.Flag.DELETED)) continue;
            POP3Folder pf = (POP3Folder)this.folder;
            if (set && !pf.deleted.contains((Object)this)) {
                if (2 != this.folder.getMode()) {
                    throw new IllegalWriteException();
                }
                pf.deleted.add(this);
                continue;
            }
            if (set || !pf.deleted.contains((Object)this)) continue;
            pf.deleted.remove((Object)this);
        }
    }
}

