#pragma once
/*
* Copyright 2016 Nu-book Inc.
* Copyright 2016 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "qrcode/QRFinderPattern.h"

namespace ZXing {
namespace QRCode {

/**
* <p>Encapsulates information about finder patterns in an image, including the location of
* the three finder patterns, and their estimated module size.</p>
*
* @author Sean Owen
*/
class FinderPatternInfo
{
public:
	FinderPattern bottomLeft;
	FinderPattern topLeft;
	FinderPattern topRight;

	bool isValid() const { return bottomLeft.isValid() && topLeft.isValid() && topRight.isValid(); }
};

} // QRCode
} // ZXing
