/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;

public abstract class TransformationSubject
implements Describable {
    public static TransformationSubject failure(String displayName, Throwable failure) {
        return new TransformationFailedSubject(displayName, failure);
    }

    public static TransformationSubject initial(File file) {
        return new InitialFileTransformationSubject(file);
    }

    public static TransformationSubject initial(ComponentArtifactIdentifier artifactId, File file) {
        return new InitialArtifactTransformationSubject(artifactId, file);
    }

    public abstract ImmutableList<File> getFiles();

    public abstract Optional<ProjectComponentIdentifier> getProducer();

    @Nullable
    public abstract Throwable getFailure();

    public TransformationSubject transformationFailed(Throwable failure) {
        return TransformationSubject.failure(this.getDisplayName(), failure);
    }

    public TransformationSubject transformationSuccessful(ImmutableList<File> result) {
        return new SubsequentTransformationSubject(this, result);
    }

    private static class SubsequentTransformationSubject
    extends TransformationSubject {
        private final TransformationSubject previous;
        private final ImmutableList<File> files;

        public SubsequentTransformationSubject(TransformationSubject previous, ImmutableList<File> files) {
            this.previous = previous;
            this.files = files;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return this.files;
        }

        @Override
        public Optional<ProjectComponentIdentifier> getProducer() {
            return this.previous.getProducer();
        }

        @Override
        public Throwable getFailure() {
            return null;
        }

        public String getDisplayName() {
            return this.previous.getDisplayName();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private static class InitialArtifactTransformationSubject
    extends AbstractInitialTransformationSubject {
        private final ComponentArtifactIdentifier artifactId;

        public InitialArtifactTransformationSubject(ComponentArtifactIdentifier artifactId, File file) {
            super(file);
            this.artifactId = artifactId;
        }

        public String getDisplayName() {
            return "artifact " + this.artifactId.getDisplayName();
        }

        @Override
        public Optional<ProjectComponentIdentifier> getProducer() {
            ComponentIdentifier componentIdentifier = this.artifactId.getComponentIdentifier();
            if (componentIdentifier instanceof ProjectComponentIdentifier) {
                return Optional.of((ProjectComponentIdentifier)componentIdentifier);
            }
            return Optional.empty();
        }
    }

    private static class InitialFileTransformationSubject
    extends AbstractInitialTransformationSubject {
        public InitialFileTransformationSubject(File file) {
            super(file);
        }

        public String getDisplayName() {
            return "file " + this.getFile();
        }

        @Override
        public Optional<ProjectComponentIdentifier> getProducer() {
            return Optional.empty();
        }
    }

    private static abstract class AbstractInitialTransformationSubject
    extends TransformationSubject {
        private final File file;

        public AbstractInitialTransformationSubject(File file) {
            this.file = file;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return ImmutableList.of((Object)this.file);
        }

        public File getFile() {
            return this.file;
        }

        @Override
        @Nullable
        public Throwable getFailure() {
            return null;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private static class TransformationFailedSubject
    extends TransformationSubject {
        private final String displayName;
        private final Throwable failure;

        public TransformationFailedSubject(String displayName, Throwable failure) {
            this.displayName = displayName;
            this.failure = failure;
        }

        @Override
        public ImmutableList<File> getFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ProjectComponentIdentifier> getProducer() {
            return Optional.empty();
        }

        @Override
        @Nullable
        public Throwable getFailure() {
            return this.failure;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

