/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.CompatibilityRuleChain;
import org.gradle.api.attributes.DisambiguationRuleChain;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.attributes.DefaultCompatibilityRuleChain;
import org.gradle.api.internal.attributes.DefaultDisambiguationRuleChain;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributeMatchingStrategy<T>
implements AttributeMatchingStrategy<T> {
    private final CompatibilityRuleChain<T> compatibilityRules;
    private final DisambiguationRuleChain<T> disambiguationRules;

    public DefaultAttributeMatchingStrategy(InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this.compatibilityRules = (CompatibilityRuleChain)Cast.uncheckedCast((Object)instantiatorFactory.decorate().newInstance(DefaultCompatibilityRuleChain.class, new Object[]{instantiatorFactory.inject(), isolatableFactory}));
        this.disambiguationRules = (DisambiguationRuleChain)Cast.uncheckedCast((Object)instantiatorFactory.decorate().newInstance(DefaultDisambiguationRuleChain.class, new Object[]{instantiatorFactory.inject(), isolatableFactory}));
    }

    public CompatibilityRuleChain<T> getCompatibilityRules() {
        return this.compatibilityRules;
    }

    public DisambiguationRuleChain<T> getDisambiguationRules() {
        return this.disambiguationRules;
    }

    public void ordered(Comparator<T> comparator) {
        this.ordered(true, comparator);
    }

    public void ordered(boolean pickLast, Comparator<T> comparator) {
        this.compatibilityRules.ordered(comparator);
        if (pickLast) {
            this.disambiguationRules.pickLast(comparator);
        } else {
            this.disambiguationRules.pickFirst(comparator);
        }
    }
}

