/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.NoOutputsArtifactState;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.reflect.Instantiator;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;
    private final Instantiator instantiator;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, Instantiator instantiator, TaskArtifactStateRepository repository) {
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.repository = repository;
    }

    @Override
    public TaskArtifactState getStateFor(TaskInternal task, TaskProperties taskProperties) {
        AndSpec<? super TaskInternal> upToDateSpec = task.getOutputs().getUpToDateSpec();
        if (!taskProperties.hasDeclaredOutputs() && upToDateSpec.isEmpty()) {
            if (task.hasTaskActions()) {
                return NoOutputsArtifactState.WITH_ACTIONS;
            }
            return NoOutputsArtifactState.WITHOUT_ACTIONS;
        }
        TaskArtifactState state = this.repository.getStateFor(task, taskProperties);
        if (this.startParameter.isRerunTasks()) {
            return new RerunTaskArtifactState(state, task, "Executed with '--rerun-tasks'.");
        }
        if (!upToDateSpec.isSatisfiedBy((Object)task)) {
            return new RerunTaskArtifactState(state, task, "Task.upToDateWhen is false.");
        }
        return state;
    }

    private class RerunTaskArtifactState
    implements TaskArtifactState {
        private final TaskArtifactState delegate;
        private final TaskInternal task;
        private final Change reason;

        private RerunTaskArtifactState(TaskArtifactState delegate, TaskInternal task, final String reason) {
            this.delegate = delegate;
            this.task = task;
            this.reason = new Change(){

                public String getMessage() {
                    return reason;
                }
            };
        }

        @Override
        public Optional<ExecutionStateChanges> getExecutionStateChanges() {
            return Optional.of(new ExecutionStateChanges(){

                public void visitAllChanges(ChangeVisitor visitor) {
                    visitor.visitChange(RerunTaskArtifactState.this.reason);
                }

                public boolean isRebuildRequired() {
                    return true;
                }

                public Iterable<Change> getInputFilesChanges() {
                    throw new UnsupportedOperationException();
                }

                public AfterPreviousExecutionState getPreviousExecution() {
                    throw new UnsupportedOperationException();
                }
            });
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            return (IncrementalTaskInputs)ShortCircuitTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task, this.getCurrentInputFileFingerprints()});
        }

        @Override
        public Iterable<? extends FileCollectionFingerprint> getCurrentInputFileFingerprints() {
            return this.delegate.getCurrentInputFileFingerprints();
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return false;
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey(TaskProperties taskProperties) {
            return this.delegate.calculateCacheKey(taskProperties);
        }

        @Override
        public Map<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
            return this.delegate.getOutputFingerprints();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.delegate.ensureSnapshotBeforeTask();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.delegate.afterOutputsRemovedBeforeTask();
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterTaskExecution(TaskExecutionContext taskExecutionContext) {
            return this.delegate.snapshotAfterTaskExecution(taskExecutionContext);
        }

        @Override
        public void persistNewOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, boolean successful, OriginMetadata originMetadata) {
            this.delegate.persistNewOutputs(newOutputFingerprints, successful, originMetadata);
        }

        @Override
        @Nullable
        public OverlappingOutputs getOverlappingOutputs() {
            return this.delegate.getOverlappingOutputs();
        }
    }
}

