/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class DefaultTaskExecutionContext
implements TaskExecutionContext {
    private final LocalTaskNode localTaskNode;
    private AfterPreviousExecutionState afterPreviousExecution;
    private TaskArtifactState taskArtifactState;
    private TaskOutputCachingBuildCacheKey buildCacheKey;
    private List<String> upToDateMessages;
    private TaskProperties taskProperties;
    private boolean taskCachingEnabled;
    private Long executionTime;
    private final Timer executionTimer;
    private boolean taskExecutedIncrementally;

    public DefaultTaskExecutionContext(LocalTaskNode localTaskNode) {
        this.localTaskNode = localTaskNode;
        this.executionTimer = Time.startTimer();
    }

    @Override
    public LocalTaskNode getLocalTaskNode() {
        return this.localTaskNode;
    }

    @Override
    @Nullable
    public AfterPreviousExecutionState getAfterPreviousExecution() {
        return this.afterPreviousExecution;
    }

    @Override
    public void setAfterPreviousExecution(@Nullable AfterPreviousExecutionState afterPreviousExecution) {
        this.afterPreviousExecution = afterPreviousExecution;
    }

    @Override
    public TaskArtifactState getTaskArtifactState() {
        return this.taskArtifactState;
    }

    @Override
    public void setTaskArtifactState(TaskArtifactState taskArtifactState) {
        this.taskArtifactState = taskArtifactState;
    }

    @Override
    public TaskOutputCachingBuildCacheKey getBuildCacheKey() {
        return this.buildCacheKey;
    }

    @Override
    public void setBuildCacheKey(TaskOutputCachingBuildCacheKey buildCacheKey) {
        this.buildCacheKey = buildCacheKey;
    }

    @Override
    public long markExecutionTime() {
        if (this.executionTime != null) {
            throw new IllegalStateException("execution time already set");
        }
        this.executionTime = this.executionTimer.getElapsedMillis();
        return this.executionTime;
    }

    @Override
    public long getExecutionTime() {
        if (this.executionTime == null) {
            throw new IllegalStateException("execution time not yet set");
        }
        return this.executionTime;
    }

    @Override
    @Nullable
    public List<String> getUpToDateMessages() {
        return this.upToDateMessages;
    }

    @Override
    public void setUpToDateMessages(List<String> upToDateMessages) {
        this.upToDateMessages = upToDateMessages;
    }

    @Override
    public void setTaskProperties(TaskProperties taskProperties) {
        this.taskProperties = taskProperties;
    }

    @Override
    public TaskProperties getTaskProperties() {
        return this.taskProperties;
    }

    @Override
    public boolean isTaskCachingEnabled() {
        return this.taskCachingEnabled;
    }

    @Override
    public void setTaskCachingEnabled(boolean taskCachingEnabled) {
        this.taskCachingEnabled = taskCachingEnabled;
    }

    @Override
    public boolean isTaskExecutedIncrementally() {
        return this.taskExecutedIncrementally;
    }

    @Override
    public void setTaskExecutedIncrementally(boolean taskExecutedIncrementally) {
        this.taskExecutedIncrementally = taskExecutedIncrementally;
    }
}

