/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmType;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmWildcardType;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiWildcardType
extends PsiType.Stub
implements JvmWildcardType {
    public static final String EXTENDS_PREFIX = "? extends ";
    public static final String SUPER_PREFIX = "? super ";
    private static final Logger LOG = Logger.getInstance(PsiWildcardType.class);
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(0);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    private PsiWildcardType(@NotNull PsiWildcardType type2, @NotNull TypeAnnotationProvider provider) {
        if (type2 == null) {
            PsiWildcardType.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            PsiWildcardType.$$$reportNull$$$0(2);
        }
        super(provider);
        this.myManager = type2.myManager;
        this.myIsExtending = type2.myIsExtending;
        this.myBound = type2.myBound;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(@NotNull PsiManager manager) {
        PsiWildcardType unboundedWildcard;
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(3);
        }
        if ((unboundedWildcard = manager.getUserData(UNBOUNDED_WILDCARD)) == null) {
            unboundedWildcard = manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, new PsiWildcardType(manager, false, null));
        }
        PsiWildcardType psiWildcardType = unboundedWildcard;
        if (psiWildcardType == null) {
            PsiWildcardType.$$$reportNull$$$0(4);
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(5);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, true, bound);
        if (psiWildcardType == null) {
            PsiWildcardType.$$$reportNull$$$0(7);
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(8);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType) && bound != PsiType.NULL, bound);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, false, bound);
        if (psiWildcardType == null) {
            PsiWildcardType.$$$reportNull$$$0(10);
        }
        return psiWildcardType;
    }

    public PsiWildcardType annotate(@NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            PsiWildcardType.$$$reportNull$$$0(11);
        }
        return annotations2.length == 0 ? this : new PsiWildcardType(this, TypeAnnotationProvider.Static.create(annotations2));
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated, this.myBound == null ? null : this.myBound.getPresentableText());
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(14);
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated, @Nullable String suffix) {
        PsiAnnotation[] annotations2;
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0 && suffix == null) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                PsiWildcardType.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiWildcardType.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            PsiWildcardType.$$$reportNull$$$0(17);
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            PsiWildcardType.$$$reportNull$$$0(18);
        }
        if (this.myBound == null) {
            return "?".equals(text2);
        }
        if (this.myIsExtending) {
            return text2.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text2.substring(EXTENDS_PREFIX.length()));
        }
        return text2.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text2.substring(SUPER_PREFIX.length()));
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            PsiWildcardType.$$$reportNull$$$0(19);
        }
        return psiManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal(this.myBound, that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiWildcardType.$$$reportNull$$$0(20);
        }
        return visitor2.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    @NotNull
    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            PsiClassType psiClassType = PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
            if (psiClassType == null) {
                PsiWildcardType.$$$reportNull$$$0(21);
            }
            return psiClassType;
        }
        PsiType psiType = this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(22);
        }
        return psiType;
    }

    @NotNull
    public PsiType getSuperBound() {
        PsiType psiType = this.myBound == null || this.myIsExtending ? NULL : this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(23);
        }
        return psiType;
    }

    @NotNull
    public JvmType upperBound() {
        PsiType psiType = this.getExtendsBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(24);
        }
        return psiType;
    }

    @NotNull
    public JvmType lowerBound() {
        PsiType psiType = this.getSuperBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(25);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnbounded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtends";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsBound";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperBound";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "upperBound";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "lowerBound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnbounded";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExtends";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSuper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

