/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.plugins;

import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.ide.xcode.XcodeExtension;
import org.gradle.ide.xcode.XcodeRootExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeRootExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeWorkspace;
import org.gradle.ide.xcode.internal.XcodeProjectMetadata;
import org.gradle.ide.xcode.internal.XcodePropertyAdapter;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.tasks.GenerateSchemeFileTask;
import org.gradle.ide.xcode.tasks.GenerateWorkspaceSettingsFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeProjectFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeWorkspaceFileTask;
import org.gradle.internal.Actions;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.plugins.CppApplicationPlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftApplicationPlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.plugins.XCTestConventionPlugin;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;

@Incubating
public class XcodePlugin
extends IdePlugin {
    private final GidGenerator gidGenerator;
    private final ObjectFactory objectFactory;
    private final IdeArtifactRegistry artifactRegistry;
    private DefaultXcodeProject xcodeProject;

    @Inject
    public XcodePlugin(GidGenerator gidGenerator, ObjectFactory objectFactory, IdeArtifactRegistry artifactRegistry) {
        this.gidGenerator = gidGenerator;
        this.objectFactory = objectFactory;
        this.artifactRegistry = artifactRegistry;
    }

    protected String getLifecycleTaskName() {
        return "xcode";
    }

    protected void onApply(Project project) {
        DefaultXcodeExtension xcode;
        TaskProvider lifecycleTask = this.getLifecycleTask();
        lifecycleTask.configure(XcodePlugin.withDescription((String)"Generates XCode project files (pbxproj, xcworkspace, xcscheme)"));
        if (this.isRoot()) {
            xcode = (DefaultXcodeRootExtension)project.getExtensions().create(XcodeRootExtension.class, "xcode", DefaultXcodeRootExtension.class, new Object[]{this.objectFactory});
            this.xcodeProject = xcode.getProject();
            GenerateXcodeWorkspaceFileTask workspaceTask = this.createWorkspaceTask(project, ((DefaultXcodeRootExtension)xcode).getWorkspace());
            lifecycleTask.configure(XcodePlugin.dependsOn((Task)workspaceTask));
            this.addWorkspace(((DefaultXcodeRootExtension)xcode).getWorkspace());
        } else {
            xcode = (DefaultXcodeExtension)project.getExtensions().create(XcodeExtension.class, "xcode", DefaultXcodeExtension.class, new Object[]{this.objectFactory});
            this.xcodeProject = xcode.getProject();
        }
        this.xcodeProject.setLocationDir(project.file((Object)(project.getName() + ".xcodeproj")));
        GenerateXcodeProjectFileTask projectTask = this.createProjectTask((ProjectInternal)project);
        lifecycleTask.configure(XcodePlugin.dependsOn((Task)projectTask));
        project.getTasks().addRule("Xcode bridge tasks begin with _xcode. Do not call these directly.", (Action)new XcodeBridge(this.xcodeProject, project));
        this.configureForSwiftPlugin(project);
        this.configureForCppPlugin(project);
        this.includeBuildFilesInProject(project);
        this.configureXcodeCleanTask(project);
    }

    private void includeBuildFilesInProject(Project project) {
        if (project.getBuildFile().exists()) {
            this.xcodeProject.getGroups().getRoot().from(new Object[]{project.getBuildFile()});
        }
    }

    private void configureXcodeCleanTask(Project project) {
        Delete cleanTask = (Delete)project.getTasks().create("cleanXcodeProject", Delete.class);
        cleanTask.delete(new Object[]{this.xcodeProject.getLocationDir()});
        if (this.isRoot()) {
            cleanTask.delete(new Object[]{project.file((Object)(project.getName() + ".xcworkspace"))});
        }
        this.getCleanTask().configure(Actions.composite((Action[])new Action[]{XcodePlugin.withDescription((String)"Cleans XCode project files (xcodeproj)"), XcodePlugin.dependsOn((Task)cleanTask)}));
    }

    private GenerateXcodeProjectFileTask createProjectTask(ProjectInternal project) {
        File xcodeProjectPackageDir = this.xcodeProject.getLocationDir();
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeProjectWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeProjectFileTask projectFileTask = (GenerateXcodeProjectFileTask)project.getTasks().create("xcodeProject", GenerateXcodeProjectFileTask.class);
        projectFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
        projectFileTask.dependsOn(new Object[]{this.xcodeProject.getTaskDependencies()});
        projectFileTask.dependsOn(new Object[]{project.getTasks().withType(GenerateSchemeFileTask.class)});
        projectFileTask.setXcodeProject(this.xcodeProject);
        projectFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.pbxproj"));
        this.artifactRegistry.registerIdeProject((IdeProjectMetadata)new XcodeProjectMetadata(this.xcodeProject, (Task)projectFileTask));
        return projectFileTask;
    }

    private GenerateXcodeWorkspaceFileTask createWorkspaceTask(Project project, DefaultXcodeWorkspace workspace) {
        File xcodeWorkspacePackageDir = project.file((Object)(project.getName() + ".xcworkspace"));
        workspace.getLocation().set(xcodeWorkspacePackageDir);
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeWorkspaceWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeWorkspaceFileTask workspaceFileTask = (GenerateXcodeWorkspaceFileTask)project.getTasks().create("xcodeWorkspace", GenerateXcodeWorkspaceFileTask.class);
        workspaceFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
        workspaceFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "contents.xcworkspacedata"));
        workspaceFileTask.setXcodeProjectLocations(this.artifactRegistry.getIdeProjectFiles(XcodeProjectMetadata.class));
        return workspaceFileTask;
    }

    private String getBridgeTaskPath(Project project) {
        String projectPath = "";
        if (!this.isRoot()) {
            projectPath = project.getPath();
        }
        return projectPath + ":_xcode__${ACTION}_${PRODUCT_NAME}_${CONFIGURATION}";
    }

    private void configureForSwiftPlugin(final Project project) {
        project.getPlugins().withType(SwiftApplicationPlugin.class, (Action)new Action<SwiftApplicationPlugin>(){

            public void execute(SwiftApplicationPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, (Action)new Action<SwiftLibraryPlugin>(){

            public void execute(SwiftLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project);
            }
        });
        project.getPlugins().withType(XCTestConventionPlugin.class, (Action)new Action<XCTestConventionPlugin>(){

            public void execute(XCTestConventionPlugin plugin) {
                XcodePlugin.this.configureXcodeForXCTest(project);
            }
        });
    }

    private void configureXcodeForXCTest(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                SwiftXCTestSuite component = (SwiftXCTestSuite)project.getExtensions().getByType(SwiftXCTestSuite.class);
                FileCollection sources = component.getSwiftSource();
                XcodePlugin.this.xcodeProject.getGroups().getTests().from(new Object[]{sources});
                String targetName = (String)component.getModule().get();
                final XcodeTarget target = XcodePlugin.this.newTarget(targetName, (String)component.getModule().get(), IdePlugin.toGradleCommand((Project)project), XcodePlugin.this.getBridgeTaskPath(project), sources);
                target.addBinary("Debug", (Provider<? extends FileSystemLocation>)((SwiftXCTestBinary)component.getTestBinary().get()).getInstallDirectory(), ((SwiftXCTestBinary)component.getTestBinary().get()).getTargetPlatform().getArchitecture().getName());
                target.addBinary("Release", (Provider<? extends FileSystemLocation>)((SwiftXCTestBinary)component.getTestBinary().get()).getInstallDirectory(), ((SwiftXCTestBinary)component.getTestBinary().get()).getTargetPlatform().getArchitecture().getName());
                target.setProductType(PBXTarget.ProductType.UNIT_TEST);
                target.getCompileModules().from(new Object[]{((SwiftXCTestBinary)component.getTestBinary().get()).getCompileModules()});
                target.addTaskDependency(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultSwiftBinary)component.getTestBinary().get()).getImportPathConfiguration()).getBuildDependencies());
                component.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

                    public void execute(SwiftBinary swiftBinary) {
                        target.getSwiftSourceCompatibility().set(swiftBinary.getSourceCompatibility());
                    }
                });
                XcodePlugin.this.xcodeProject.addTarget(target);
            }
        });
    }

    private FileCollection filterArtifactsFromImplicitBuilds(Configuration configuration) {
        return configuration.getIncoming().artifactView(this.fromSourceDependency()).getArtifacts().getArtifactFiles();
    }

    private void configureXcodeForSwift(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                final ProductionSwiftComponent component = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).getByName("main");
                FileCollection sources = component.getSwiftSource();
                XcodePlugin.this.xcodeProject.getGroups().getSources().from(new Object[]{sources});
                final String targetName = (String)component.getModule().get();
                final XcodeTarget target = XcodePlugin.this.newTarget(targetName, (String)component.getModule().get(), IdePlugin.toGradleCommand((Project)project), XcodePlugin.this.getBridgeTaskPath(project), sources);
                target.getDefaultConfigurationName().set(component.getDevelopmentBinary().map(devBinary -> XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)devBinary)));
                component.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

                    public void execute(SwiftBinary swiftBinary) {
                        if (swiftBinary instanceof SwiftExecutable) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)swiftBinary), (Provider<? extends FileSystemLocation>)((SwiftExecutable)swiftBinary).getDebuggerExecutableFile(), swiftBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.TOOL);
                        } else if (swiftBinary instanceof SwiftSharedLibrary) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)swiftBinary), (Provider<? extends FileSystemLocation>)((SwiftSharedLibrary)swiftBinary).getRuntimeFile(), swiftBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (swiftBinary instanceof SwiftStaticLibrary) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)swiftBinary), (Provider<? extends FileSystemLocation>)((SwiftStaticLibrary)swiftBinary).getLinkFile(), swiftBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.STATIC_LIBRARY);
                        }
                        target.getSwiftSourceCompatibility().set(swiftBinary.getSourceCompatibility());
                        if (swiftBinary == component.getDevelopmentBinary().get()) {
                            target.getCompileModules().from(new Object[]{((SwiftBinary)component.getDevelopmentBinary().get()).getCompileModules()});
                            target.addTaskDependency(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultSwiftBinary)component.getDevelopmentBinary().get()).getImportPathConfiguration()).getBuildDependencies());
                            XcodePlugin.this.xcodeProject.addTarget(target);
                            XcodePlugin.createSchemeTask(project.getTasks(), targetName, XcodePlugin.this.xcodeProject);
                        }
                    }
                });
            }
        });
    }

    private String toBuildConfigurationName(SoftwareComponent component, SoftwareComponent binary) {
        String result = binary.getName().replace(component.getName(), "");
        if (binary instanceof SwiftSharedLibrary || binary instanceof CppSharedLibrary) {
            return result.replace("Shared", "");
        }
        if (binary instanceof SwiftStaticLibrary || binary instanceof CppStaticLibrary) {
            return result.replace("Static", "");
        }
        return result;
    }

    private void configureForCppPlugin(final Project project) {
        project.getPlugins().withType(CppApplicationPlugin.class, (Action)new Action<CppApplicationPlugin>(){

            public void execute(CppApplicationPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project);
            }
        });
        project.getPlugins().withType(CppLibraryPlugin.class, (Action)new Action<CppLibraryPlugin>(){

            public void execute(CppLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project);
            }
        });
    }

    private void configureXcodeForCpp(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                final ProductionCppComponent component = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).getByName("main");
                FileCollection sources = component.getCppSource();
                XcodePlugin.this.xcodeProject.getGroups().getSources().from(new Object[]{sources});
                FileTree headers = component.getHeaderFiles();
                XcodePlugin.this.xcodeProject.getGroups().getHeaders().from(new Object[]{headers});
                final String targetName = StringUtils.capitalize((String)((String)component.getBaseName().get()));
                final XcodeTarget target = XcodePlugin.this.newTarget(targetName, targetName, IdePlugin.toGradleCommand((Project)project), XcodePlugin.this.getBridgeTaskPath(project), sources);
                target.getDefaultConfigurationName().set(component.getDevelopmentBinary().map(devBinary -> XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)devBinary)));
                component.getBinaries().whenElementFinalized((Action)new Action<CppBinary>(){

                    public void execute(CppBinary cppBinary) {
                        if (cppBinary instanceof CppExecutable) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)cppBinary), (Provider<? extends FileSystemLocation>)((CppExecutable)cppBinary).getDebuggerExecutableFile(), cppBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.TOOL);
                        } else if (cppBinary instanceof CppSharedLibrary) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)cppBinary), (Provider<? extends FileSystemLocation>)((CppSharedLibrary)cppBinary).getRuntimeFile(), cppBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (cppBinary instanceof CppStaticLibrary) {
                            target.addBinary(XcodePlugin.this.toBuildConfigurationName((SoftwareComponent)component, (SoftwareComponent)cppBinary), (Provider<? extends FileSystemLocation>)((CppStaticLibrary)cppBinary).getLinkFile(), cppBinary.getTargetPlatform().getArchitecture().getName());
                            target.setProductType(PBXTarget.ProductType.STATIC_LIBRARY);
                        }
                        if (cppBinary == component.getDevelopmentBinary().get()) {
                            target.getHeaderSearchPaths().from(new Object[]{((CppBinary)component.getDevelopmentBinary().get()).getCompileIncludePath()});
                            target.getTaskDependencies().add(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultCppBinary)component.getDevelopmentBinary().get()).getIncludePathConfiguration()).getBuildDependencies());
                            XcodePlugin.this.xcodeProject.addTarget(target);
                            XcodePlugin.createSchemeTask(project.getTasks(), targetName, XcodePlugin.this.xcodeProject);
                        }
                    }
                });
            }
        });
    }

    private static GenerateSchemeFileTask createSchemeTask(TaskContainer tasks, String schemeName, DefaultXcodeProject xcodeProject) {
        String name = "xcodeScheme";
        GenerateSchemeFileTask schemeFileTask = (GenerateSchemeFileTask)((Object)tasks.maybeCreate(name, GenerateSchemeFileTask.class));
        schemeFileTask.setXcodeProject(xcodeProject);
        schemeFileTask.setOutputFile(new File(xcodeProject.getLocationDir(), "xcshareddata/xcschemes/" + schemeName + ".xcscheme"));
        return schemeFileTask;
    }

    private XcodeTarget newTarget(String name, String productName, String gradleCommand, String taskName, FileCollection sources) {
        String id = this.gidGenerator.generateGid("PBXLegacyTarget", name.hashCode());
        XcodeTarget target = (XcodeTarget)this.objectFactory.newInstance(XcodeTarget.class, new Object[]{name, id});
        target.setTaskName(taskName);
        target.setGradleCommand(gradleCommand);
        target.setProductName(productName);
        target.getSources().setFrom((Iterable)sources);
        return target;
    }

    private Action<ArtifactView.ViewConfiguration> fromSourceDependency() {
        return new Action<ArtifactView.ViewConfiguration>(){

            public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                viewConfiguration.componentFilter(XcodePlugin.this.isSourceDependency());
            }
        };
    }

    private Spec<ComponentIdentifier> isSourceDependency() {
        return new Spec<ComponentIdentifier>(){

            public boolean isSatisfiedBy(ComponentIdentifier id) {
                if (id instanceof ProjectComponentIdentifier) {
                    return XcodePlugin.this.artifactRegistry.getIdeProject(XcodeProjectMetadata.class, (ProjectComponentIdentifier)id) == null;
                }
                return false;
            }
        };
    }

    private static class XcodeBridge
    implements Action<String> {
        private final DefaultXcodeProject xcodeProject;
        private final Project project;
        private final XcodePropertyAdapter xcodePropertyAdapter;

        XcodeBridge(DefaultXcodeProject xcodeProject, Project project) {
            this.xcodeProject = xcodeProject;
            this.project = project;
            this.xcodePropertyAdapter = new XcodePropertyAdapter(project);
        }

        public void execute(String taskName) {
            if (taskName.startsWith("_xcode")) {
                Task bridgeTask = this.project.getTasks().create(taskName);
                String action = this.xcodePropertyAdapter.getAction();
                if (action.equals("clean")) {
                    bridgeTask.dependsOn(new Object[]{"clean"});
                } else if ("".equals(action) || "build".equals(action)) {
                    XcodeTarget target = this.findXcodeTarget();
                    if (target.isUnitTest()) {
                        this.bridgeTestExecution(bridgeTask, target);
                    } else {
                        this.bridgeProductBuild(bridgeTask, target);
                    }
                } else {
                    throw new GradleException("Unrecognized bridge action from Xcode '" + action + "'");
                }
            }
        }

        private XcodeTarget findXcodeTarget() {
            final String productName = this.xcodePropertyAdapter.getProductName();
            XcodeTarget target = (XcodeTarget)CollectionUtils.findFirst(this.xcodeProject.getTargets(), (Spec)new Spec<XcodeTarget>(){

                public boolean isSatisfiedBy(XcodeTarget target) {
                    return target.getProductName().equals(productName);
                }
            });
            if (target == null) {
                throw new GradleException("Unknown Xcode target '" + productName + "', do you need to re-generate Xcode configuration?");
            }
            return target;
        }

        private void bridgeProductBuild(Task bridgeTask, XcodeTarget target) {
            String configuration = this.xcodePropertyAdapter.getConfiguration();
            bridgeTask.dependsOn(new Object[]{target.getBinaries().stream().filter(it -> it.getBuildConfigurationName().equals(configuration)).findFirst().get().getOutputFile()});
        }

        private void bridgeTestExecution(Task bridgeTask, final XcodeTarget target) {
            final String builtProductsPath = this.xcodePropertyAdapter.getBuiltProductsDir();
            Sync syncTask = (Sync)this.project.getTasks().create("syncBundleToXcodeBuiltProductDir", Sync.class, (Action)new Action<Sync>(){

                public void execute(Sync task) {
                    task.from(new Object[]{target.getDebugOutputFile()});
                    task.into((Object)builtProductsPath);
                }
            });
            bridgeTask.dependsOn(new Object[]{syncTask});
        }
    }
}

