/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import org.gradle.internal.execution.ExecutionException;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.Step;

public class CatchExceptionStep<C extends Context>
implements Step<C, Result> {
    private final Step<C, ? extends Result> delegate;

    public CatchExceptionStep(Step<C, ? extends Result> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Result execute(C context) {
        try {
            return this.delegate.execute(context);
        }
        catch (Throwable t) {
            final ExecutionException failure = new ExecutionException(context.getWork(), t);
            return new Result(){

                @Override
                public ExecutionOutcome getOutcome() {
                    return ExecutionOutcome.EXECUTED;
                }

                @Override
                public Throwable getFailure() {
                    return failure;
                }
            };
        }
    }
}

