/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.CurrentSnapshotResult;
import org.gradle.internal.execution.impl.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class StoreSnapshotsStep<C extends Context>
implements Step<C, CurrentSnapshotResult> {
    private final OutputFilesRepository outputFilesRepository;
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public StoreSnapshotsStep(OutputFilesRepository outputFilesRepository, Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.outputFilesRepository = outputFilesRepository;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        CurrentSnapshotResult result = this.delegate.execute(context);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs = result.getFinalOutputs();
        context.getWork().persistResult(finalOutputs, result.getFailure() == null, result.getOriginMetadata());
        this.outputFilesRepository.recordOutputs((Iterable<? extends FileSystemSnapshot>)finalOutputs.values());
        return result;
    }
}

