/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.caching.internal.tasks.DebuggingTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.DefaultTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class TaskCacheKeyCalculator {
    private final boolean buildCacheDebugLogging;

    public TaskCacheKeyCalculator(boolean buildCacheDebugLogging) {
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    public TaskOutputCachingBuildCacheKey calculate(TaskInternal task, BeforeExecutionState execution, TaskProperties taskProperties) {
        TaskOutputCachingBuildCacheKeyBuilder builder = new DefaultTaskOutputCachingBuildCacheKeyBuilder(task.getIdentityPath());
        if (this.buildCacheDebugLogging) {
            builder = new DebuggingTaskOutputCachingBuildCacheKeyBuilder(builder);
        }
        builder.appendTaskImplementation(execution.getImplementation());
        builder.appendTaskActionImplementations((Collection<ImplementationSnapshot>)execution.getAdditionalImplementations());
        ImmutableSortedMap inputProperties = execution.getInputProperties();
        for (Map.Entry entry : inputProperties.entrySet()) {
            Hasher newHasher = Hashing.newHasher();
            ((ValueSnapshot)entry.getValue()).appendToHasher(newHasher);
            if (newHasher.isValid()) {
                HashCode hash = newHasher.hash();
                builder.appendInputValuePropertyHash((String)entry.getKey(), hash);
                continue;
            }
            builder.inputPropertyNotCacheable((String)entry.getKey(), newHasher.getInvalidReason());
        }
        ImmutableSortedMap inputFingerprints = execution.getInputFileProperties();
        for (Map.Entry entry : inputFingerprints.entrySet()) {
            builder.appendInputFilesProperty((String)entry.getKey(), (CurrentFileCollectionFingerprint)entry.getValue());
        }
        for (TaskOutputFilePropertySpec propertySpec : taskProperties.getOutputFileProperties()) {
            if (!(propertySpec instanceof CacheableTaskOutputFilePropertySpec) || ((CacheableTaskOutputFilePropertySpec)propertySpec).getOutputFile() == null) continue;
            builder.appendOutputPropertyName(propertySpec.getPropertyName());
        }
        return builder.build();
    }
}

