#############################################################################
##
#W exam.gi                 POLENTA package                     Bjoern Assmann
##
## examples for polycyclic rational matrix groups
##
#Y 2003
##


#############################################################################
##
#F POL_KroneckerProduct
## 
## Examples built with the Kroneckerproduct.
## 
POL_KroneckerProduct := function( G, e ) 
    local newGens, gens;
    gens := GeneratorsOfGroup( G );
    if e = 0 then 
        e := RandomList( [1,-1] );
    fi;
    newGens := List( gens, x->KroneckerProduct(x,x^e) );
    return Group( newGens );
end;


#############################################################################
##
#F POL_AlmostCrystallographicGroup
## 
## Examples coming from aclib
## 
# In GAP 4.4, the function IsPackageMarkedForLoading is not available.
if not IsBound( IsPackageMarkedForLoading ) then
  IsPackageMarkedForLoading:= function( arg )
    return CallFuncList( LoadPackage, arg ) = true;
  end;
fi;

if not IsPackageMarkedForLoading( "aclib" , "1.0" ) then
    POL_AlmostCrystallographicGroup := false;
else
    POL_AlmostCrystallographicGroup := function( a,b,c )
       local G, mats;
       G := AlmostCrystallographicGroup(a,b,c);
       mats := GeneratorsOfGroup( G );
       G := Group( mats );
       return G;
    end;
fi;

#############################################################################
##
#F PolExamples( n ) .............. .. Examples for polycyc rat. matrix groups
##
# FIXME: This function is documented and should be turned into a GlobalFunction
PolExamples := function( n )
    local i,M,P, nat, G, gens, d, l,r,s;

    # check if aclib is needed
    l := Concatenation( [9..19],[21..24]);
    if POL_AlmostCrystallographicGroup = false then 
        if n in l then
            Print( "package 'aclib' is needed for this example.\n" );
            return fail;
        fi;
    fi;

    # some unipotent groups
    if n=1 then
        return Group(
               [ [ [ 1, -4, 1, 2 ], 
                   [ 0, 1, 5, 1 ], 
                   [ 0, 0, 1, 3 ], 
                   [ 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, -1, -2, 4 ], 
                   [ 0, 1, -1, 1 ], 
                   [ 0, 0, 1, 1 ], 
                   [ 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, -4, -2, 1 ], 
                   [ 0, 1, -2, -3 ], 
                   [ 0, 0, 1, 2 ], 
                   [ 0, 0, 0, 1 ] ] 
                ]);
    fi;
    if n=2 then
        return Group(
               [ [ [ 1, 5, -3, 1, -3 ], 
                   [ 0, 1, 2, 0, 1 ], 
                   [ 0, 0, 1, 2, -2 ],
                   [ 0, 0, 0, 1, -2 ], 
                   [ 0, 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, 3, -3, -1, 1 ], 
                   [ 0, 1, 0, -2, 2 ], 
                   [ 0, 0, 1, 4, 1 ],
                   [ 0, 0, 0, 1, -1 ], 
                   [ 0, 0, 0, 0, 1 ] ] 
               ]);
    fi;
    if n=3 then
        return Group( 
               [ [ [ 73/10, -35/2, 42/5, 63/2 ], 
                   [ 27/20, -11/4, 9/5, 27/4 ],
                   [ -3/5, 1, -4/5, -9 ], 
                   [ -11/20, 7/4, -2/5, 1/4 ] ]
                 ,
                 [ [ -42/5, 423/10, 27/5, 479/10 ], 
                   [ -23/10, 227/20, 13/10, 231/20 ],
                   [ 14/5, -63/5, -4/5, -79/5 ],
                   [ -1/10, 9/20, 1/10, 37/20 ] ] 
               ]);
    fi;
    if n=4 then
        return Group(
               [ [ [ 5, 2, -8, 17, -1 ], 
                   [ -69/4, -15/4, 449/20, -163/5, 53/20 ],
                   [ -2, 4, 9/5, 63/5, 3/5 ], 
                   [ 13/4, 3/4, -121/20, 57/5, -17/20 ],
                   [ 241/4, 7/4, -1477/20, 319/5, -189/20 ] ]
                  ,
                  [ [ 19/2, 0, -3, -19/2, -1/2 ], 
                    [ -74/5, 129/20, 7/4, 159/4, 9/10 ],
                    [ 53/10, 4/5, -4, 9/2, -9/10 ], 
                    [ 37/10, -41/20, -7/4, -29/4, -3/5 ],
                    [ 137/5, -457/20, 37/4, -559/4, 3/10 ] ] 
                ]);
    fi;
    if n in [5..8] then
        return MatExamples( n-4 );
    fi;
    if n=9 then
        return POL_AlmostCrystallographicGroup( 3, 17, [1,0,-3,7] );
    fi;
    if n=10 then
        return POL_AlmostCrystallographicGroup( 3, 16, [3,4,-1,0] );
    fi;
    if n=11 then
        return POL_AlmostCrystallographicGroup( 3, 15, [-1,1,0,0] );
    fi;
    if n=12 then
        return POL_AlmostCrystallographicGroup( 3, 14, [-2,-1,2,-1] );
    fi;
    if n=13 then
        return POL_AlmostCrystallographicGroup( 4, 2, [0,-3,-2,1,-1,-2,4] );
    fi;
    if n=14 then
        return POL_AlmostCrystallographicGroup( 4, 13, [-2,0,-2,-2,-1,-1] );
    fi;
    if n=15 then
        return POL_AlmostCrystallographicGroup( 4, 37, [ 1,2,0,-3,-4] );
    fi;
    if n=16 then
        return POL_AlmostCrystallographicGroup( 4, 86,[0,-2,-1,-2,-1] );
    fi;
    if n=17 then
        return POL_AlmostCrystallographicGroup( 4, 10,[-2,-2,-1]  );
    fi;
    if n=18 then
         return POL_AlmostCrystallographicGroup( 4, 11,[-4,-2,-1] );
    fi;   
    if n=19 then
         return POL_AlmostCrystallographicGroup( 4, 12,[0,1,3,-1] );  
    fi;   
    if n=20 then
        return POL_KroneckerProduct( MatExamples(4), -1  );
    fi;
    if n in [21..24] then
        return POL_KroneckerProduct( PolExamples( n-12 ), 1 );
    fi;
    if n = 25 then 
        #Marco Costantini example
        r := [ [ 1, 0, 0, 0, 0, 0, 0, 0 ], [ 0, 0, 1, 0, 0, 0, 0, 0 ],
               [ 0, 0, 0, 1, 0, 0, 0, 0 ], [ 0, 0, 0, 0, 1, 0, 0, 0 ],
               [ 0, 0, 0, 0, 0, 1, 0, 0 ], [ 0, 0, 0, 0, 0, 0, 1, 0 ],
               [ 0, 0, 0, 0, 0, 0, 0, 1 ], [ 0, 1, 0, 0, 0, 0, 0, 0 ] ];
        s :=
             [ [ 1, 0, 0, 0, 0, 0, 0, 1 ], [ 0, E(7)^6, 0, 0, 0, 0, 0, 0 ],
               [ 0, 0, E(7), 0, 0, 0, 0, 0 ], [ 0, 0, 0, 1, 0, 0, 0, 0 ],
               [ 0, 0, 0, 0, 1, 0, 0, 0 ], [ 0, 0, 0, 0, 0, 1, 0, 0 ],
               [ 0, 0, 0, 0, 0, 0, 1, 0 ], [ 0, 0, 0, 0, 0, 0, 0, 1 ] ];
        return Group( [r,s^7] );
     fi;
     if n = 26 then 
        # subgroup of a group which is conjugate to a direct product
        # of PolExamples(1) and PolExamples(6);
         gens := 
        [ [ [ -403, 2500, 32, -633, -1638, 800, 2073, 406 ],
      [ 3, 37, 20, -9, 5, -11, 29, 7 ], [ -65, -16, 5, 3, -73, 129, -43, 59 ]
        , [ -37, -2936, 80, 735, 1366, 54, -2676, 28 ],
      [ 2, -788, 0, 197, 364, -4, -707, -12 ],
      [ -207, 20, 16, -9, -263, 411, -71, 191 ],
      [ -13, -1276, 0, 319, 567, 26, -1152, -6 ],
      [ 8, 972, 0, -243, -434, -16, 877, 7 ] ],
  [ [ -615, 40, -64, -12, -850, 1248, -241, 515 ],
      [ -9, 37, -4, -9, -31, 19, 29, 7 ],
      [ -39, 347, -7, -87, -205, 80, 293, 41 ],
      [ 437, 3676, -16, -918, -1054, -870, 3495, -290 ],
      [ 106, 748, 0, -187, -189, -212, 719, -72 ],
      [ -149, 1184, -32, -297, -727, 307, 995, 151 ],
      [ 187, 1376, 0, -344, -359, -374, 1319, -126 ],
      [ -106, -816, 0, 204, 217, 212, -779, 70 ] ],
  [ [ -352, -632, -64, 150, -246, 722, -699, 251 ],
      [ 17, -107, -8, 27, 63, -32, -87, -21 ],
      [ -59, -16, -7, 3, -73, 120, -37, 51 ],
      [ -58, 84, -32, -20, -93, 124, 64, 87 ],
      [ -2, 220, 0, -55, -90, 4, 199, 18 ],
      [ -188, -16, -32, 0, -256, 385, -82, 160 ],
      [ -36, 260, 0, -65, -144, 72, 221, 57 ],
      [ 3, -228, 0, 57, 94, -6, -206, -20 ] ],
  [ [ 893, 7836, 0, -1959, -2319, -1784, 7446, -585 ],
      [ 0, 1, 0, 0, 0, 0, 0, 0 ], [ 76, 456, 1, -114, -102, -152, 444, -54 ],
      [ -210, -4128, 0, 1033, 1567, 420, -3805, 87 ],
      [ -158, -1776, 0, 444, 587, 316, -1668, 96 ],
      [ 228, 1368, 0, -342, -306, -455, 1332, -162 ],
      [ -142, -2088, 0, 522, 746, 284, -1940, 75 ],
      [ 190, 2100, 0, -525, -690, -380, 1974, -116 ] ],
  [ [ -1656, -60, 0, 15, -1925, 3314, -920, 1473 ],
      [ 0, 1, 0, 0, 0, 0, 0, 0 ], [ -46, 0, 1, 0, -50, 92, -26, 42 ],
      [ 1626, 236, 0, -58, 1847, -3252, 1043, -1434 ],
      [ 468, 20, 0, -5, 551, -936, 259, -414 ],
      [ -138, 0, 0, 0, -150, 277, -78, 126 ],
      [ 700, 76, 0, -19, 805, -1400, 428, -618 ],
      [ -519, 0, 0, 0, -621, 1038, -267, 460 ] ],
  [ [ -427, -4608, 0, 1152, 1464, 856, -4359, 207 ],
      [ 0, 1, 0, 0, 0, 0, 0, 0 ], [ -104, -360, 1, 90, 36, 208, -372, 90 ],
      [ -525, 2300, 0, -574, -1560, 1050, 1845, 660 ],
      [ -48, 876, 0, -219, -421, 96, 771, 96 ],
      [ -312, -1080, 0, 270, 108, 625, -1116, 270 ],
      [ -171, 1104, 0, -276, -657, 342, 923, 234 ],
      [ 58, -936, 0, 234, 457, -116, -821, -110 ] ],
  [ [ -479, 2668, -64, -669, -1882, 976, 2189, 434 ],
      [ -9, 37, -4, -9, -31, 19, 29, 7 ],
      [ -71, -13, -7, 3, -91, 144, -43, 59 ],
      [ -85, -2936, -16, 735, 1222, 174, -2676, 28 ],
      [ 2, -788, 0, 197, 364, -4, -707, -12 ],
      [ -245, 104, -32, -27, -385, 499, -13, 205 ],
      [ -13, -1276, 0, 319, 567, 26, -1152, -6 ],
      [ 8, 972, 0, -243, -434, -16, 877, 7 ] ],
  [ [ -539, -128, 32, 24, -606, 1072, -357, 487 ],
      [ 3, 37, 20, -9, 5, -11, 29, 7 ],
      [ -33, 344, 5, -87, -187, 65, 293, 41 ],
      [ 485, 3676, 80, -918, -910, -990, 3495, -290 ],
      [ 106, 748, 0, -187, -189, -212, 719, -72 ],
      [ -111, 1100, 16, -279, -605, 219, 937, 137 ],
      [ 187, 1376, 0, -344, -359, -374, 1319, -126 ],
      [ -106, -816, 0, 204, 217, 212, -779, 70 ] ],
  [ [ -352, -632, -64, 150, -246, 722, -699, 251 ],
      [ 17, -107, -8, 27, 63, -32, -87, -21 ],
      [ -59, -16, -7, 3, -73, 120, -37, 51 ],
      [ -58, 84, -32, -20, -93, 124, 64, 87 ],
      [ -2, 220, 0, -55, -90, 4, 199, 18 ],
      [ -188, -16, -32, 0, -256, 385, -82, 160 ],
      [ -36, 260, 0, -65, -144, 72, 221, 57 ],
      [ 3, -228, 0, 57, 94, -6, -206, -20 ] ] ];
      return Group( gens );
     fi;


     if n = 27 then
        # subgroup of a group which is conjugate to a direct product
        # of PolExamples(3) and PolExamples(5);
         gens := 
         [ [ [ -396/5, 49, -4/5, 0, 147, -292, -2611/5, 1799/10, 6, -2/5, 2, -373/2,
          882, 0, 0, 16/5, -2, -2, 389/2, -59 ],
      [ 539/10, -97/2, 78/5, 2, -283/2, 283, 3619/10, -2541/20, 15, 44/5, 2,
          623/4, -849, 2, -5, -132/5, 0, 20, -623/4, 91/2 ],
      [ -9, 1, -10, 1, 8, -17, -51, 17, -2, -4, 2, -16, 51, 1, 1, 12, -1,
          -5, 15, -5 ],
      [ -117/10, 5/2, -49/5, 1, 19/2, -18, -737/10, 503/20, 1, -22/5, 2,
          -81/4, 55, 1, 0, 66/5, -1, -1, 85/4, -13/2 ],
      [ 32, -2, 18, -2, -10, 16, 192, -64, -11, 8, -4, 49, -52, -2, 3, -26,
          2, -10, -51, 17 ],
      [ -30, 2, 6, 2, 10, -25, -162, 54, 11, 4, 4, -55, 73, 2, -2, -10, -2,
          6, 48, -16 ],
      [ 169/10, -19/2, 18/5, 0, -57/2, 55, 1159/10, -791/20, -4, 9/5, -1,
          141/4, -169, 0, 0, -32/5, 2, 1, -161/4, 25/2 ],
      [ 547/10, -57/2, 94/5, 0, -171/2, 166, 3657/10, -2493/20, -9, 47/5,
          -2, 463/4, -507, 0, 0, -151/5, 5, 2, -507/4, 79/2 ],
      [ 653/5, -41, 117/5, -1, -125, 248, 3958/5, -1326/5, -2, 56/5, -3,
          257, -746, -2, 0, -173/5, 2, 2, -259, 85 ],
      [ -87/5, 11, -28/5, 1, 23, -35, -652/5, 219/5, 1, -24/5, -1, -32, 111,
          -2, -2, 72/5, 2, 10, 43, -14 ],
      [ 10, 0, 0, 0, 0, 1, 57, -19, 0, 0, 0, 16, -2, -1, 0, 0, 0, 0, -15, 5 ]
        , [ -2, 0, -8, 0, 0, 1, -12, 4, -3, -4, -1, -4, -4, 0, 0, 11, 1, 1,
          3, -1 ],
      [ -15, 1, -1, 1, 5, -11, -84, 28, 5, 0, 2, -26, 33, 1, -1, 1, -1, 3,
          24, -8 ],
      [ -66, 5, -5, 6, 24, -48, -396, 132, 15, 0, 7, -107, 144, 5, -5, 0, 0,
          20, 107, -36 ],
      [ 2139/5, -124, 236/5, -3, -381, 751, 13014/5, -4358/5, -20, 108/5,
          -13, 814, -2267, -11, 1, -359/5, 10, 6, -832, 273 ],
      [ -3, 1, -8, 1, 3, -3, -24, 8, -1, -4, 1, -3, 11, 0, 0, 12, 0, 0, 6,
          -2 ],
      [ 1241/5, -81, 234/5, -1, -248, 491, 7556/5, -2532/5, -3, 112/5, -3,
          492, -1477, -3, 1, -341/5, 2, -2, -497, 163 ],
      [ 6, 0, -8, 0, 0, -1, 39, -13, -3, -4, -1, 6, 1, -1, 0, 11, 1, 1, -9,
          3 ],
      [ -639/10, 97/2, -158/5, -2, 283/2, -281, -4249/10, 2961/20, -8,
          -84/5, -3, -683/4, 843, -2, 2, 247/5, 0, -7, 683/4, -101/2 ],
      [ -243/10, 97/2, -191/5, -5, 271/2, -268, -2003/10, 1487/20, -12,
          -108/5, -5, -433/4, 807, -5, 5, 324/5, -3, -20, 445/4, -59/2 ] ],
  [ [ -1561/10, -2/5, -134/5, 0, -26/5, 72/5, -852, 2699/10, 2, -67/5, 2,
          -2431/10, -196/5, 0, 0, 211/5, -2, -2, 2451/10, -489/5 ],
      [ 3529/20, -21/5, 53/5, 0, -63/5, 151/5, 981, -6261/20, 0, 53/10, 2,
          5589/20, -428/5, -3, 0, -109/10, 0, -2, -5589/20, 1071/10 ],
      [ -22, 0, 0, 0, 0, -2, -129, 43, 0, 0, 1, -32, 5, 2, 0, -1, 0, -2, 33,
          -11 ],
      [ 113/20, -7/5, 1/5, 0, -21/5, 47/5, 33, -217/20, 0, 1/10, 1, 233/20,
          -136/5, 0, 0, 7/10, 0, -1, -213/20, 37/10 ],
      [ -10, 0, 0, 0, 0, -1, -66, 22, 0, 0, -2, -15, 2, 1, 0, -3, 0, 2, 15,
          -5 ],
      [ 0, 0, 0, 0, -3, 6, 6, -2, 0, 0, 2, 0, -18, 0, 0, 2, 0, -2, 0, 0 ],
      [ 519/20, 19/5, 48/5, 1, 77/5, -164/5, 130, -791/20, 2, 53/10, -1,
          719/20, 482/5, 1, -1, -179/10, 1, 6, -739/20, 171/10 ],
      [ 1517/20, 42/5, 104/5, 3, 176/5, -372/5, 378, -2293/20, 7, 119/10,
          -2, 2177/20, 1096/5, 3, -3, -407/10, 2, 17, -2217/20, 503/10 ],
      [ 1004/5, -64/5, 72/5, 0, -192/5, 374/5, 1101, -1751/5, 2, 36/5, -2,
          1639/5, -1132/5, 0, -1, -118/5, 1, 6, -1644/5, 632/5 ],
      [ -31/5, 1/5, -128/5, 0, 3/5, 29/5, -18, 9/5, -3, -64/5, 1, -76/5,
          -77/5, -4, 0, 202/5, 0, 4, 66/5, -48/5 ],
      [ 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 2, 0, 0, -1, 0, 0, 0, 0 ],
      [ 2, 2, 8, 0, 8, -18, 12, -4, -1, 4, -1, 0, 52, 0, 0, -13, 1, 1, -1, 1
         ], [ 0, 0, 0, 0, -1, 2, 3, -1, 0, 0, 1, 0, -6, 0, 0, 1, 0, -1, 0, 0
         ],
      [ -3, 0, 0, 1, -1, 7, -3, 1, 0, 0, 6, -5, -16, 0, 0, 5, 0, -5, 5, -2 ],
      [ 3062/5, -157/5, 376/5, 0, -436/5, 737/5, 3384, -5388/5, 2, 188/5,
          -10, 4877/5, -2346/5, 0, -3, -639/5, 7, 23, -4972/5, 1921/5 ],
      [ 0, -1, -8, 0, -3, 7, 0, 0, -1, -4, 1, 1, -21, 0, 0, 12, 0, 0, -1, 0 ]
        , [ 2008/5, -133/5, 104/5, 0, -409/5, 803/5, 2202, -3502/5, 2, 52/5,
          -2, 3288/5, -2424/5, 0, -1, -171/5, 1, 7, -3293/5, 1264/5 ],
      [ 2, 2, 8, 0, 8, -21, 18, -6, -1, 4, -1, -3, 58, 0, 0, -14, 1, 1, -1,
          1 ],
      [ -2629/20, 26/5, -8/5, -1, 78/5, -176/5, -708, 4441/20, -4, -13/10,
          -3, -4269/20, 508/5, -1, 1, 19/10, 1, -2, 4249/20, -841/10 ],
      [ -1923/20, -8/5, -36/5, -3, -54/5, 83/5, -501, 3067/20, -9, -51/10,
          -5, -3003/20, -274/5, -3, 3, 133/10, 0, -10, 3003/20, -637/10 ] ],
  [ [ -59, 10, -12, 0, 66, -154, -312, 104, 2, 0, 0, -120, 446, 6, -2, -8,
          2, 4, 100, -30 ],
      [ -114, 9, -3, 0, 31, -65, -648, 216, 5, 0, 7, -186, 195, 10, 5, 7,
          -10, -30, 179, -57 ],
      [ 27, -3, -6, 1, -14, 33, 150, -50, 2, -4, 1, 46, -97, -3, -3, 11, 3,
          15, -43, 13 ],
      [ -9, 0, -1, 0, 3, -7, -48, 16, 3, 0, 1, -15, 20, 1, -1, 0, 0, 3, 13,
          -4 ],
      [ 26, 0, 15, 0, 4, -15, 162, -54, -3, 8, -3, 34, 39, -2, -1, -27, 4,
          6, -39, 13 ],
      [ -70, 4, -17, 0, 12, -25, -396, 132, 5, -8, 5, -115, 75, 6, 3, 29,
          -8, -18, 109, -35 ],
      [ 42, -4, 13, 0, -26, 59, 232, -77, -1, 4, -2, 74, -172, -4, 0, -10,
          1, 3, -67, 21 ],
      [ 96, -7, 33, 0, -45, 100, 537, -178, -2, 12, -6, 162, -293, -9, -1,
          -34, 4, 11, -151, 48 ],
      [ 31, 0, 0, 1, 1, -3, 177, -59, -2, 0, -3, 47, 8, -3, -1, -2, 3, 7,
          -46, 15 ],
      [ -45, 3, 14, -5, 22, -57, -246, 82, -10, 9, -5, -74, 164, 6, 6, -28,
          -3, -30, 68, -20 ],
      [ 22, -2, 2, 0, -11, 25, 120, -40, -2, 0, -1, 39, -73, -2, 0, 0, 1, 2,
          -35, 11 ],
      [ 42, -5, 5, 0, -29, 68, 228, -76, -2, 0, -1, 78, -197, -4, 0, 2, 1,
          3, -68, 21 ],
      [ -24, 1, -8, 0, 2, -3, -138, 46, 2, -4, 2, -38, 10, 2, 1, 14, -3, -6,
          37, -12 ],
      [ -110, 5, -1, 0, 13, -28, -612, 204, 6, 0, 10, -182, 82, 10, 4, 9,
          -9, -26, 170, -55 ],
      [ 276, -25, 24, 2, -139, 318, 1506, -502, -16, 0, -19, 489, -926, -26,
          -3, 1, 14, 38, -438, 137 ],
      [ 3, -1, 0, -1, -2, 3, 18, -6, -2, 0, -1, 6, -10, 0, 0, -1, 1, 0, -6,
          2 ],
      [ 43, 1, -9, 1, 8, -20, 249, -83, -4, -4, -5, 62, 56, -4, -1, 8, 4, 8,
          -63, 21 ],
      [ 42, -6, 6, 0, -35, 81, 222, -74, -2, 0, -2, 81, -235, -4, 0, 2, 1,
          4, -69, 21 ],
      [ 78, -8, -2, 0, -40, 94, 423, -141, -4, -4, -3, 141, -272, -7, -1,
          12, 3, 10, -124, 39 ],
      [ 84, -8, -21, 0, -31, 74, 450, -150, -5, -12, -4, 153, -213, -7, -2,
          32, 4, 15, -134, 43 ] ],
  [ [ -15, 0, -36, 0, 8, -14, -90, 30, 2, -16, 2, -28, 42, 2, 2, 48, -6, -6,
          24, -8 ],
      [ 37, 1, 2, 5, 2, 2, 201, -67, 9, 0, -3, 54, -5, -5, -5, -6, 3, 28,
          -53, 16 ],
      [ -4, 0, 8, 0, -2, 5, -27, 9, 4, 4, 2, -2, -12, 0, -1, -9, 0, 2, 6, -2
         ],
      [ 10, -1, -1, 1, 0, 0, 57, -19, 4, 0, 0, 16, 0, -1, -2, -1, 1, 9, -16,
          5 ],
      [ -63, 2, -2, -3, 9, -26, -345, 115, -5, 0, 3, -104, 73, 7, 5, 4, -5,
          -26, 95, -30 ],
      [ 45, -2, -19, 5, -19, 58, 222, -74, 7, -12, 1, 83, -162, -6, -4, 34,
          1, 23, -67, 20 ],
      [ 11, -1, 11, -1, -11, 24, 61, -20, -3, 4, 0, 22, -70, -1, 0, -10, 2,
          -1, -18, 6 ],
      [ 25, -3, 15, -3, -29, 65, 135, -44, -8, 4, 1, 52, -189, -2, 1, -6, 3,
          -6, -42, 14 ],
      [ -14, -1, -7, -2, -7, 13, -78, 26, -7, -4, 0, -20, -40, 2, 3, 14, -1,
          -13, 19, -6 ],
      [ 44, -3, -17, 0, 4, -13, 261, -87, -5, -7, -7, 61, 33, -3, -1, 12, 3,
          11, -69, 22 ],
      [ 0, 1, 7, 0, 6, -14, 0, 0, 0, 4, -1, -1, 41, 0, -1, -13, 2, 4, 1, 0 ],
      [ 1, 0, 17, -1, -2, 1, 12, -4, -2, 8, -1, 2, -4, 0, 0, -23, 2, -2, -2,
          1 ],
      [ 24, -1, -6, 2, -8, 24, 123, -41, 3, -4, 0, 43, -67, -3, -2, 11, 1,
          11, -36, 11 ],
      [ 57, -3, -1, 5, -25, 72, 294, -98, 14, -4, 0, 103, -201, -7, -5, 13,
          0, 27, -86, 26 ],
      [ 31, -8, 44, -7, -60, 121, 177, -59, -36, 16, -3, 74, -359, -1, 7,
          -40, 11, -32, -58, 19 ],
      [ 12, -1, -1, 0, 0, -1, 69, -23, 1, 0, -1, 19, 3, -1, -1, -1, 1, 5,
          -19, 6 ],
      [ -14, -2, -30, -2, -14, 34, -90, 30, -10, -16, 1, -14, -99, 2, 4, 51,
          -2, -16, 18, -6 ],
      [ 20, -1, 18, 0, -8, 16, 114, -38, -3, 8, -1, 35, -47, -2, -1, -24, 4,
          4, -31, 10 ],
      [ -12, 1, 22, -2, 9, -30, -51, 17, -6, 12, -2, -25, 83, 2, 1, -37, 3,
          -8, 19, -5 ],
      [ -34, 3, 16, -2, 31, -86, -165, 55, -9, 12, -3, -69, 242, 5, 2, -42,
          3, -13, 53, -15 ] ],
  [ [ -71, 0, 58, -8, 20, -72, -348, 116, 4, 32, -2, -134, 194, 10, 0, -96,
          2, -8, 104, -32 ],
      [ -2, 9, 27, 2, 45, -103, 9, -3, 2, 16, -2, -23, 298, 0, -2, -50, 4,
          7, 12, -2 ],
      [ -43, -1, 15, 1, -5, 1, -237, 79, 5, 8, 2, -73, -9, 4, -1, -24, 0, 4,
          64, -22 ],
      [ -15, -1, 15, 0, -1, -5, -75, 25, 3, 8, 0, -28, 10, 2, -1, -24, 1, 4,
          21, -7 ],
      [ 52, -8, -9, -4, -42, 97, 285, -95, -10, -8, -2, 101, -282, -4, 4,
          26, -2, -15, -88, 28 ],
      [ -37, 6, 13, 1, 26, -61, -198, 66, -2, 8, 2, -71, 175, 4, 2, -23, -1,
          -11, 62, -19 ],
      [ 51, -2, -28, 3, -18, 53, 259, -86, -4, -16, 0, 94, -147, -6, 0, 47,
          0, 5, -77, 24 ],
      [ 117, -6, -55, 5, -44, 123, 600, -199, -10, -32, -1, 215, -344, -13,
          0, 93, 1, 11, -179, 56 ],
      [ 37, -4, -37, -3, -18, 48, 192, -64, -9, -20, -2, 75, -135, -3, 3,
          59, -2, -12, -61, 20 ],
      [ 77, -1, -4, 1, -2, 19, 429, -143, 5, -3, -1, 128, -45, -8, -4, 12,
          3, 19, -116, 38 ],
      [ -9, 0, -8, -1, 0, 0, -54, 18, -3, -4, -1, -12, 1, 1, 2, 12, -2, -9,
          13, -4 ],
      [ 29, -1, -22, 3, -10, 32, 141, -47, 0, -12, 0, 55, -87, -4, -1, 35,
          0, 8, -43, 13 ],
      [ -21, 3, 6, 1, 14, -33, -114, 38, 1, 4, 1, -40, 95, 2, 0, -12, 0, -1,
          35, -11 ],
      [ -10, 3, 84, 4, 20, -66, -24, 8, 5, 44, -4, -41, 178, 2, -4, -135, 9,
          20, 20, -7 ],
      [ 157, -13, -258, 1, -104, 309, 735, -245, -42, -140, 6, 347, -850,
          -19, 20, 427, -25, -78, -248, 78 ],
      [ -3, -1, 8, 1, -4, 7, -15, 5, 5, 4, 1, -6, -21, 0, -2, -11, 1, 9, 4,
          -2 ],
      [ 39, -7, -58, -7, -34, 87, 192, -64, -18, -32, -3, 91, -246, -2, 8,
          97, -6, -34, -69, 23 ],
      [ 15, 0, -37, 3, -11, 38, 60, -20, -3, -20, 3, 35, -102, -3, 2, 62,
          -4, -7, -21, 6 ],
      [ 16, -1, -53, 2, -14, 49, 57, -19, 0, -28, 3, 41, -131, -3, 1, 86,
          -5, -3, -23, 7 ],
      [ -40, 1, -78, -2, -6, 34, -252, 84, 1, -40, 8, -46, -85, 3, 5, 128,
          -13, -28, 60, -18 ] ],
  [ [ -456/5, 43, -164/5, 0, 125, -246, -2911/5, 1999/10, 2, -82/5, 2,
          -409/2, 742, 0, 0, 256/5, -2, -2, 413/2, -65 ],
      [ 1159/10, -101/2, 88/5, 0, -303/2, 308, 7399/10, -5061/20, 0, 44/5,
          2, 1007/4, -919, -3, 0, -107/5, 0, -2, -1007/4, 155/2 ],
      [ -22, 0, 0, 0, 0, -2, -129, 43, 0, 0, 1, -32, 5, 2, 0, -1, 0, -2, 33,
          -11 ],
      [ 13/10, 3/2, -4/5, 0, 9/2, -8, 43/10, -17/20, 0, -2/5, 1, 3/4, 25, 0,
          0, 11/5, 0, -1, 1/4, 1/2 ],
      [ -10, 0, 0, 0, 0, -1, -66, 22, 0, 0, -2, -15, 2, 1, 0, -3, 0, 2, 15,
          -5 ],
      [ 0, 0, 0, 0, -3, 6, 6, -2, 0, 0, 2, 0, -18, 0, 0, 2, 0, -2, 0, 0 ],
      [ 79/10, -11/2, 53/5, 1, -25/2, 23, 499/10, -351/20, 2, 29/5, -1,
          85/4, -71, 1, -1, -97/5, 1, 6, -89/4, 15/2 ],
      [ 217/10, -39/2, 119/5, 3, -97/2, 93, 1377/10, -973/20, 7, 67/5, -2,
          259/4, -283, 3, -3, -226/5, 2, 17, -267/4, 43/2 ],
      [ 528/5, -40, 72/5, 0, -120, 238, 3193/5, -1071/5, 2, 36/5, -2, 219,
          -716, 0, -1, -118/5, 1, 6, -220, 72 ],
      [ 88/5, 7, -128/5, 0, 21, -35, 488/5, -161/5, -3, -64/5, 1, 12, 107,
          -4, 0, 202/5, 0, 4, -14, 4 ],
      [ 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 2, 0, 0, -1, 0, 0, 0, 0 ],
      [ 2, 2, 8, 0, 8, -18, 12, -4, -1, 4, -1, 0, 52, 0, 0, -13, 1, 1, -1, 1
         ], [ 0, 0, 0, 0, -1, 2, 3, -1, 0, 0, 1, 0, -6, 0, 0, 1, 0, -1, 0, 0
         ],
      [ -3, 0, 0, 1, -1, 7, -3, 1, 0, 0, 6, -5, -16, 0, 0, 5, 0, -5, 5, -2 ],
      [ 1634/5, -113, 376/5, 0, -332, 637, 9984/5, -3348/5, 2, 188/5, -10,
          649, -1938, 0, -3, -639/5, 7, 23, -668, 221 ],
      [ 0, -1, -8, 0, -3, 7, 0, 0, -1, -4, 1, 1, -21, 0, 0, 12, 0, 0, -1, 0 ]
        , [ 1056/5, -81, 104/5, 0, -245, 487, 6386/5, -2142/5, 2, 52/5, -2,
          440, -1464, 0, -1, -171/5, 1, 7, -441, 144 ],
      [ 2, 2, 8, 0, 8, -21, 18, -6, -1, 4, -1, -3, 58, 0, 0, -14, 1, 1, -1,
          1 ],
      [ -709/10, 103/2, -43/5, -1, 309/2, -313, -4669/10, 3241/20, -4,
          -24/5, -3, -743/4, 935, -1, 1, 62/5, 1, -2, 739/4, -109/2 ],
      [ -443/10, 101/2, -81/5, -3, 291/2, -296, -3173/10, 2267/20, -9,
          -48/5, -5, -577/4, 883, -3, 3, 134/5, 0, -10, 577/4, -81/2 ] ],
  [ [ -2121/10, 78/5, -114/5, 0, 414/5, -938/5, -1146, 3679/10, 2, -27/5, 0,
          -3651/10, 2734/5, 6, -2, 41/5, 2, 4, 3451/10, -629/5 ],
      [ 729/20, 19/5, 38/5, 0, 77/5, -169/5, 171, -861/20, 5, 53/10, 7,
          1089/20, 507/5, 10, 5, -89/10, -10, -30, -1229/20, 371/10 ],
      [ 27, -3, -6, 1, -14, 33, 150, -50, 2, -4, 1, 46, -97, -3, -3, 11, 3,
          15, -43, 13 ],
      [ -127/20, -2/5, -4/5, 0, 9/5, -23/5, -33, 223/20, 3, 1/10, 1,
          -207/20, 64/5, 1, -1, -3/10, 0, 3, 167/20, -23/10 ],
      [ 26, 0, 15, 0, 4, -15, 162, -54, -3, 8, -3, 34, 39, -2, -1, -27, 4,
          6, -39, 13 ],
      [ -70, 4, -17, 0, 12, -25, -396, 132, 5, -8, 5, -115, 75, 6, 3, 29,
          -8, -18, 109, -35 ],
      [ 1579/20, -26/5, 78/5, 0, -148/5, 331/5, 433, -2811/20, -1, 53/10,
          -2, 2659/20, -968/5, -4, 0, -139/10, 1, 3, -2519/20, 441/10 ],
      [ 4137/20, -53/5, 204/5, 0, -279/5, 608/5, 1140, -7373/20, -2, 159/10,
          -6, 6777/20, -1789/5, -9, -1, -457/10, 4, 11, -6557/20, 1173/10 ],
      [ 1159/5, -64/5, 72/5, 1, -187/5, 369/5, 1281, -2051/5, -2, 36/5, -3,
          1879/5, -1112/5, -3, -1, -118/5, 3, 7, -1874/5, 707/5 ],
      [ -476/5, 31/5, 52/5, -5, 158/5, -381/5, -522, 849/5, -10, 36/5, -5,
          -781/5, 1108/5, 6, 6, -113/5, -3, -30, 751/5, -258/5 ],
      [ 22, -2, 2, 0, -11, 25, 120, -40, -2, 0, -1, 39, -73, -2, 0, 0, 1, 2,
          -35, 11 ],
      [ 42, -5, 5, 0, -29, 68, 228, -76, -2, 0, -1, 78, -197, -4, 0, 2, 1,
          3, -68, 21 ],
      [ -24, 1, -8, 0, 2, -3, -138, 46, 2, -4, 2, -38, 10, 2, 1, 14, -3, -6,
          37, -12 ],
      [ -110, 5, -1, 0, 13, -28, -612, 204, 6, 0, 10, -182, 82, 10, 4, 9,
          -9, -26, 170, -55 ],
      [ 4392/5, -317/5, 336/5, 2, -1271/5, 2742/5, 4818, -7778/5, -16,
          108/5, -19, 7377/5, -8086/5, -26, -3, -319/5, 14, 38, -7122/5,
          2581/5 ],
      [ 3, -1, 0, -1, -2, 3, 18, -6, -2, 0, -1, 6, -10, 0, 0, -1, 1, 0, -6,
          2 ],
      [ 2223/5, -123/5, 99/5, 1, -344/5, 668/5, 2457, -3927/5, -4, 52/5, -5,
          3598/5, -2024/5, -4, -1, -176/5, 4, 8, -3603/5, 1369/5 ],
      [ 42, -6, 6, 0, -35, 81, 222, -74, -2, 0, -2, 81, -235, -4, 0, 2, 1,
          4, -69, 21 ],
      [ -1449/20, -14/5, -63/5, 0, -122/5, 314/5, -396, 2361/20, -4, -93/10,
          -3, -1989/20, -892/5, -7, -1, 279/10, 3, 10, 2329/20, -551/10 ],
      [ -1223/20, -18/5, -156/5, 0, -89/5, 238/5, -339, 1987/20, -5,
          -171/10, -4, -1563/20, -669/5, -7, -2, 473/10, 4, 15, 1943/20,
          -477/10 ] ],
  [ [ 97, -18, -62, -12, -64, 138, 546, -182, -32, -32, -2, 184, -408, -6,
          4, 104, 6, -12, -168, 54 ],
      [ 66, -3, 66, -8, -32, 64, 387, -129, -16, 28, -7, 123, -186, -6, 3,
          -76, 7, -20, -107, 37 ],
      [ -57, 5, -18, 3, 22, -47, -330, 110, 0, -8, 1, -102, 133, 5, 0, 19,
          -1, 4, 92, -30 ],
      [ 6, -1, 1, -1, -5, 10, 36, -12, -7, 0, -1, 11, -32, 0, 1, 0, 2, -3,
          -11, 4 ],
      [ 0, -2, -12, 2, 1, 2, -15, 5, 10, -4, 3, 5, -2, 0, -3, 12, -1, 14,
          -1, -1 ],
      [ 9, 1, 29, -3, -8, 18, 45, -15, -9, 12, -2, 27, -48, -1, 2, -32, 3,
          -14, -14, 6 ],
      [ -46, 9, 21, 6, 36, -76, -263, 88, 18, 12, 1, -90, 225, 3, -3, -40,
          -3, 12, 81, -26 ],
      [ -90, 18, 32, 12, 76, -159, -519, 174, 38, 20, 2, -178, 471, 6, -7,
          -68, -6, 30, 159, -51 ],
      [ 1, -2, -20, 1, 3, -6, 3, -1, 14, -8, 2, 3, 21, 0, -3, 24, -3, 12,
          -3, 0 ],
      [ 120, -10, 14, -6, -47, 103, 696, -232, -18, 5, -2, 207, -299, -10,
          3, -8, 5, -14, -193, 63 ],
      [ -26, 2, -10, 2, 12, -23, -153, 51, 9, -4, 1, -44, 70, 2, -2, 11, -2,
          8, 42, -14 ],
      [ -43, 7, 14, 5, 28, -60, -240, 80, 14, 8, 1, -84, 176, 3, -2, -28,
          -3, 8, 74, -24 ],
      [ -1, 1, 10, -1, -1, 2, -6, 2, -4, 4, -1, 1, -5, 0, 1, -11, 1, -6, 2,
          0 ],
      [ -13, 5, 81, -5, -3, 8, -81, 27, -13, 36, -9, -11, -24, 1, 0, -103,
          11, -4, 22, -4 ],
      [ -244, 26, -58, 32, 145, -301, -1407, 469, 113, -16, 20, -445, 904,
          17, -18, 29, -30, 68, 408, -138 ],
      [ 2, 0, -8, 0, -1, 3, 12, -4, -6, -4, 0, 1, -11, 0, 1, 11, 1, -2, -3,
          1 ],
      [ 5, -4, -47, 1, 3, 0, 15, -5, 20, -20, 5, 18, 10, 0, -5, 62, -4, 19,
          -11, 2 ],
      [ -59, 8, 5, 7, 33, -70, -336, 112, 17, 4, 3, -110, 207, 4, -2, -17,
          -5, 7, 100, -33 ],
      [ -39, 5, -12, 7, 26, -57, -213, 71, 16, -4, 5, -81, 167, 3, -1, 6,
          -7, 4, 68, -23 ],
      [ 9, -5, -60, 5, -7, 11, 63, -21, 4, -28, 10, 9, -33, 0, 3, 79, -10,
          -13, -16, 3 ] ],
  [ [ -446/5, 47, -254/5, 2, 141, -276, -2941/5, 2019/10, -2, -122/5, 6,
          -401/2, 836, 0, 2, 376/5, -4, -8, 417/2, -65 ],
      [ 1009/10, -95/2, 73/5, 5, -267/2, 267, 6379/10, -4381/20, 3, 44/5, 0,
          883/4, -804, -2, -3, -157/5, 3, 17, -895/4, 135/2 ],
      [ 11, -2, -6, -1, -12, 24, 60, -20, -6, -4, 0, 22, -70, -1, 3, 12, -2,
          -13, -19, 6 ],
      [ 133/10, 1/2, -4/5, 0, 3/2, -6, 793/10, -517/20, -3, -2/5, 0, 67/4,
          16, -1, 1, 1/5, 0, -4, -75/4, 13/2 ],
      [ -17, -1, 1, -3, -6, 14, -96, 32, 3, 0, 0, -22, -39, 2, 1, 5, -3, -7,
          23, -7 ],
      [ 18, -3, -24, 2, -9, 25, 84, -28, 2, -12, 0, 35, -71, -2, -3, 32, 2,
          17, -29, 8 ],
      [ 329/10, -21/2, 108/5, -2, -69/2, 68, 2059/10, -1391/20, 1, 49/5, -3,
          261/4, -206, -1, -1, -147/5, 2, 4, -265/4, 43/2 ],
      [ 977/10, -65/2, 239/5, -5, -213/2, 213, 6027/10, -4073/20, 2, 107/5,
          -6, 795/4, -641, -3, -2, -316/5, 4, 8, -791/4, 127/2 ],
      [ 473/5, -40, 32/5, -1, -120, 246, 2848/5, -956/5, 6, 16/5, 0, 209,
          -733, 1, -2, -33/5, 0, 7, -204, 67 ],
      [ -92/5, 14, 52/5, 2, 54, -117, -457/5, 154/5, 3, 36/5, 0, -60, 341,
          -1, -3, -123/5, 4, 14, 48, -15 ],
      [ -12, 1, -1, 0, 6, -12, -72, 24, 3, 0, 0, -18, 37, 1, -1, 0, 0, 3,
          19, -6 ],
      [ 1, 1, 17, -1, 2, -7, 15, -5, 0, 8, -2, -2, 18, 0, 0, -24, 1, -1, -1,
          1 ],
      [ 9, -1, -8, 1, -3, 8, 45, -15, 0, -4, 0, 16, -23, -1, -1, 10, 1, 6,
          -14, 4 ],
      [ 65, -2, -7, 5, -9, 20, 366, -122, -1, -4, 0, 100, -58, -7, 0, 7, 0,
          6, -97, 30 ],
      [ 1404/5, -118, 241/5, -8, -357, 731, 8499/5, -2853/5, 19, 108/5, -11,
          622, -2183, 3, -10, -289/5, 7, 36, -608, 202 ],
      [ 10, 0, 0, 0, 0, -3, 63, -21, -3, 0, 0, 13, 7, -1, 1, -1, 0, -4, -15,
          5 ],
      [ 1006/5, -82, 24/5, -2, -246, 503, 6041/5, -2027/5, 11, 12/5, 0, 438,
          -1499, 1, -4, -11/5, 0, 15, -428, 140 ],
      [ -1, 1, 9, -1, 3, -7, -3, 1, 0, 4, -3, -3, 19, 0, -1, -13, 2, 4, 2, 0
         ], [ -1159/10, 107/2, -8/5, -2, 325/2, -330, -7129/10, 4881/20, 0,
          -4/5, -2, -1039/4, 985, 3, 0, 17/5, 1, -3, 1015/4, -153/2 ],
      [ -1673/10, 119/2, -111/5, -2, 375/2, -381, -10163/10, 6927/20, 0,
          -48/5, 0, -1389/4, 1137, 8, 0, 154/5, 0, -5, 1353/4, -205/2 ] ],
  [ [ -1481/10, 28/5, 26/5, 0, 84/5, -198/5, -810, 2559/10, 2, 13/5, 0,
          -2371/10, 574/5, 0, 0, -39/5, 0, 0, 2391/10, -469/5 ],
      [ 3189/20, -36/5, 53/5, -3, -108/5, 201/5, 873, -5541/20, 0, 53/10, 2,
          5169/20, -603/5, 0, 0, -159/10, 0, 0, -5169/20, 1001/10 ],
      [ -5, 2, -1, 3, 8, -14, -33, 11, 3, 0, 1, -11, 42, 0, -1, -1, 0, 5,
          11, -4 ],
      [ 153/20, -12/5, 1/5, 0, -36/5, 72/5, 45, -297/20, 0, 1/10, 1, 293/20,
          -216/5, 0, 0, -3/10, 0, 0, -293/20, 47/10 ],
      [ -7, 3, 0, 1, 11, -21, -42, 14, 0, 0, -2, -14, 63, 0, 0, 0, 0, 0, 14,
          -4 ],
      [ 4, -2, 0, 0, -8, 13, 33, -11, 0, 0, 2, 5, -42, 0, 0, 0, 0, 0, -8, 2 ]
        , [ 599/20, 4/5, -27/5, 1, 12/5, -9/5, 160, -991/20, -1, -27/10, 0,
          899/20, 37/5, 0, 0, 81/10, 0, 0, -919/20, 191/10 ],
      [ 1837/20, 12/5, -41/5, 3, 36/5, -42/5, 489, -3033/20, -2, -41/10, 0,
          2777/20, 146/5, 0, 0, 123/10, 0, 0, -2817/20, 583/10 ],
      [ 984/5, -59/5, 32/5, 0, -172/5, 334/5, 1086, -1726/5, 0, 16/5, -2,
          1594/5, -1012/5, 0, 0, -48/5, 0, 0, -1609/5, 622/5 ],
      [ -171/5, -4/5, 122/5, -6, -32/5, 29/5, -174, 269/5, -9, 56/5, -2,
          -256/5, -102/5, 0, 2, -158/5, 3, -10, 256/5, -103/5 ],
      [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0 ],
      [ -2, 0, -8, 0, 0, 3, -12, 4, -1, -4, 0, -3, -7, 0, 0, 12, 0, 0, 3, -1
         ],
      [ 2, -1, 0, 0, -4, 7, 15, -5, 0, 0, 1, 3, -22, 0, 0, 0, 0, 0, -4, 1 ],
      [ -3, 1, -1, 1, 5, -10, -18, 6, 3, 0, 6, -6, 30, 1, -1, 0, 0, 4, 6, -2
         ],
      [ 2902/5, -177/5, 96/5, 0, -516/5, 1042/5, 3213, -5103/5, 4, 48/5,
          -10, 4687/5, -3136/5, 0, -4, -139/5, 4, 15, -4752/5, 1841/5 ],
      [ 2, 0, 8, 0, 0, -1, 12, -4, -1, 4, 0, 3, 2, 0, 0, -12, 1, 0, -3, 1 ],
      [ 1978/5, -123/5, 64/5, 0, -364/5, 713/5, 2181, -3467/5, 0, 32/5, -3,
          3218/5, -2154/5, 0, 0, -91/5, 0, 0, -3238/5, 1249/5 ],
      [ -2, 0, 0, 0, 0, 2, -9, 3, 1, 0, -1, -4, -5, 0, -1, 0, 1, 4, 3, -1 ],
      [ -2949/20, 16/5, -93/5, -1, 48/5, -81/5, -801, 5061/20, -1, -93/10,
          -2, -4689/20, 253/5, 0, 0, 279/10, 0, 0, 4689/20, -921/10 ],
      [ -2603/20, -8/5, -51/5, -3, -24/5, 48/5, -699, 4387/20, 0, -51/10,
          -5, -4023/20, -144/5, 0, 0, 153/10, 0, 0, 4023/20, -807/10 ] ],
  [ [ -19, -4, -50, 0, -8, 16, -114, 38, -2, -24, 0, -30, -52, 2, 0, 68, -2,
          4, 26, -10 ],
      [ -69, 11, -5, 5, 48, -102, -405, 135, 12, 0, 0, -122, 303, 5, -2, -5,
          -3, 8, 116, -37 ],
      [ 14, -3, 1, -2, -12, 27, 81, -27, -1, 0, 0, 29, -79, -1, -1, 2, 2, 3,
          -25, 8 ],
      [ -7, 0, -1, 0, 3, -6, -42, 14, 3, 0, 0, -10, 18, 1, -1, 0, 0, 4, 10,
          -3 ],
      [ 37, -4, 3, -1, -21, 44, 219, -73, -8, 0, 0, 60, -133, -3, 2, 1, 1,
          -6, -60, 19 ],
      [ -24, 2, -2, 0, 15, -36, -126, 42, 6, 0, 0, -45, 104, 2, -2, -3, 0,
          6, 38, -12 ],
      [ 22, 2, 25, 0, 4, -8, 130, -43, -1, 12, 0, 32, 25, -2, 0, -34, 2, -1,
          -31, 11 ],
      [ 56, 4, 50, 0, 8, -16, 330, -109, -4, 24, 0, 81, 49, -5, 0, -68, 5,
          -1, -80, 28 ],
      [ 25, -3, -6, -1, -15, 29, 150, -50, -8, -4, 0, 40, -89, -2, 2, 12, 1,
          -7, -41, 13 ],
      [ -58, 6, -3, 4, 30, -66, -342, 114, 11, 1, 0, -103, 194, 5, -1, -7,
          -4, 6, 95, -31 ],
      [ 1, -1, 1, -1, -6, 12, 9, -3, -3, 0, 0, 3, -36, 0, 1, 1, 0, -5, -3, 1
         ],
      [ 10, 1, 17, 0, 0, 2, 54, -18, 0, 8, 0, 18, -3, -1, 0, -22, 1, -1,
          -14, 5 ],
      [ -12, 1, -1, 0, 7, -16, -66, 22, 3, 0, 0, -21, 47, 1, -1, -1, 0, 3,
          19, -6 ],
      [ -65, 10, -6, 5, 48, -97, -390, 130, 16, 0, -1, -111, 290, 5, -6, -6,
          1, 25, 110, -35 ],
      [ 132, -11, 51, -8, -65, 127, 792, -264, -26, 20, -1, 217, -380, -11,
          6, -52, 8, -28, -213, 70 ],
      [ -10, 0, -1, 0, 2, -4, -60, 20, 3, 0, 0, -15, 12, 1, -1, 0, 0, 4, 15,
          -5 ],
      [ 38, -5, -13, -2, -23, 42, 234, -78, -13, -8, -1, 58, -132, -3, 3,
          23, 2, -10, -63, 20 ],
      [ 11, 0, 17, -1, -3, 6, 66, -22, 0, 8, 0, 19, -16, -1, 0, -22, 1, -2,
          -17, 6 ],
      [ 28, -3, 19, -2, -18, 38, 162, -54, -4, 8, 0, 50, -110, -2, 2, -20,
          0, -10, -45, 15 ],
      [ 39, -10, 5, -5, -45, 90, 234, -78, -9, 0, 0, 74, -267, -2, 5, 5, -3,
          -23, -71, 23 ] ] ];
          return Group( gens );
       fi;

     if n = 30 then
        # subgroup of a group which is conjugate to a direct product
        # of PolExamples(1) and PolExamples(6);
        gens := 
           [ [ [ -402, -128, 32, 24, -452, 798, -293, 349 ],
           [ 3, 37, 20, -9, 5, -11, 29, 7 ],
           [ -67, 56, 5, -15, -105, 133, 21, 65 ],
           [ -114, 660, 80, -164, -325, 208, 528, 199 ],
           [ -2, 220, 0, -55, -90, 4, 199, 18 ],
           [ -213, 236, 16, -63, -359, 423, 121, 209 ],
           [ -36, 260, 0, -65, -144, 72, 221, 57 ],
           [ 3, -228, 0, 57, 94, -6, -206, -20 ] ],
         [ [ -446, 1144, -64, -288, -1114, 910, 833, 407 ],
           [ -9, 37, -4, -9, -31, 19, 29, 7 ],
           [ -125, 155, -7, -39, -223, 252, 77, 113 ],
           [ -510, 428, -16, -106, -779, 1024, 104, 457 ],
           [ -108, 28, 0, -7, -134, 216, -35, 96 ],
           [ -407, 608, -32, -153, -781, 823, 347, 367 ],
           [ -190, 92, 0, -23, -254, 380, -23, 171 ],
           [ 159, 12, 0, -3, 176, -318, 98, -140 ] ],
  [ [ -621, 2704, -64, -684, -1991, 1260, 2143, 599 ],
      [ 17, -107, -8, 27, 63, -32, -87, -21 ],
      [ -1, 248, -7, -63, -117, 4, 225, 3 ],
      [ 856, -1252, -32, 314, 1560, -1704, -694, -819 ],
      [ 194, -408, 0, 102, 411, -388, -268, -186 ],
      [ -14, 776, -32, -198, -388, 37, 704, 16 ],
      [ 322, -444, 0, 111, 581, -644, -237, -303 ],
      [ -222, 480, 0, -120, -476, 444, 319, 214 ] ],
  [ [ 751, 1404, 0, -351, 316, -1500, 1588, -669 ],
      [ 0, 1, 0, 0, 0, 0, 0, 0 ], [ 36, 48, 1, -12, 28, -72, 58, -30 ],
      [ -609, -1316, 0, 330, -135, 1218, -1457, 564 ],
      [ -184, -380, 0, 95, -53, 368, -423, 168 ],
      [ 108, 144, 0, -36, 84, -215, 174, -90 ],
      [ -267, -568, 0, 142, -66, 534, -629, 246 ],
      [ 200, 420, 0, -105, 55, -400, 466, -182 ] ],
  [ [ -127, 2424, 0, -606, -1351, 256, 2117, 75 ],
      [ 0, 1, 0, 0, 0, 0, 0, 0 ], [ 4, 0, 1, 0, 2, -8, 2, -6 ],
      [ 208, -2844, 0, 712, 1634, -416, -2456, -159 ],
      [ 50, -808, 0, 202, 455, -100, -702, -36 ],
      [ 12, 0, 0, 0, 6, -23, 6, -18 ],
      [ 84, -1220, 0, 305, 695, -168, -1055, -63 ],
      [ -54, 936, 0, -234, -520, 108, 815, 40 ] ],
  [ [ -402, -128, 32, 24, -452, 798, -293, 349 ],
      [ 3, 37, 20, -9, 5, -11, 29, 7 ],
      [ -67, 56, 5, -15, -105, 133, 21, 65 ],
      [ -114, 660, 80, -164, -325, 208, 528, 199 ],
      [ -2, 220, 0, -55, -90, 4, 199, 18 ],
      [ -213, 236, 16, -63, -359, 423, 121, 209 ],
      [ -36, 260, 0, -65, -144, 72, 221, 57 ],
      [ 3, -228, 0, 57, 94, -6, -206, -20 ] ],
  [ [ -611, 600, 0, -150, -979, 1224, 257, 615 ], [ 0, 1, 0, 0, 0, 0, 0, 0 ],
      [ -276, -1536, 1, 384, 338, 552, -1510, 210 ],
      [ -1604, -13100, 0, 3276, 3766, 3208, -12532, 1065 ],
      [ -302, -3016, 0, 754, 947, 604, -2854, 180 ],
      [ -828, -4608, 0, 1152, 1014, 1657, -4530, 630 ],
      [ -608, -5252, 0, 1313, 1551, 1216, -5007, 393 ],
      [ 422, 3960, 0, -990, -1212, -844, 3759, -260 ] ],
  [ [ 7, 2628, -992, -657, -2051, 236, 2575, -430 ],
      [ -21, 37, -28, -9, -67, 49, 29, 7 ],
      [ -131, 324, -123, -81, -435, 293, 261, 57 ],
      [ -1520, -540, -112, 136, -1868, 3068, -1127, 1264 ],
      [ -316, -168, 0, 42, -347, 632, -288, 270 ],
      [ -483, 1116, -496, -279, -1591, 1091, 899, 199 ],
      [ -566, -276, 0, 69, -630, 1132, -494, 486 ],
      [ 342, 60, 0, -15, 441, -684, 201, -287 ] ],
  [ [ -562, 440, -64, -120, -996, 1142, 171, 461 ],
      [ 22, -143, -12, 36, 82, -41, -116, -28 ],
      [ -87, 127, -7, -33, -173, 176, 79, 79 ],
      [ -38, -60, -48, 16, -17, 88, -52, 59 ],
      [ -2, 220, 0, -55, -90, 4, 199, 18 ],
      [ -293, 520, -32, -135, -631, 595, 353, 265 ],
      [ -36, 260, 0, -65, -144, 72, 221, 57 ],
      [ 3, -228, 0, 57, 94, -6, -206, -20 ] ] ];
    return Group( gens );
    fi;
    if n= 31 then
       gens := GeneratorsOfGroup( MatExamples(4) );
       return Group( gens{[1,2]} );
    fi;
    return fail;
end;


#############################################################################
##
#F POL_RandomRationalTriangularGroup( dim, numberOfGens )
##
POL_RandomRationalTriangularGroup := function( dim, numberOfGens )
    local gens, i, g, j, k, range, kk,ll;

    range := 7;
    ll := [-range..range];
    kk := [-range..range];
    ll := Filtered( ll, (x->x<>0) );
    kk := Filtered( kk, (x->x<>0) ); 
   
    gens:=[];
    for i in [1..numberOfGens] do
        g:=IdentityMat(dim,Rationals);
        for j in [1..dim] do
            for k in [j..dim] do
                if j<=k then
                   g[j][k] := RandomList( ll )/RandomList( kk );
                else 
                   g[j][k] := 0;
                fi;
            od;
        od;
        Add(gens,g);
    od;
    return gens;
end; 

#############################################################################
##
#F  POL_RandomRationalUnipotentGroup( dim, numberOfGens )
##
POL_RandomRationalUnipotentGroup := function( dim, numberOfGens )
    local G, x;
    G := POL_RandomRationalTriangularGroup( dim, numberOfGens );
    x := RandomInvertibleMat( dim, Rationals );
    return G^x;
end;


#############################################################################
##
#F POL_RandomSubgroup( G, numberOfgens )
##
##
POL_RandomSubgroup := function( G, numberOfNewGens )
    local gens,newGens, i;
    gens := GeneratorsOfGroup( G );
    newGens := [];
    for i in [1..numberOfNewGens] do
        Add( newGens, POL_RandomGroupElement( gens ) );
    od;
    return Group( newGens );
end;

#############################################################################
##
#F POL_DirectProduct( G1, G2 )
##
##
POL_DirectProduct:= function( G1, G2 )
    local n1, n2, gens, k, i, j, matrix, x, G, gens1, gens2;
    gens1 := GeneratorsOfGroup( G1 );
    gens2 := GeneratorsOfGroup( G2 );
    n1 := Length( gens1[1] );
    n2 := Length( gens2[2] );
    gens := [];
    for k in [1..Length( gens1 )] do
        matrix := IdentityMat( n1+n2 );
        for i in [1..n1] do
            for j in [1..n1] do
                 matrix[i][j] := gens1[k][i][j]; 
            od;
        od;
        Add( gens, matrix );
    od;
    for k in [1..Length( gens2 )] do
        matrix := IdentityMat( n1+n2 );
        for i in [1..n2] do
            for j in [1..n2] do
                 matrix[i+n1][j+n1] := gens2[k][i][j]; 
            od;
        od;
        Add( gens, matrix );
    od; 
    return Group( gens ); 
end;


#############################################################################
##
#F POL_SemidirectProductVectorSpace( G )
##
POL_SemidirectProductVectorSpace := function( G )
    local gens, n, newGens, g, h, i, v;
    gens := GeneratorsOfGroup( G );
    n := Length( gens[1] );
    newGens := [];
    for g in gens do 
        h := POL_CopyVectorList( g );
        for i in [1..n] do
            Add( h[i], 0 );
        od;
        v := List( [1..n+1], x->0 );
        v[n+1] := 1;
        Add( h, v );
        Add( newGens, h );
    od;
    for i in [1..n] do
        h := IdentityMat( n+1 );
        h[i][n+1] := 1;
        Add( newGens, h );
    od;
    return Group( newGens );
end;


POL_IrredPol := function( n )
    local x,p;
    x := Indeterminate(Rationals,"x":old);

    if n = 1 then 
       p :=  x^2 + 6*x + 3;
       return p;
    fi;
    if n = 2 then 
       p := x^3 + 14*x^2 - 49*x + 7;
       return p;
    fi;
    if n = 3 then 
       p := x^2+1; 
       return p;
    fi;
    if n = 4 then
       p := x^3+2*x+2; 
       return p;
    fi;
    if n = 5 then 
       p := x^3+2*x+2;
       return p;
    fi;
    if n = 6 then 
       p := -4*x^2-2*x+1;
       return p;
    fi;
end;

POL_AbelianIrreducibleGens := function( n )
    local k,l,ll,range,pol,mat,n_gens,gens,i,exps,l_comb,g;

    pol := POL_IrredPol( n );
    mat := CompanionMat( pol );
    
    range := 3;
    l := [-range..range];
    l := Filtered( l, (x -> x<>0) );
    # k := [-range..range];
    k := [1];
    k := Filtered( k, (x -> x<>0) );

    exps := [0,1,2];
   
    n_gens := 3;
    gens := [];
    for i in [1..n_gens] do
        l_comb := 2;
        ll := List( [1..l_comb], x-> RandomList(l)/RandomList(k) );
        g := List( [1..l_comb] , x-> ll[x]*mat^RandomList(exps) );
        Add( gens, Sum( g ) );
    od;  

    return gens;
end;

POL_RandomUnitGroupGens := function( n )
    local F, U, u_gens, n_gens, gens;

    F := ExampleMatField( n );
    U := UnitGroup( F );
    u_gens := GeneratorsOfGroup( U );

    n_gens := 3;
    gens := List( [1..n_gens], x->POL_RandomGroupElement( u_gens  ));

    return gens;

end;


POL_TriangularizableGens := function( n_blocks, n_gens )
    local n_fields,a_gens,i,ll,dim,j,k,start,rr,gens,g,start1,start2,
          rr1,rr2, u_entries, mat;
  
    n_fields := 6;
    a_gens := [];
    for i in [1..n_blocks] do 
        Add( a_gens, POL_RandomUnitGroupGens(  RandomList( [1..n_fields] )) );
    od;
  
    #get dimension of composed matrix
    ll := List( [1..n_blocks], x-> Length( a_gens[x][1] ));
    dim := Sum( ll );

    #get final generators
    gens := [];
    for i in [1..n_gens] do 
        g := NullMat( dim,dim );
        #write blocks
        for j in [1..n_blocks] do 
            for k in [j..n_blocks] do 
                if j = k then
                   #place block on diagonal
                     # set starting point
                     start := Sum( ll{[1..(j-1)]} );
                     # get range
                     rr := [1..ll[j]]+start;
                     g{rr}{rr} := RandomList( a_gens[j] );
                elif j <= k then
                   # write upper part
                     #set starting points
                     start1 := Sum( ll{[1..(j-1)]} );
                     start2 := Sum( ll{[1..(k-1)]} );
                     #get range
                     rr1 := [1..ll[j]]+start1;
                     rr2 := [1..ll[k]]+start2;
                     u_entries := [0,0,0,1/2,0];
                     mat := RandomMat( ll[j], ll[k], u_entries );
                     g{rr1}{rr2} := mat;
                     
                fi;
             od;
         od;
        Add( gens, g );
     od;
 
    return gens; 
       

end;


#############################################################################
##
#F POL_PolExamples2( n ) .............Examples for polycyc rat. matrix groups
##
POL_PolExamples2 := function( n )
    local i,M,P, nat, G, gens, d, l, l1, l2, l3,h1,h2,H,g,h;

    # check if aclib is needed
    l1 := Concatenation( [9..16],[21..28],[37..40]);
    l2 := l1 + 40;
    l3 := [82..100];
    l := Concatenation( l1, l2 ,l3);
    l1 := l+100;
    l := Concatenation( l, l1 );
    l1 := l+300;
    l := Concatenation( l, l1 ); 
    l1 := l+400;
    l := Concatenation( l, l1 ); 
    if POL_AlmostCrystallographicGroup = false then 
        if n in l then
            Print( "package 'aclib' is needed for this example.\n" );
            return fail;
        fi;
    fi;

    # some unipotent groups
    if n=1 then
        return Group(
               [ [ [ 1, -4, 1, 2 ], 
                   [ 0, 1, 5, 1 ], 
                   [ 0, 0, 1, 3 ], 
                   [ 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, -1, -2, 4 ], 
                   [ 0, 1, -1, 1 ], 
                   [ 0, 0, 1, 1 ], 
                   [ 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, -4, -2, 1 ], 
                   [ 0, 1, -2, -3 ], 
                   [ 0, 0, 1, 2 ], 
                   [ 0, 0, 0, 1 ] ] 
                ]);
    fi;
    if n=2 then
        return Group(
               [ [ [ 1, 5, -3, 1, -3 ], 
                   [ 0, 1, 2, 0, 1 ], 
                   [ 0, 0, 1, 2, -2 ],
                   [ 0, 0, 0, 1, -2 ], 
                   [ 0, 0, 0, 0, 1 ] ]
                 ,
                 [ [ 1, 3, -3, -1, 1 ], 
                   [ 0, 1, 0, -2, 2 ], 
                   [ 0, 0, 1, 4, 1 ],
                   [ 0, 0, 0, 1, -1 ], 
                   [ 0, 0, 0, 0, 1 ] ] 
               ]);
    fi;
    if n=3 then
        return Group( 
               [ [ [ 73/10, -35/2, 42/5, 63/2 ], 
                   [ 27/20, -11/4, 9/5, 27/4 ],
                   [ -3/5, 1, -4/5, -9 ], 
                   [ -11/20, 7/4, -2/5, 1/4 ] ]
                 ,
                 [ [ -42/5, 423/10, 27/5, 479/10 ], 
                   [ -23/10, 227/20, 13/10, 231/20 ],
                   [ 14/5, -63/5, -4/5, -79/5 ],
                   [ -1/10, 9/20, 1/10, 37/20 ] ] 
               ]);
    fi;
    if n=4 then
        return Group(
               [ [ [ 5, 2, -8, 17, -1 ], 
                   [ -69/4, -15/4, 449/20, -163/5, 53/20 ],
                   [ -2, 4, 9/5, 63/5, 3/5 ], 
                   [ 13/4, 3/4, -121/20, 57/5, -17/20 ],
                   [ 241/4, 7/4, -1477/20, 319/5, -189/20 ] ]
                  ,
                  [ [ 19/2, 0, -3, -19/2, -1/2 ], 
                    [ -74/5, 129/20, 7/4, 159/4, 9/10 ],
                    [ 53/10, 4/5, -4, 9/2, -9/10 ], 
                    [ 37/10, -41/20, -7/4, -29/4, -3/5 ],
                    [ 137/5, -457/20, 37/4, -559/4, 3/10 ] ] 
                ]);
    fi;
    if n in [5..8] then
        return MatExamples( n-4 );
    fi;
    if n=9 then
        return POL_AlmostCrystallographicGroup( 3, 17, [1,0,-3,7] );
    fi;
    if n=10 then
        return POL_AlmostCrystallographicGroup( 3, 16, [3,4,-1,0] );
    fi;
    if n=11 then
        return POL_AlmostCrystallographicGroup( 3, 15, [-1,1,0,0] );
    fi;
    if n=12 then
        return POL_AlmostCrystallographicGroup( 3, 14, [-2,-1,2,-1] );
    fi;
    if n=13 then
        return POL_AlmostCrystallographicGroup( 4, 2, [0,-3,-2,1,-1,-2,4] );
    fi;
    if n=14 then
        return POL_AlmostCrystallographicGroup( 4, 13, [-2,0,-2,-2,-1,-1] );
    fi;
    if n=15 then
        return POL_AlmostCrystallographicGroup( 4, 37, [ 1,2,0,-3,-4] );
    fi;
    if n=16 then
        return POL_AlmostCrystallographicGroup( 4, 86,[0,-2,-1,-2,-1] );
    fi;
    if n in [17..20] then
        return POL_KroneckerProduct( MatExamples( n-16), -1  );
    fi;
    if n in [21..28] then
        return POL_KroneckerProduct( PolExamples( n-12 ), 1 );
    fi; 
    if n=29 then
        return POL_DirectProduct( PolExamples( 1 ), PolExamples( 2 ) );
    fi;
    if n=30 then
        return POL_DirectProduct( PolExamples( 1 ), PolExamples( 4 ) );
    fi;
    if n=31 then
        return POL_DirectProduct( PolExamples( 2 ), PolExamples( 8 ) );
    fi;
    if n=32 then
        return POL_DirectProduct( PolExamples( 6 ), PolExamples( 7 ) );
    fi;
    if n=33 then
        return POL_DirectProduct( PolExamples( 1 ), PolExamples( 2 ) );
    fi;
    if n=34 then
        return POL_DirectProduct( PolExamples( 1 ), PolExamples( 4 ) );
    fi;
    if n=35 then
        return POL_DirectProduct( PolExamples( 2 ), PolExamples( 8 ) );
    fi;
    if n=36 then
        return POL_DirectProduct( PolExamples( 6 ), PolExamples( 7 ) );
    fi;
    if n=37 then
        return POL_DirectProduct( PolExamples( 1 ), PolExamples( 9 ) );
    fi; 
    if n=38 then
        return POL_DirectProduct( PolExamples( 10 ), PolExamples( 11 ) );
    fi; 
    if n=39 then
        return POL_DirectProduct( PolExamples( 17 ), PolExamples( 21 ) );
    fi; 
    if n=40 then
        return POL_DirectProduct( PolExamples( 2 ), PolExamples( 27 ) );
    fi; 
    if n in [41..81] then
        return POL_SemidirectProductVectorSpace( PolExamples( n-40 ) );
    fi;
    if n in [82..100] then
        return POL_AlmostCrystallographicGroup( 4, n-5, false );
    fi;
    if n in [101..200] then
        P := SymmetricGroup( 3 );
        M := POL_PolExamples2( n-100 );
        return WreathProductOfMatrixGroup( M, P );
    fi;
    if n in [201..300] then
        P := SmallGroup( 8, 3 );
        nat := RegularActionHomomorphism( P );
        P := Image( nat );
        M := POL_PolExamples2( n-200 );
        return WreathProductOfMatrixGroup( M, P );
    fi;
    if n in [301..600] then
        G := POL_PolExamples2( n-300 );
        gens := GeneratorsOfGroup( G );
        d := Length( gens[1] );
        M := RandomInvertibleMat( Integers, d );
        return G^M;
    fi;
    if n in [601..1200]  then
        return POL_RandomSubgroup( POL_PolExamples2( n-600), 2 );
    fi; 
    # examples which can be nonpolycyclic or nonsolvable
    if n = 1201 then
          h1 := [[2,0],[0,1]];
          h2 := [[1,1],[0,1]];
          H := Group( [h1,h2] );
          return H;
     fi;
     if n = 1202 then
         gens := [ [ [ -1/4, 5/4, -4/3 ], [ 1, 0, 1 ], [ 0, -5/3, -1 ] ],
                 [ [ 2, 3/5, 4 ], [ 2/3, 0, 1 ], [ 5/3, 0, 1/2 ] ] ];
         return Group( gens );
     fi;
     if n = 1203 then
         gens := [ [ [ 2, 4/3, 1/2, 1/2 ], [ -2, -1/2, -1/4, 1 ], 
                    [ -1/2, 0, 0, 3/2 ],
                  [ 0, 1/3, 0, 3/2 ] ],
              [ [ 2, 2, 1, 2 ], [ -2/5, 3/2, 0, -1/2 ], [ -3/2, 0, 1/3, 4 ],
                  [ -1/4, 0, -3, 0 ] ] ];
         return Group( gens );
     fi;
     if n = 1204 then
         gens := [ [ [ 3, 1, 3, -1 ], 
                   [ 2, -1, 1, 1 ], 
                  [ -1, 0, 1, 3 ], [ 1, 1, -1, 0 ] ],
              [ [ 0, -3, -1, 2 ], [ -3, -3, 0, -1 ], [ -1, -2, -1, 0 ],
                  [ 1, -1, 2, -5 ] ] ];
         return Group( gens );
     fi;
     if n= 1205 then
           gens := [ [ [ -7/3, 77/3, 0, 0, 1, 0 ], 
                     [ -77/3, 994/3, 0, 0, 0, 0 ],
                      [ 0, 0, 0, 0, 0, -28/3 ], [ 0, 0, 2/3, 0, 0, 22/3 ],
                      [ 0, 0, 0, 2/3, 0, -10/3 ], [ 0, 0, 0, 0, 2/3, -2 ]
                       ],
                      [ [ 1/3, 8/3, 0, 0, 0, 0 ], [ -8/3, 35, 0, 1, 0, 0 ],
                          [ 0, 0, 0, 0, 0, -28/3 ], [ 0, 0, 2/3, 0, 0, 22/3 ],
                          [ 0, 0, 0, 2/3, 0, -10/3 ], 
                         [ 0, 0, 0, 0, 2/3, -2 ]] ];
             return Group( gens );
     fi;
     if n = 1206 then
        gens := [ [ [ -6, -1/2, 3/4, -5/3 ], [ 0, -3, 3, -3/2 ], 
                 [ 0, 0, 1/3, -4/7 ],
                  [ 0, 0, 0, 1 ] ],
                [ [ 7/4, 2, 1/2, -5/3 ], [ 0, 5/6, -6, 1 ], [ 0, 0, 3, 2/7 ],
                  [ 0, 0, 0, 2/3 ] ] ];
        return Group( gens );
     fi;
     if n = 1207 then
        gens := [ [ [ 1, 5/7, 3/4, -5, 2/5 ], 
                  [ 0, -1, 3/2, 2, 4/7 ], [ 0, 0, 2/3, 1, -7/5 ],
                  [ 0, 0, 0, 1/5, 4/7 ], [ 0, 0, 0, 0, 2/5 ] ],
                  [ [ 2, -2/7, -4/7, 1, 3/7 ], [ 0, -1/5, -1/3, 1, 1/2 ],
                  [ 0, 0, -4/3, -3, 2 ], [ 0, 0, 0, 7, -1/6 ], 
                   [ 0, 0, 0, 0, -2 ] ] ];
        return Group( gens );
     fi;
     if n = 1208 then 
        gens := [ [ [ 3/2, -3, -4/5, 1/3, -3, -5/6, 4, 5/3 ],
                 [ 0, -1, 5/7, -1/2, 3/7, -1/3, -4/5, 1/2 ],
                 [ 0, 0, -1/4, 3/5, 5/2, -1/6, -1, 1 ],
                  [ 0, 0, 0, 1/5, 7/4, -2, -7/4, -1 ],
                  [ 0, 0, 0, 0, 5/3, -5/2, -1, -1/6 ], 
                  [ 0, 0, 0, 0, 0, -1, 5/2, -1 ],
                  [ 0, 0, 0, 0, 0, 0, 3, 1 ], 
                 [ 0, 0, 0, 0, 0, 0, 0, -2/7 ] ],
                [ [ 3/2, 1, -3/2, 1, -1, -2/5, 1/5, -1 ],
                [ 0, 1, 4/7, 1, -3/5, -5/7, 5/2, 3 ],
                 [ 0, 0, -1/3, 1, 3/2, -4/3, 3/2, 2/3 ],
                  [ 0, 0, 0, 3, -3, -7/5, 5/2, 1/2 ], 
                  [ 0, 0, 0, 0, 3/5, -2, 4/3, 1 ],
                 [ 0, 0, 0, 0, 0, -2, 3, 3 ], 
                  [ 0, 0, 0, 0, 0, 0, -1/2, -1/2 ],
                 [ 0, 0, 0, 0, 0, 0, 0, 5/3 ] ] ];
          return Group( gens );
       fi;
       if n = 1209 then
          gens := [ [ [ 5/6, -2, 1, 4, -1, 2 ], [ 2/3, -19/6, -1, 4, -3, 0 ],
      [ 0, 0, 5/6, -2, -1, -2 ], [ 0, 0, 2/3, -19/6, 0, -3 ],
      [ 0, 0, 0, 0, 5/6, -2 ], [ 0, 0, 0, 0, 2/3, -19/6 ] ],
  [ [ -1/2, -12/5, 3, -1, 1, -2 ], [ 4/5, -53/10, -2, -4, -2, 1 ],
      [ 0, 0, -1/2, -12/5, -2, -4 ], [ 0, 0, 4/5, -53/10, 2, 3 ],
      [ 0, 0, 0, 0, -1/2, -12/5 ], [ 0, 0, 0, 0, 4/5, -53/10 ] ],
  [ [ 4733/600, -2037/50, -2, -1, 4, -2 ], [ 679/50, -8831/120, 0, 0, -3, -2 ],
      [ 0, 0, 4733/600, -2037/50, 0, 2 ], [ 0, 0, 679/50, -8831/120, 4, 1 ],
      [ 0, 0, 0, 0, 4733/600, -2037/50 ], [ 0, 0, 0, 0, 679/50, -8831/120 ] ],
  [ [ 1, 0, -3, -2, -2, -4 ], [ 0, 1, 3, 2, 1, 3 ], [ 0, 0, 1, 0, -2, 1 ],
      [ 0, 0, 0, 1, 2, 0 ], [ 0, 0, 0, 0, 1, 0 ], [ 0, 0, 0, 0, 0, 1 ] ] ];
            return Group( gens );
       fi;
       if n = 1210 then
           # takes 6 minutes to test polycyclicity 
           gens := [ [ [ 63/20, -5/2, 121/2, -1475, -5, 1, 1, 1 ],
      [ 0, -237/20, 721/2, -17579/2, 1, -3, 2, -2 ],
      [ 2/5, -15/2, 3393/20, -8129/2, 1, -1, 1, -1 ],
      [ 1/2, -121/10, 295, -144107/20, -3, -1, 0, 0 ],
      [ 0, 0, 0, 0, 63/20, -5/2, 121/2, -1475 ],
      [ 0, 0, 0, 0, 0, -237/20, 721/2, -17579/2 ],
      [ 0, 0, 0, 0, 2/5, -15/2, 3393/20, -8129/2 ],
      [ 0, 0, 0, 0, 1/2, -121/10, 295, -144107/20 ] ],
  [ [ -281351/400, 34831/2, -8511437/20, 20798633/2, 3, 0, -2, 0 ],
      [ -85011/20, 41515849/400, -12680078/5, 1239406543/20, -1, 0, -1, 1 ],
      [ -196313/100, 959919/20, -469170371/400, 286619339/10, -1, -4, 1, 1 ],
      [ -34831/10, 8511437/100, -20798633/10, 20329462629/400, 1, -2, 4, -2 ],
      [ 0, 0, 0, 0, -281351/400, 34831/2, -8511437/20, 20798633/2 ],
      [ 0, 0, 0, 0, -85011/20, 41515849/400, -12680078/5, 1239406543/20 ],
      [ 0, 0, 0, 0, -196313/100, 959919/20, -469170371/400, 286619339/10 ],
      [ 0, 0, 0, 0, -34831/10, 8511437/100, -20798633/10, 20329462629/400 ] ],
  [ [ -5, -3, 75, -3665/2, 1, 0, -1, -2 ], [ 1/2, -23, 447, -10920, 0, -3, 1, 2 ],
      [ 0, -17/2, 202, -10101/2, -3, -1, 0, 1 ],
      [ 3/5, -15, 733/2, -17921/2, 0, 1, 2, 3 ],
      [ 0, 0, 0, 0, -5, -3, 75, -3665/2 ], [ 0, 0, 0, 0, 1/2, -23, 447, -10920 ],
      [ 0, 0, 0, 0, 0, -17/2, 202, -10101/2 ],
      [ 0, 0, 0, 0, 3/5, -15, 733/2, -17921/2 ] ],
  [ [ -50, -30, 750, -18325, 3, -2, 0, 2 ], [ 5, -230, 4470, -109200, 0, 1, 5, 3 ],
      [ 0, -85, 2020, -50505, 3, 0, 1, 4 ], [ 6, -150, 3665, -89605, 2, -3, 1, -1 ]
        , [ 0, 0, 0, 0, -50, -30, 750, -18325 ],
      [ 0, 0, 0, 0, 5, -230, 4470, -109200 ], [ 0, 0, 0, 0, 0, -85, 2020, -50505 ],
      [ 0, 0, 0, 0, 6, -150, 3665, -89605 ] ] ];
           return Group( gens );
        fi;



     ###############################################################
     # some easy examples
     if n = -1 then
         g := 2*IdentityMat( 2, 1 ); 
         gens := [g];
         return Group( gens );
     fi;
     if n = -2 then 
        g := 2*IdentityMat( 3, 1 ); 
         gens := [g];
         return Group( gens );  
     fi;
     if n = -3 then
        g := 1345*IdentityMat( 5, 1 ); 
         gens := [g];
         return Group( gens );  
     fi;
     if n = -4 then
        g := 23* IdentityMat( 5, 1 ); 
        h := 12* IdentityMat( 5, 1 );
        gens := [g,h];
        return Group( gens );
     fi;
     if n = -5 then 
        g := IdentityMat( 3,1 );
        g[3][3] := 34;
        h := IdentityMat( 3,1 );
        h[1][1] := 23;
        gens := [g,h];
        return Group( gens );
     fi;
     if n = -6 then
        g := IdentityMat(4,1 );
        gens := [g];
        return Group( gens );
     fi;
     if n = -7 then
        g := [[2]];
        h := [[3]];
        gens := [g,h];
        return Group( gens );
     fi;
     if n = -8 then
        g := [[1]];
        gens := [g];
        return Group( gens );
     fi;
 
     ##################################################################
     # some abelian irrdeucible examples
     if n = - 9 then
        gens := [ [ [ -21/5, 0, 56, -168 ], [ 0, -21/5, -44, 188 ], 
                  [ -4, 0, 79/5, -104 ],
                  [ 0, -4, 12, -101/5 ] ],
                  [ [ -1/2, 0, 434/5, -1302/5 ], [ 0, -1/2, -341/5, 1457/5 ],
                  [ -31/5, 0, 61/2, -806/5 ], [ 0, -31/5, 93/5, -253/10 ] ],
                  [ [ -5/6, 0, 14/5, -77/5 ], [ 1/2, -5/6, -11/5, 149/10 ],
                  [ -1/5, 1/2, 1/6, -77/10 ], [ 0, -1/5, 11/10, -47/15 ] ] ];
        return Group( gens );
     fi;
     if n = - 10 then 
        gens := [ [ [ -37/20, 0, 0, -70/3 ], [ 5/3, -37/20, 0, 55/3 ],
                [ 0, 5/3, -37/20, -25/3 ], [ 0, 0, 5/3, -137/20 ] ],
                [ [ 3/4, 0, 0, -56 ], [ 4, 3/4, 0, 44 ], [ 0, 4, 3/4, -20 ],
                 [ 0, 0, 4, -45/4 ] ],
               [ [ 7/2, 0, 28, -84 ], [ 0, 7/2, -22, 94 ],
                 [ -2, 0, 27/2, -52 ],
                     [ 0, -2, 6, -9/2 ] ] ];
        return Group( gens );
     fi;
     if n = -11 then 
        gens := [ [ [ -1, 185/12 ], [ -185/12, 2393/12 ] ], 
                [ [ -1/2, -24 ], [ 24, -625/2 ] ]
                 , [ [ 1/3, -1/2 ], [ 1/2, -37/6 ] ] ];
        return( Group(gens ) );
     fi;
     if n = -12 then
        gens := [ [ [ 0, 0, 0, 0, 0, 119/6 ], 
                 [ -17/12, 0, 0, 0, 0, -187/12 ],
                 [ 0, -17/12, 0, 0, 0, 0 ], [ 0, 0, -17/12, 0, 0, -17 ],
                 [ 0, 0, 0, -17/12, 0, 0 ], [ 0, 0, 0, 0, -17/12, 85/12 ] ],
                 [ [ 0, 0, 0, 0, 196/15, -238/3 ], 
                 [ 1, 0, 0, 0, -154/15, 377/5 ],
                 [ -14/15, 1, 0, 0, 0, -154/15 ], 
                 [ 0, -14/15, 1, 0, -56/5, 68 ],
                 [ 0, 0, -14/15, 1, 0, -56/5 ], 
                 [ 0, 0, 0, -14/15, 17/3, -85/3 ] ],
                 [ [ 2, 0, 0, 0, -84/5, 98 ], [ -1, 2, 0, 0, 66/5, -469/5 ],
                 [ 6/5, -1, 2, 0, 0, 66/5 ], [ 0, 6/5, -1, 2, 72/5, -84 ],
                 [ 0, 0, 6/5, -1, 2, 72/5 ], [ 0, 0, 0, 6/5, -7, 37 ] ] ];
         return Group( gens );
     fi;
     
     ##################################################################
     # some triangularizable examples
     if n = -13 then
           gens := [ [ [ 9/10, 39/10, 0, 0 ], [ -39/10, 258/5, 0, 0 ], 
                   [ 0, 0, 4, -39 ],
                    [ 0, 0, 39, -503 ] ],
                    [ [ 9/10, 39/10, 0, 0 ], [ -39/10, 258/5, 0, 0 ], 
                   [ 0, 0, 4, -39 ],
                    [ 0, 0, 39, -503 ] ] ];
            return Group( gens );
     fi;
     if n = -14 then
          gens := [ [ [ 7, 6, 0, 0 ], [ -6, 85, 0, 0 ], 
                    [ 0, 0, 0, 5 ], [ 0, 0, -5, 65 ] ],
                   [ [ -7, 78, 0, 0 ], [ -78, 1007, 0, 0 ], [ 0, 0, -6, 81 ],
                   [ 0, 0, -81, 1047 ] ] ];
          return Group( gens );
     fi;
     if n = -15 then
           gens := [ [ [ -9, 36, 0, 0, 0 ], [ -12, 63, 0, 0, 0 ], 
                     [ 0, 0, -1, 6, 0 ],
                     [ 0, 0, 0, 5, 6 ], [ 0, 0, -3, 0, 5 ] ],
                     [ [ -6, 24, 0, 0, 0 ], [ -8, 42, 0, 0, 0 ], 
                      [ 0, 0, -1, 6, 0 ],
                     [ 0, 0, 0, 5, 6 ], [ 0, 0, -3, 0, 5 ] ] ];
        return Group( gens );
     fi;
     # takes some more time, example form referee
     if n = -16 then
          gens := [ [ [ 1, -3, 8, -2, 0, 2 ], [ 5, -14, 37, -3, -2, -2 ],
                     [ -3, 8, -22, 0, -5, 2 ], [ 0, 0, 0, 0, 1, -1 ],
                      [ 0, 0, 0, 0, 5, -4 ],
                    [ 0, 0, 0, 1, -1, 6 ] ],
                       [ [ 1, 0, 0, -1, 1, -2 ], 
                   [ 0, 1, 0, -3, 0, 5 ], [ 0, 0, 1, -1, 2, 1 ],
                    [ 0, 0, 0, 2, -1, -1 ], [ 0, 0, 0, -2, -3, -6 ],
                       [ 0, 0, 0, -1, -1, -2 ] ] ];
          return Group( gens );
     fi;
     
     # finite examples
     if n = -17 then
        return ImfMatrixGroup( 4,1,1 );
     fi;
     if n = -18 then
        return ImfMatrixGroup(6,2,1);
     fi;       



     ################################################################
     #difficult examples ???
       if n = -100 then
           gens := [ [ [ -100, 51, 70, -231,  1, 0, 0, 1 ], 
                       [ -169, 82, 112, -385, 0, 0, 0, 0 ],
                       [ -59, 27, 37, -132,   0, 0, 0, 0 ], 
                       [ -80, 38, 52, -181,   0, 1, 0, 0 ],
                       [ 0, 0, 0, 0, -19, 96, 70, -231 ],
                       [ 0, 0, 0, 0, -34, 163, 112, -385 ],
                       [ 0, 0, 0, 0, 31, -153, -107, 363 ], 
                       [ 0, 0, 0, 0, 10, -52, -38, 125 ]
                       ],
                     [ [ -1, 0, -1, 0,  0, 0, 0, 0 ], 
                       [ -2, 3, 5, -11, 0, 0, 1, 0 ], 
                       [ -1, 0, 0, 0,   0, 0, 1, 0 ], 
                       [ -1, 1, 2, -4,  1, 0, 1, 0 ],
                       [ 0, 0, 0, 0, -19, 96, 70, -231 ], 
                       [ 0, 0, 0, 0, -34, 163, 112, -385 ],
                       [ 0, 0, 0, 0, 31, -153, -107, 363 ], 
                       [ 0, 0, 0, 0, 10, -52, -38, 125 ]
                      ] ];
            return Group( gens );
        fi;
       if n = -101 then 
           gens:= [[[1,-3,8,-2,0,2],
                [5,-14,37,-3,-2,-2],
                [-3,8,-22,0,-5,2],
                 [0,0,0,0,1,-1],
                  [0,0,0,0,5,-4],
                   [0,0,0,1,-1,6]],
               [[1,0,0,-1,1,-2],
                [0,1,0,-3,0,5],
                  [0,0,1,-1,2,1],
                 [0,0,0,2,-1,-1],
                     [0,0,0,-2,-3,-6],
                   [0,0,0,-1,-1,-2]]];
            return Group( gens );
       fi;
       if n = -102 then
           gens :=[[[-984,113,11,19,0,-2,-2,5,1,1,-1],
                    [1160,146,223,201,0,1,0,-2,-3,2,3],
                    [124,30,36,33,2,0,2,-2,1,-5,0],
                    [113,11,19,17,3,0,4,-1,1,1,-1],
                    [0,0,0,0, 619,1178,2242,        2,-2,-1,-2],
                    [0,0,0,0, 3420, 6509,12388,     2,-2,-2,-4],
                    [0,0,0,0, 1178, 2242, 4267,     2,0,1,-3],
                    [0,0,0,0, 0,0,0,         5274, 4861, 4561, 4272],
                    [0,0,0,0, 0,0,0,         57443, 53884,50471,47281],
                    [0,0,0,0, 0,0,0,         9422,8833,8274,7751],
                    [0,0,0,0, 0,0,0,         4861,4561,4272,4002]],
                   [[4272,4002,3749,3512,    -1,-2,2,-1,1,1,2],
                    [47281,44292,41492,38869, 4,-1,-1,3,-2,3,1],
                    [7751,7261,6802,6372,      2,-2,5,4,-1,-1,-3],
                    [4002,3749,3512,3290,      -1,1,0,-2,0,1,-3],
                    [0,0,0,0,                   0,0,1,   -1,-1,-2,2],
                    [0,0,0,0,                   1,0,5,   3,-1,2,2],
                    [0,0,0,0,                   0,1,-1,  -1,2,-1,0],
                    [0,0,0,0,                 0,0,0,   4272,4002,3749,3512 ],
                    [0,0,0,0,                 0,0,0,  47281,44292,41492,38869],
                    [0,0,0,0,                 0,0,0,   7751,7261,6802,6372],
                    [0,0,0,0,                 0,0,0,  4002,3749,3512,3290]]
                  ];
             return Group( gens );
        fi;
       if n = -103 then 
          gens := [ [ [ -12, -3, -18, 22, 0, 1/2, 0, 0, 0, 0, 0, 0 ],
                [ -1, 16, 46, -88, 1/2, 0, 1/2, 0, 0, 0, 0, 0 ],
                [ -2, -10, -23, 33, 0, 0, 0, 0, 0, 0, 0, 0 ],
                   [ 0, 4, 14, -29, 0, 0, 0, 1/2, 1/2, 1/2, 0, 0 ],
                   [ 0, 0, 0, 0, -1, -1, -1, 0, 0, 1/2, 0, 0 ],
                   [ 0, 0, 0, 0, -5, 3, 5, -11, 1/2, 0, 0, 0 ],
                   [ 0, 0, 0, 0, -3, 4, 5, -11, 0, 0, 1/2, 0 ],
                   [ 0, 0, 0, 0, -3, 3, 4, -9, 0, 0, 0, 0 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, -15, 48, 36 -121 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, -26, 83, 62, -209 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, 11, -71, -49, 165 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, 0, -22, -14, 47 ] ],
               [ [ -12, -3, -18, 22, 0, 0, 0, 0, 0, 0, 0, 0 ],
                   [ -1, 16, 46, -88, 0, 0, 0, 0, 1/2, 0, 0, 0 ],
                   [ -2, -10, -23, 33, 0, 0, 0, 0, 0, 0, 0, 0 ],
                   [ 0, 4, 14, -29, 1/2, 1/2, 0, 1/2, 0, 0, 0, 1/2 ],
                   [ 0, 0, 0, 0, -3, 4, 6, -11, 0, 0, 0, 0 ],
                   [ 0, 0, 0, 0, 2, -5, -8, 11, 0, 1/2, 0, 1/2 ],
                   [ 0, 0, 0, 0, 3, -5, -7, 11, 0, 0, 0, 0 ],
                   [ 0, 0, 0, 0, 2, -4, -6, 9, 0, 0, 1/2, 0 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, -15, 48, 36, -121 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, -26, 83, 62, -209 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, 11, -71, -49, 165 ],
                   [ 0, 0, 0, 0, 0, 0, 0, 0, 0, -22, -14, 47 ] ] ];
            return Group( gens );
       fi;

    return fail;

  end;

#############################################################################
#
# examples groups used for the paper "testing polycyclicity"
#
SolvableMatGroupExams := function( n )
    local gens,mat1,mat2;
    if n=1 then 
        return PolExamples( 3 );
    fi;
    if n=2 then 
        return PolExamples( 4 );
    fi;
    if n=3 then 
        return PolExamples( 13 );
    fi;
    if n=4 then 
        return PolExamples( 16 );
    fi;


    if n=5 then 
        return PolExamples( 24 );
    fi;

    if n=6 then 
        return PolExamples( 27 );
    fi;
    if n=7 then
        return POL_PolExamples2( 1201 );
    fi;
    if n = 8 then 
        return POL_PolExamples2( 1209 );
    fi;
    if n = 9 then 
        return POL_PolExamples2( 1210 );
    fi;
    if n = 10 then 
         # examples used during the talk in oxford and st andrews
         mat1 := [ [ 5/6, -2, 1, 4 ], [ 2/3, -19/6, -1, 4 ], 
                 [ 0, 0, 5/6, -2 ],  [ 0, 0, 2/3, -19/6 ] ];
         mat2 := [ [ -1/2, -12/5, 3, -1 ], [ 4/5, -53/10, -2, -4 ], 
                 [ 0, 0, -1/2, -12/5 ], [ 0, 0, 4/5, -53/10 ] ];
         return Group( mat1, mat2 );
    fi;
    
    return 0;
end;

   
# ideas for the construction of further examples
# - semidirect product
# - wreath product for example with S_4
# - extensions
# - use library for finite integral matrix groups
# - subdirect product
# - use galois group of the arrising number fields
# - direct product with finite group
# - subdirect products S_4 \times G 
#     S_4 \times G
#      |      | 
#      |alpha | beta
#      V      V
#        S_3 or C_2
# 
#   H = { (\sigma,g) : \sigma \alpha = g \beta}
#   K < G \times H
