/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.modelset.Atom;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;

public class JmolMolecule {
    public Node[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int ac;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BS atomList;

    public static final JmolMolecule[] getMolecules(Node[] atoms, BS[] bsModelAtoms, Lst<BS> biobranches, BS bsExclude) {
        BS bsToTest = null;
        BS bsBranch = new BS();
        int thisModelIndex = -1;
        int indexInModel = 0;
        int moleculeCount = 0;
        JmolMolecule[] molecules = new JmolMolecule[4];
        if (bsExclude == null) {
            bsExclude = new BS();
        }
        for (int i = 0; i < atoms.length; ++i) {
            if (bsExclude.get(i) || bsBranch.get(i)) continue;
            if (atoms[i].isDeleted()) {
                bsExclude.set(i);
                continue;
            }
            int modelIndex = atoms[i].getModelIndex();
            if (modelIndex != thisModelIndex) {
                thisModelIndex = modelIndex;
                indexInModel = 0;
                bsToTest = bsModelAtoms[modelIndex];
            }
            if ((bsBranch = JmolMolecule.getBranchBitSet(atoms, i, bsToTest, biobranches, -1, true, true)).nextSetBit(0) < 0) continue;
            molecules = JmolMolecule.addMolecule(molecules, moleculeCount++, atoms, i, bsBranch, modelIndex, indexInModel++, bsExclude);
        }
        return JmolMolecule.allocateArray(molecules, moleculeCount);
    }

    public static BS getBranchBitSet(Node[] atoms, int atomIndex, BS bsToTest, Lst<BS> biobranches, int atomIndexNot, boolean allowCyclic, boolean allowBioResidue) {
        BS bs = BS.newN(atoms.length);
        if (atomIndex < 0) {
            return bs;
        }
        if (atomIndexNot >= 0) {
            bsToTest.clear(atomIndexNot);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(atoms, atoms[atomIndex], bsToTest, allowCyclic, allowBioResidue, biobranches, bs) ? bs : new BS();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] molecules, int iMolecule, Node[] atoms, int iAtom, BS bsBranch, int modelIndex, int indexInModel, BS bsExclude) {
        bsExclude.or(bsBranch);
        if (iMolecule == molecules.length) {
            molecules = JmolMolecule.allocateArray(molecules, iMolecule * 2 + 1);
        }
        molecules[iMolecule] = JmolMolecule.initialize(atoms, iMolecule, iAtom, bsBranch, modelIndex, indexInModel);
        return molecules;
    }

    public static String getMolecularFormulaAtoms(Node[] atoms, BS bsSelected, float[] wts, boolean isEmpirical) {
        JmolMolecule m = new JmolMolecule();
        m.nodes = atoms;
        m.atomList = bsSelected;
        return m.getMolecularFormula(false, wts, isEmpirical);
    }

    public String getMolecularFormula(boolean includeMissingHydrogens, float[] wts, boolean isEmpirical) {
        int i;
        if (this.mf != null) {
            return this.mf;
        }
        if (this.atomList == null) {
            this.atomList = new BS();
            this.atomList.setBits(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        this.ac = this.atomList.cardinality();
        this.nElements = 0;
        int p = 0;
        int i2 = this.atomList.nextSetBit(0);
        while (i2 >= 0) {
            Node node = this.nodes[i2];
            if (node != null) {
                int f;
                int n = node.getAtomicAndIsotopeNumber();
                int n2 = f = wts == null ? 1 : (int)(8.0f * wts[p]);
                if (n < Elements.elementNumberMax) {
                    int nH;
                    if (this.elementCounts[n] == 0) {
                        ++this.nElements;
                    }
                    int n3 = n;
                    this.elementCounts[n3] = this.elementCounts[n3] + f;
                    this.elementNumberMax = Math.max(this.elementNumberMax, n);
                    if (includeMissingHydrogens && (nH = node.getImplicitHydrogenCount()) > 0) {
                        if (this.elementCounts[1] == 0) {
                            ++this.nElements;
                        }
                        this.elementCounts[1] = this.elementCounts[1] + nH * f;
                    }
                } else {
                    if (this.altElementCounts[n = Elements.altElementIndexFromNumber(n)] == 0) {
                        ++this.nElements;
                    }
                    int n4 = n;
                    this.altElementCounts[n4] = this.altElementCounts[n4] + f;
                    this.altElementMax = Math.max(this.altElementMax, n);
                }
            }
            i2 = this.atomList.nextSetBit(i2 + 1);
            ++p;
        }
        if (wts != null) {
            for (int i3 = 1; i3 <= this.elementNumberMax; ++i3) {
                int c = this.elementCounts[i3] / 8;
                if (c * 8 != this.elementCounts[i3]) {
                    return "?";
                }
                this.elementCounts[i3] = c;
            }
        }
        if (isEmpirical) {
            int min = 2;
            boolean ok = true;
            block2: while (ok) {
                min = 100000;
                for (i = 1; i <= this.elementNumberMax; ++i) {
                    int c = this.elementCounts[i];
                    if (c <= 0 || c >= min) continue;
                    min = c;
                }
                if (min == 1) break;
                for (int j = min; j > 1; --j) {
                    int i4;
                    ok = true;
                    for (i4 = 1; i4 <= this.elementNumberMax && ok; ++i4) {
                        int c = this.elementCounts[i4];
                        if (c / j * j == c) continue;
                        ok = false;
                    }
                    if (!ok) continue;
                    i4 = 1;
                    while (i4 <= this.elementNumberMax) {
                        int n = i4++;
                        this.elementCounts[n] = this.elementCounts[n] / j;
                    }
                    continue block2;
                }
            }
        }
        String mf = "";
        String sep = "";
        for (i = 1; i <= this.elementNumberMax; ++i) {
            int nX = this.elementCounts[i];
            if (nX == 0) continue;
            mf = mf + sep + Elements.elementSymbolFromNumber(i) + " " + nX;
            sep = " ";
        }
        for (i = 1; i <= this.altElementMax; ++i) {
            int nX = this.altElementCounts[i];
            if (nX == 0) continue;
            mf = mf + sep + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(i)) + " " + nX;
            sep = " ";
        }
        return mf;
    }

    private static JmolMolecule initialize(Node[] nodes, int moleculeIndex, int firstAtomIndex, BS atomList, int modelIndex, int indexInModel) {
        JmolMolecule jm = new JmolMolecule();
        jm.nodes = nodes;
        jm.firstAtomIndex = firstAtomIndex;
        jm.atomList = atomList;
        jm.ac = atomList.cardinality();
        jm.moleculeIndex = moleculeIndex;
        jm.modelIndex = modelIndex;
        jm.indexInModel = indexInModel;
        return jm;
    }

    private static boolean getCovalentlyConnectedBitSet(Node[] atoms, Node atom, BS bsToTest, boolean allowCyclic, boolean allowBioResidue, Lst<BS> biobranches, BS bsResult) {
        int atomIndex = atom.getIndex();
        if (!bsToTest.get(atomIndex)) {
            return allowCyclic;
        }
        if (!allowBioResidue && atom.getBioStructureTypeName().length() > 0) {
            return allowCyclic;
        }
        bsToTest.clear(atomIndex);
        if (biobranches != null && !bsResult.get(atomIndex)) {
            int i = biobranches.size();
            while (--i >= 0) {
                BS b = (BS)biobranches.get(i);
                if (!b.get(atomIndex)) continue;
                bsResult.or(b);
                bsToTest.andNot(b);
                int j = b.nextSetBit(0);
                while (j >= 0) {
                    Node atom1 = atoms[j];
                    bsToTest.set(j);
                    JmolMolecule.getCovalentlyConnectedBitSet(atoms, atom1, bsToTest, allowCyclic, allowBioResidue, biobranches, bsResult);
                    bsToTest.clear(j);
                    j = b.nextSetBit(j + 1);
                }
                break block0;
            }
        }
        bsResult.set(atomIndex);
        Edge[] bonds = atom.getEdges();
        if (bonds == null) {
            return true;
        }
        int i = bonds.length;
        while (--i >= 0) {
            Edge bond = bonds[i];
            if (bond == null || !bond.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(atoms, (Node)bond.getOtherNode(atom), bsToTest, allowCyclic, allowBioResidue, biobranches, bsResult)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] molecules, int len) {
        return len == molecules.length ? molecules : (JmolMolecule[])AU.arrayCopyObject(molecules, len);
    }

    public static BS getBitSetForMF(Atom[] at, BS bsAtoms, String mf) {
        Hashtable<String, int[]> map = new Hashtable<String, int[]>();
        mf = PT.rep(PT.clean(mf + "Z"), " ", "");
        int pt = 0;
        int pt0 = 0;
        int n = mf.length();
        for (int i = 0; i < n; ++i) {
            char ch = mf.charAt(i);
            boolean isDigit = Character.isDigit(ch);
            if (!isDigit && (i <= 0 || !Character.isUpperCase(ch))) continue;
            pt0 = i;
            String s = mf.substring(pt, pt0).trim();
            if (isDigit) {
                while (i < n && Character.isDigit(mf.charAt(i))) {
                    ++i;
                }
            }
            pt = i;
            map.put(s, new int[]{isDigit ? PT.parseInt(mf.substring(pt0, pt)) : 1});
        }
        BS bs = new BS();
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            String a = at[i].getElementSymbol();
            int[] c = (int[])map.get(a);
            if (c != null) {
                int n2 = c[0];
                c[0] = n2 - 1;
                if (n2 >= 1) {
                    bs.set(i);
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        for (int[] e : map.values()) {
            if (e[0] <= 0) continue;
            return new BS();
        }
        return bs;
    }
}

