/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    protected String getUserAgent() {
        String userAgent = System.getProperty("http.agent");
        if (userAgent == null) {
            userAgent = "Apache Ivy/" + Ivy.getIvyVersion();
        }
        return userAgent;
    }

    @Override
    public void setRequestMethod(int requestMethod) {
        AbstractURLHandler.requestMethod = requestMethod;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    protected String normalizeToString(URL url) throws IOException {
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            return url.toExternalForm();
        }
        try {
            URI uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), url.getRef());
            String uriString = uri.normalize().toASCIIString();
            uriString = uriString.replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(uriString).replaceAll("%$1");
        }
        catch (URISyntaxException e) {
            MalformedURLException ioe = new MalformedURLException("Couldn't convert '" + url.toString() + "' to a valid URI");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected URL normalizeToURL(URL url) throws IOException {
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            return url;
        }
        return new URL(this.normalizeToString(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getDecodingInputStream(String encoding, InputStream in) throws IOException {
        InputStream result = null;
        if ("gzip".equals(encoding) || "x-gzip".equals(encoding)) {
            result = new GZIPInputStream(in);
        } else if ("deflate".equals(encoding)) {
            BufferedInputStream bStream = new BufferedInputStream(in);
            bStream.mark(100);
            byte[] bytes = new byte[100];
            int nbBytes = bStream.read(bytes);
            bStream.reset();
            Inflater inflater = new Inflater();
            inflater.setInput(bytes, 0, nbBytes);
            try {
                inflater.inflate(new byte[1000]);
                result = new InflaterInputStream(bStream);
            }
            catch (DataFormatException e) {
                result = new InflaterInputStream(bStream, new Inflater(true));
            }
            finally {
                inflater.end();
            }
        } else {
            result = in;
        }
        return result;
    }
}

