/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;

public class ExecutionEnvironmentProfileProvider {
    private static final String DEFAULT_PROFILES_FILE = "jvm-packages.properties";
    private static final String PACKAGE_PREFIX = "org/apache/ivy/osgi/core/";
    private Map profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();
    private static final ExecutionEnvironmentProfileProvider INSTANCE;

    public static ExecutionEnvironmentProfileProvider getInstance() {
        return INSTANCE;
    }

    public ExecutionEnvironmentProfile getProfile(String string) {
        return (ExecutionEnvironmentProfile)this.profileList.get(string);
    }

    public static Map loadDefaultProfileList() throws IOException {
        ClassLoader classLoader = ExecutionEnvironmentProfileProvider.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties");
        if (inputStream == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string;
            String string2 = (String)entry.getKey();
            if (!string2.endsWith(".pkglist") || hashMap.containsKey(string = string2.substring(0, string2.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(properties, hashMap, string);
        }
        return hashMap;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties properties, Map map, String string) {
        String[] stringArray;
        Object object;
        ExecutionEnvironmentProfile executionEnvironmentProfile = new ExecutionEnvironmentProfile(string);
        String string2 = properties.getProperty(string + ".extends");
        if (string2 != null) {
            object = (ExecutionEnvironmentProfile)map.get(string2);
            if (object == null) {
                object = ExecutionEnvironmentProfileProvider.loadProfile(properties, map, string2);
            }
            stringArray = ((ExecutionEnvironmentProfile)object).getPkgNames().iterator();
            while (stringArray.hasNext()) {
                executionEnvironmentProfile.addPkgName((String)stringArray.next());
            }
        }
        object = properties.getProperty(string + ".pkglist");
        stringArray = ((String)object).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.length() == 0) continue;
            executionEnvironmentProfile.addPkgName(string3);
        }
        map.put(string, executionEnvironmentProfile);
        Message.verbose("Execution environment profile " + executionEnvironmentProfile.getName() + " loaded");
        return executionEnvironmentProfile;
    }

    static {
        try {
            INSTANCE = new ExecutionEnvironmentProfileProvider();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

