/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.RequireExplicitBindingsOption;
import com.google.inject.spi.StaticInjectionRequest;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.Guice4;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.wire.DependencyAnalyzer;
import org.eclipse.sisu.wire.MergedProperties;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.StringProperties;
import org.eclipse.sisu.wire.TypeConverterCache;
import org.eclipse.sisu.wire.WireModule;
import org.eclipse.sisu.wire.Wiring;

final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private static final Map<Key<?>, Key<?>> LEGACY_KEY_ALIASES;
    private static final List<Element> JIT_BINDINGS;
    private final Set<Key<?>> localKeys = new HashSet();
    private final DependencyAnalyzer analyzer = new DependencyAnalyzer();
    private final List<ElementAnalyzer> privateAnalyzers = new ArrayList<ElementAnalyzer>();
    private final List<Map<?, ?>> properties = new ArrayList();
    private final List<String> arguments = new ArrayList<String>();
    private final Binder binder;
    private boolean requireExplicitBindings;

    static {
        HashMap aliases = new HashMap();
        try {
            ElementAnalyzer.addLegacyKeyAlias(aliases, BeanLocator.class);
            ElementAnalyzer.addLegacyKeyAlias(aliases, MutableBeanLocator.class);
            ElementAnalyzer.addLegacyKeyAlias(aliases, RankingFunction.class);
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        LEGACY_KEY_ALIASES = aliases.isEmpty() ? null : aliases;
        JIT_BINDINGS = Elements.getElements(new Module(){

            @Override
            public void configure(Binder binder) {
                binder.bind(BeanLocator.class).to(MutableBeanLocator.class);
                binder.bind(MutableBeanLocator.class).to(DefaultBeanLocator.class);
                binder.bind(RankingFunction.class).to(DefaultRankingFunction.class);
                binder.bind(TypeConverterCache.class);
            }
        });
    }

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
    }

    public void ignoreKeys(Set<Key<?>> keys2) {
        this.localKeys.addAll(keys2);
    }

    public void apply(WireModule.Strategy strategy) {
        if (this.requireExplicitBindings) {
            this.makeJitBindingsExplicit();
        }
        Set<Key<?>> missingKeys = this.analyzer.findMissingKeys(this.localKeys);
        MergedProperties mergedProperties = new MergedProperties(this.properties);
        Wiring wiring = strategy.wiring(this.binder);
        for (Key<?> key2 : missingKeys) {
            if (ElementAnalyzer.isParameters(key2)) {
                this.wireParameters(key2, mergedProperties);
                continue;
            }
            if (ElementAnalyzer.isRestricted(key2)) continue;
            wiring.wire(key2);
        }
        for (ElementAnalyzer privateAnalyzer : this.privateAnalyzers) {
            privateAnalyzer.ignoreKeys(this.localKeys);
            privateAnalyzer.ignoreKeys(missingKeys);
            privateAnalyzer.apply(strategy);
        }
    }

    @Override
    public <T> Void visit(Binding<T> binding2) {
        Key<T> key2 = binding2.getKey();
        if (!this.localKeys.contains(key2)) {
            if (ElementAnalyzer.isParameters(key2)) {
                this.mergeParameters(binding2);
            } else if (Boolean.TRUE.equals(binding2.acceptTargetVisitor(this.analyzer))) {
                Key<?> alias2;
                this.localKeys.add(key2);
                binding2.applyTo(this.binder);
                if (LEGACY_KEY_ALIASES != null && (alias2 = LEGACY_KEY_ALIASES.get(key2)) != null && this.localKeys.add(alias2)) {
                    this.binder.bind(alias2).to(key2);
                }
            } else {
                Logs.trace("Discard binding: {}", binding2, null);
            }
        }
        return null;
    }

    @Override
    public Void visit(PrivateElements elements) {
        PrivateBinder privateBinder = this.binder.withSource(elements.getSource()).newPrivateBinder();
        ElementAnalyzer privateAnalyzer = new ElementAnalyzer(privateBinder);
        this.privateAnalyzers.add(privateAnalyzer);
        privateAnalyzer.ignoreKeys(this.localKeys);
        for (Element element : elements.getElements()) {
            element.acceptVisitor(privateAnalyzer);
        }
        for (Key key2 : elements.getExposedKeys()) {
            if (!privateAnalyzer.localKeys.contains(key2) || !this.localKeys.add(key2)) continue;
            privateBinder.withSource(elements.getExposedSource(key2)).expose(key2);
        }
        return null;
    }

    @Override
    public <T> Void visit(ProviderLookup<T> lookup) {
        this.analyzer.visit(lookup);
        lookup.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(StaticInjectionRequest request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(InjectionRequest<?> request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(RequireExplicitBindingsOption option) {
        this.requireExplicitBindings = true;
        option.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }

    private void makeJitBindingsExplicit() {
        for (Element element : JIT_BINDINGS) {
            if (!(element instanceof Binding) || !this.localKeys.add(((Binding)element).getKey())) continue;
            element.applyTo(this.binder);
        }
    }

    private void mergeParameters(Binding<?> binding2) {
        Object parameters = null;
        if (binding2 instanceof InstanceBinding) {
            parameters = ((InstanceBinding)binding2).getInstance();
        } else if (binding2 instanceof ProviderInstanceBinding) {
            parameters = Guice4.getProviderInstance((ProviderInstanceBinding)binding2).get();
        }
        if (parameters instanceof Map) {
            this.properties.add(parameters);
        } else if (parameters instanceof String[]) {
            Collections.addAll(this.arguments, parameters);
        } else {
            Logs.warn("Ignoring incompatible @Parameters binding: {}", binding2, null);
        }
    }

    private void wireParameters(Key key2, Map mergedProperties) {
        if (ParameterKeys.PROPERTIES.equals(key2)) {
            this.binder.bind(key2).toInstance(mergedProperties);
        } else {
            TypeLiteral type2 = key2.getTypeLiteral();
            Class clazz = type2.getRawType();
            if (Map.class == clazz) {
                TypeLiteral<?>[] constraints = TypeArguments.get(type2);
                if (constraints.length == 2 && String.class == constraints[1].getRawType()) {
                    this.binder.bind(key2).to(StringProperties.class);
                } else {
                    this.binder.bind(key2).to(ParameterKeys.PROPERTIES);
                }
            } else if (String[].class == clazz) {
                this.binder.bind(key2).toInstance(this.arguments.toArray(new String[this.arguments.size()]));
            }
        }
    }

    private static boolean isParameters(Key<?> key2) {
        Class<Annotation> qualifierType = key2.getAnnotationType();
        return Parameters.class == qualifierType || org.sonatype.inject.Parameters.class == qualifierType;
    }

    private static boolean isRestricted(Key<?> key2) {
        String name2 = key2.getTypeLiteral().getRawType().getName();
        if (name2.startsWith("org.eclipse.sisu.inject") || name2.startsWith("org.sonatype.guice.bean.locators")) {
            return name2.endsWith("BeanLocator") || name2.endsWith("RankingFunction");
        }
        return "org.slf4j.Logger".equals(name2);
    }

    private static void addLegacyKeyAlias(Map<Key<?>, Key<?>> aliases, Class<?> clazz) throws ClassNotFoundException {
        String legacyName = "org.sonatype.guice.bean.locators." + clazz.getSimpleName();
        Class<?> legacyType = ElementAnalyzer.class.getClassLoader().loadClass(legacyName);
        if (clazz.isAssignableFrom(legacyType)) {
            aliases.put(Key.get(legacyType), Key.get(clazz));
        }
    }
}

