/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.painless.GenericElasticsearchScript;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

final class ScriptImpl
extends SearchScript {
    private final GenericElasticsearchScript script;
    private final Map<String, Object> variables;
    private final DoubleSupplier scoreLookup;
    private final Function<Map<String, Object>, Map<?, ?>> ctxLookup;
    private Object aggregationValue;

    ScriptImpl(GenericElasticsearchScript script, Map<String, Object> vars, SearchLookup lookup, LeafReaderContext leafContext) {
        super(null, lookup, leafContext);
        LeafSearchLookup leafLookup;
        this.script = script;
        this.variables = new HashMap<String, Object>();
        if (vars != null) {
            this.variables.putAll(vars);
        }
        if ((leafLookup = this.getLeafLookup()) != null) {
            this.variables.putAll(leafLookup.asMap());
        }
        this.scoreLookup = script.needs_score() ? () -> ((ScriptImpl)this).getScore() : () -> 0.0;
        this.ctxLookup = script.needsCtx() ? variables -> (Map)variables.get("ctx") : variables -> null;
    }

    public Map<String, Object> getParams() {
        return this.variables;
    }

    public void setNextVar(String name, Object value) {
        this.variables.put(name, value);
    }

    public void setNextAggregationValue(Object value) {
        this.aggregationValue = value;
    }

    public Object run() {
        return this.script.execute(this.variables, this.scoreLookup.getAsDouble(), (Map<String, ScriptDocValues<?>>)this.getDoc(), this.aggregationValue, this.ctxLookup.apply(this.variables));
    }

    public double runAsDouble() {
        return ((Number)this.run()).doubleValue();
    }

    public long runAsLong() {
        return ((Number)this.run()).longValue();
    }
}

