/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.internal.DefaultTargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

@Incubating
public class CppApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        final ObjectFactory objectFactory = project.getObjects();
        final DefaultCppApplication application = this.componentFactory.newInstance(CppApplication.class, DefaultCppApplication.class, "main");
        project.getExtensions().add(CppApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getBaseName().set((Object)project.getName());
        application.getTargetMachines().convention(Dimensions.getDefaultTargetMachines(this.targetMachineFactory));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                application.getTargetMachines().finalizeValue();
                Set targetMachines = (Set)application.getTargetMachines().get();
                if (targetMachines.isEmpty()) {
                    throw new IllegalArgumentException("A target machine needs to be specified for the application.");
                }
                Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                for (BuildType buildType : BuildType.DEFAULT_BUILD_TYPES) {
                    for (TargetMachine targetMachine : targetMachines) {
                        String operatingSystemSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getOperatingSystemFamily(), (Collection)targetMachines.stream().map(TargetMachine::getOperatingSystemFamily).collect(Collectors.toSet()));
                        String architectureSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getArchitecture(), (Collection)targetMachines.stream().map(TargetMachine::getArchitecture).collect(Collectors.toSet()));
                        String variantName = buildType.getName() + operatingSystemSuffix + architectureSuffix;
                        Provider group = project.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getGroup().toString();
                            }
                        });
                        Provider version = project.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getVersion().toString();
                            }
                        });
                        AttributeContainerInternal runtimeAttributes = CppApplicationPlugin.this.attributesFactory.mutable();
                        runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                        runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                        runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                        runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)targetMachine.getOperatingSystemFamily());
                        runtimeAttributes.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)targetMachine.getArchitecture());
                        NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider<String>)application.getBaseName(), (Provider<String>)group, (Provider<String>)version, buildType.isDebuggable(), buildType.isOptimized(), targetMachine, null, new DefaultUsageContext(variantName + "Runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                        if (DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(targetMachine.getOperatingSystemFamily().getName())) {
                            ToolChainSelector.Result<CppPlatform> result = CppApplicationPlugin.this.toolChainSelector.select(CppPlatform.class, targetMachine);
                            DefaultCppExecutable executable = application.addExecutable(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                            if (buildType == BuildType.DEBUG && (targetMachine.getArchitecture().equals(((DefaultTargetMachineFactory)CppApplicationPlugin.this.targetMachineFactory).host().getArchitecture()) || !application.getDevelopmentBinary().isPresent())) {
                                application.getDevelopmentBinary().set((Object)executable);
                            }
                            application.getMainPublication().addVariant(executable);
                            continue;
                        }
                        application.getMainPublication().addVariant((SoftwareComponent)variantIdentity);
                    }
                }
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
    }
}

