/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.inline;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.DescriptorSubstitutorForExternalScope;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.Inliner;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.SubstitutedDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/Context;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "globalSubstituteMap", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/SubstitutedDescriptor;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "inline", "Lorg/jetbrains/kotlin/ir/IrElement;", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "visitElement", "element", "backend.js"})
public final class FunctionInlining
extends IrElementTransformerVoidWithContext {
    private final Map<DeclarationDescriptor, SubstitutedDescriptor> globalSubstituteMap;
    @NotNull
    private final JsIrBackendContext context;

    @NotNull
    public final IrElement inline(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull((Object)irModule, (String)"irModule");
        IrElement transformedModule = (IrElement)irModule.accept(this, null);
        new DescriptorSubstitutorForExternalScope(this.globalSubstituteMap).run(transformedModule);
        return transformedModule;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrExpression irExpression = super.visitCall(expression2);
        if (irExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        }
        IrCall irCall = (IrCall)irExpression;
        FunctionDescriptor functionDescriptor = irCall.getDescriptor();
        if (!LegacyDescriptorUtilsKt.getNeedsInlining(functionDescriptor)) {
            return irCall;
        }
        IrFunction functionDeclaration = this.getFunctionDeclaration(irCall);
        if (functionDeclaration == null) {
            String message = "Inliner failed to obtain function declaration: " + DescriptorUtilsKt.getFqNameSafe(functionDescriptor).toString();
            UtilsKt.reportWarning(this.context, message, this.getCurrentFile(), irCall);
            return irCall;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(functionDeclaration, this);
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        Inliner inliner = new Inliner(this.globalSubstituteMap, functionDeclaration, scopeWithIr, this.context);
        return inliner.inline(irCall);
    }

    private final IrFunction getFunctionDeclaration(IrCall irCall) {
        FunctionDescriptor functionDescriptor = irCall.getDescriptor();
        FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)LegacyDescriptorUtilsKt.resolveFakeOverride((CallableMemberDescriptor)functionDescriptor)).getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor.resolveFakeOverride().original");
        FunctionDescriptor originalDescriptor = functionDescriptor2;
        IrFunction functionDeclaration = this.context.getOriginalModuleIndex().getFunctions().get(originalDescriptor);
        return functionDeclaration;
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return (IrElement)element.accept(this, null);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public FunctionInlining(@NotNull JsIrBackendContext context) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        FunctionInlining functionInlining = this;
        functionInlining.globalSubstituteMap = map2 = (Map)new LinkedHashMap();
    }
}

