/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements LazyEntity {
    private final LazyClassContext c;
    private final KtTypeParameter typeParameter;

    public LazyTypeParameterDescriptor(@NotNull LazyClassContext c, @NotNull LazyClassDescriptor containingDeclaration, @NotNull KtTypeParameter typeParameter, int index2) {
        super(c.getStorageManager(), containingDeclaration, typeParameter.getNameAsSafeName(), typeParameter.getVariance(), typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), index2, KotlinSourceElementKt.toSourceElement(typeParameter), c.getSupertypeLoopChecker());
        this.c = c;
        this.typeParameter = typeParameter;
        this.c.getTrace().record(BindingContext.TYPE_PARAMETER, typeParameter, this);
    }

    @Override
    protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
        for (KtTypeReference typeReference : this.getAllUpperBounds()) {
            if (!this.resolveBoundType(typeReference).getConstructor().equals(type2.getConstructor())) continue;
            this.c.getTrace().report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeReference));
            return;
        }
    }

    @Override
    @NotNull
    protected List<KotlinType> resolveUpperBounds() {
        ArrayList<KotlinType> upperBounds = new ArrayList<KotlinType>(1);
        for (KtTypeReference typeReference : this.getAllUpperBounds()) {
            KotlinType resolvedType = this.resolveBoundType(typeReference);
            if (KotlinTypeKt.isError(resolvedType)) continue;
            upperBounds.add(resolvedType);
        }
        if (upperBounds.isEmpty()) {
            upperBounds.add(this.c.getModuleDescriptor().getBuiltIns().getDefaultBound());
        }
        return upperBounds;
    }

    private Collection<KtTypeReference> getAllUpperBounds() {
        return CollectionsKt.plus(this.typeParameter.getExtendsBound() != null ? Collections.singletonList(this.typeParameter.getExtendsBound()) : Collections.emptyList(), this.getUpperBoundsFromWhereClause());
    }

    private Collection<KtTypeReference> getUpperBoundsFromWhereClause() {
        ArrayList<KtTypeReference> result2 = new ArrayList<KtTypeReference>();
        KtClassOrObject classOrObject = KtStubbedPsiUtil.getPsiOrStubParent(this.typeParameter, KtClassOrObject.class, true);
        if (classOrObject instanceof KtClass) {
            for (KtTypeConstraint typeConstraint : classOrObject.getTypeConstraints()) {
                KtSimpleNameExpression constrainedParameterName = typeConstraint.getSubjectTypeParameterName();
                if (constrainedParameterName == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName())) continue;
                this.c.getTrace().record(BindingContext.REFERENCE_TARGET, constrainedParameterName, this);
                KtTypeReference boundTypeReference = typeConstraint.getBoundTypeReference();
                if (boundTypeReference == null) continue;
                result2.add(boundTypeReference);
            }
        }
        return result2;
    }

    @NotNull
    private KotlinType resolveBoundType(@NotNull KtTypeReference boundTypeReference) {
        return this.c.getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.c.getTrace(), false);
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        return (LazyClassDescriptor)super.getContainingDeclaration();
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        this.getOriginal();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getUpperBounds());
        this.getVariance();
    }
}

