/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;

class WatchPointsRegistry {
    private static final Logger LOG = Logging.getLogger(WatchPointsRegistry.class);
    private final CombinedRootSubset rootSubset = new CombinedRootSubset();
    private ImmutableSet<? extends File> allRequestedRoots;
    private final boolean createNewStartingPointsUnderExistingRoots;

    public WatchPointsRegistry(boolean createNewStartingPointsUnderExistingRoots) {
        this.createNewStartingPointsUnderExistingRoots = createNewStartingPointsUnderExistingRoots;
        this.allRequestedRoots = ImmutableSet.of();
    }

    public Delta appendFileSystemSubset(FileSystemSubset fileSystemSubset, Iterable<? extends File> currentWatchPoints) {
        return new Delta(fileSystemSubset, ImmutableSet.copyOf(currentWatchPoints));
    }

    public boolean shouldFire(File file) {
        return this.rootSubset.contains(file);
    }

    public boolean shouldWatch(File directory) {
        boolean result;
        boolean bl = result = this.rootSubset.isInRootsOrAncestorOrAnyRoot(directory) || WatchPointsRegistry.isAncestorOfAnyRoot(directory, this.allRequestedRoots, true);
        if (!result && LOG.isDebugEnabled()) {
            LOG.debug("not watching directory: {} allRequestedRoots: {} roots: {} unfiltered: {}", new Object[]{directory, this.allRequestedRoots, this.rootSubset.roots, this.rootSubset.combinedFileSystemSubset});
        }
        return result;
    }

    private static boolean inCombinedRootsOrAncestorOfAnyRoot(File file, Iterable<? extends File> roots, FileSystemSubset combinedRootsSubset) {
        return combinedRootsSubset.contains(file) || WatchPointsRegistry.isAncestorOfAnyRoot(file, roots, true);
    }

    private static boolean isAncestorOfAnyRoot(File file, Iterable<? extends File> roots) {
        return WatchPointsRegistry.isAncestorOfAnyRoot(file, roots, false);
    }

    private static boolean isAncestorOfAnyRoot(File file, Iterable<? extends File> roots, boolean acceptItSelf) {
        String absolutePathWithSeparator = file.getAbsolutePath() + File.separator;
        for (File file2 : roots) {
            if ((!acceptItSelf || !file2.equals(file)) && !file2.getAbsolutePath().startsWith(absolutePathWithSeparator)) continue;
            return true;
        }
        return false;
    }

    private static class CombinedRootSubset {
        private final FileSystemSubset.Builder combinedFileSystemSubsetBuilder = FileSystemSubset.builder();
        private Iterable<? extends File> roots;
        private FileSystemSubset unfiltered;
        private FileSystemSubset combinedFileSystemSubset;

        public void append(FileSystemSubset fileSystemSubset) {
            this.combinedFileSystemSubsetBuilder.add(fileSystemSubset);
            this.roots = null;
        }

        private void ensureRootsUpToDate() {
            if (this.roots != null) {
                return;
            }
            this.combinedFileSystemSubset = this.combinedFileSystemSubsetBuilder.build();
            this.roots = this.combinedFileSystemSubset.getRoots();
            this.unfiltered = new FileSystemSubset((ImmutableCollection)ImmutableList.copyOf(this.roots), (ImmutableCollection)ImmutableList.of());
        }

        public boolean isInRootsOrAncestorOrAnyRoot(File directory) {
            this.ensureRootsUpToDate();
            return WatchPointsRegistry.inCombinedRootsOrAncestorOfAnyRoot(directory, this.roots, this.unfiltered);
        }

        public boolean contains(File file) {
            this.ensureRootsUpToDate();
            return this.combinedFileSystemSubset.contains(file);
        }
    }

    class Delta {
        private FileSystemSubset fileSystemSubset;
        private Iterable<? extends File> roots;
        private FileSystemSubset combinedRoots;
        private Iterable<? extends File> startingWatchPoints;
        private ImmutableSet<? extends File> currentWatchPoints;

        private Delta(FileSystemSubset fileSystemSubset, ImmutableSet<? extends File> currentWatchPoints) {
            this.fileSystemSubset = fileSystemSubset;
            this.currentWatchPoints = currentWatchPoints;
            this.init();
        }

        private Delta init() {
            this.roots = this.fileSystemSubset.getRoots();
            this.combinedRoots = this.fileSystemSubset.unfiltered();
            Iterable<? extends File> startingWatchPointCandidates = this.calculateStartingWatchPoints(this.roots, this.combinedRoots);
            if (!this.currentWatchPoints.isEmpty()) {
                if (WatchPointsRegistry.this.createNewStartingPointsUnderExistingRoots) {
                    this.startingWatchPoints = this.filterCurrentWatchPoints(startingWatchPointCandidates);
                    this.currentWatchPoints = ImmutableSet.builder().addAll(this.currentWatchPoints).addAll(this.startingWatchPoints).build();
                } else {
                    Collection combinedRoots = FileUtils.calculateRoots((Iterable)Iterables.concat(this.currentWatchPoints, startingWatchPointCandidates));
                    this.startingWatchPoints = this.filterCurrentWatchPoints(combinedRoots);
                    this.currentWatchPoints = ImmutableSet.copyOf((Iterable)combinedRoots);
                }
                WatchPointsRegistry.this.rootSubset.append(this.fileSystemSubset);
            } else {
                this.startingWatchPoints = startingWatchPointCandidates;
                WatchPointsRegistry.this.rootSubset.append(this.fileSystemSubset);
                this.currentWatchPoints = ImmutableSet.copyOf(this.startingWatchPoints);
            }
            WatchPointsRegistry.this.allRequestedRoots = ImmutableSet.builder().addAll((Iterable)WatchPointsRegistry.this.allRequestedRoots).addAll(this.roots).build();
            return this;
        }

        private ImmutableSet<File> filterCurrentWatchPoints(Iterable<? extends File> startingWatchPointCandidates) {
            ImmutableSet.Builder newStartingPoints = ImmutableSet.builder();
            for (File file : startingWatchPointCandidates) {
                if (WatchPointsRegistry.this.allRequestedRoots.contains((Object)file) && this.currentWatchPoints.contains((Object)file)) continue;
                newStartingPoints.add((Object)file);
            }
            return newStartingPoints.build();
        }

        private Iterable<? extends File> calculateStartingWatchPoints(final Iterable<? extends File> roots, final FileSystemSubset unfiltered) {
            Iterable enclosingDirsThatExist = Iterables.transform(roots, (Function)new Function<File, File>(){

                public File apply(File input) {
                    File target = input;
                    while (!target.isDirectory()) {
                        target = target.getParentFile();
                    }
                    return target;
                }
            });
            return Iterables.filter((Iterable)FileUtils.calculateRoots((Iterable)enclosingDirsThatExist), (Predicate)new Predicate<File>(){

                public boolean apply(File input) {
                    return WatchPointsRegistry.inCombinedRootsOrAncestorOfAnyRoot(input, roots, unfiltered);
                }
            });
        }

        private boolean inCombinedRootsOrAncestorOfAnyRootThis(File file) {
            return WatchPointsRegistry.inCombinedRootsOrAncestorOfAnyRoot(file, this.roots, this.combinedRoots);
        }

        public Iterable<? extends File> getStartingWatchPoints() {
            return this.startingWatchPoints;
        }

        public boolean shouldWatch(File file) {
            boolean result;
            boolean bl = result = this.inCombinedRootsOrAncestorOfAnyRootThis(file) || WatchPointsRegistry.isAncestorOfAnyRoot(file, (Iterable)WatchPointsRegistry.this.allRequestedRoots);
            if (!result) {
                LOG.debug("not watching file: {} currentWatchPoints: {} allRequestedRoots: {} roots: {} unfiltered: {}", new Object[]{file, this.currentWatchPoints, WatchPointsRegistry.this.allRequestedRoots, this.roots, this.combinedRoots});
            }
            return result;
        }
    }
}

