/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;

class AttributeMatchingVariantSelector
implements VariantSelector {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final ImmutableAttributes requested;
    private final boolean ignoreWhenNoMatches;
    private final ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver;

    AttributeMatchingVariantSelector(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory, AttributeContainerInternal requested, boolean ignoreWhenNoMatches, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
        this.requested = requested.asImmutable();
        this.ignoreWhenNoMatches = ignoreWhenNoMatches;
        this.dependenciesResolver = dependenciesResolver;
    }

    public String toString() {
        return "Variant selector for " + this.requested;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer) {
        try {
            return this.doSelect(producer);
        }
        catch (VariantSelectionException t) {
            return new BrokenResolvedArtifactSet(t);
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet(VariantSelectionException.selectionFailed(producer, t));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer) {
        AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
        ImmutableAttributes componentRequested = this.attributesFactory.concat(this.requested, producer.getOverriddenAttributes());
        List<ResolvedVariant> matches = matcher.matches(producer.getVariants(), (AttributeContainerInternal)componentRequested);
        if (matches.size() == 1) {
            return matches.get(0).getArtifacts();
        }
        if (matches.size() > 1) {
            throw new AmbiguousVariantSelectionException(producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, matches, matcher);
        }
        List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates = new ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>>();
        for (ResolvedVariant variant : producer.getVariants()) {
            ImmutableAttributes variantAttributes = variant.getAttributes().asImmutable();
            ConsumerVariantMatchResult matchResult = new ConsumerVariantMatchResult();
            this.consumerProvidedVariantFinder.collectConsumerVariants((AttributeContainerInternal)variantAttributes, (AttributeContainerInternal)componentRequested, matchResult);
            for (ConsumerVariantMatchResult.ConsumerVariant consumerVariant : matchResult.getMatches()) {
                candidates.add((Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>)Pair.of((Object)variant, (Object)consumerVariant));
            }
        }
        if (candidates.size() > 1) {
            candidates = this.tryDisambiguate(matcher, candidates);
        }
        if (candidates.size() == 1) {
            Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> result = candidates.get(0);
            ResolvedArtifactSet artifacts = ((ResolvedVariant)result.getLeft()).getArtifacts();
            AttributeContainerInternal attributes = ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).attributes;
            Transformation transformation = ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).transformation;
            return new ConsumerProvidedResolvedVariant(producer.getComponentId(), artifacts, attributes, transformation, this.dependenciesResolver);
        }
        if (!candidates.isEmpty()) {
            throw new AmbiguousTransformException(producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, candidates);
        }
        if (this.ignoreWhenNoMatches) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw new NoMatchingVariantSelectionException(producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, producer.getVariants(), matcher);
    }

    private List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> tryDisambiguate(AttributeMatcher matcher, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates) {
        if (candidates.size() == 2) {
            return this.compareCandidates(matcher, candidates.get(0), candidates.get(1)).map(Collections::singletonList).orElse(candidates);
        }
        ArrayList shortestTransforms = Lists.newArrayListWithExpectedSize((int)candidates.size());
        candidates.sort(Comparator.comparingInt(candidate -> ((ConsumerVariantMatchResult.ConsumerVariant)candidate.right).depth));
        boolean[] hasBetterMatch = new boolean[candidates.size()];
        for (int i = 0; i < candidates.size(); ++i) {
            if (hasBetterMatch[i]) continue;
            boolean candidateIsDifferent = true;
            Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> current = candidates.get(i);
            for (int j = i + 1; j < candidates.size(); ++j) {
                if (hasBetterMatch[j]) continue;
                int index = j;
                candidateIsDifferent = this.compareCandidates(matcher, current, candidates.get(index)).map(candidate -> {
                    if (candidate != current) {
                        return false;
                    }
                    hasBetterMatch[index] = true;
                    return true;
                }).orElse(true);
            }
            if (!candidateIsDifferent) continue;
            shortestTransforms.add(current);
        }
        return shortestTransforms;
    }

    private Optional<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> compareCandidates(AttributeMatcher matcher, Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> firstCandidate, Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> secondCandidate) {
        if (matcher.isMatching(((ConsumerVariantMatchResult.ConsumerVariant)firstCandidate.right).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)secondCandidate.right).attributes)) {
            if (((ConsumerVariantMatchResult.ConsumerVariant)firstCandidate.right).depth >= ((ConsumerVariantMatchResult.ConsumerVariant)secondCandidate.right).depth) {
                return Optional.of(secondCandidate);
            }
            return Optional.of(firstCandidate);
        }
        return Optional.empty();
    }
}

