# GutenPy - widgets.py
# Copyright (C) 2006 Lee Bigelow <ligelowbee@yahoo.com> 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, pango

class YesNoDialog(gtk.MessageDialog):
    def __init__(self, question, parent):
        gtk.MessageDialog.__init__(self, parent,
                            gtk.DIALOG_DESTROY_WITH_PARENT,
                            gtk.MESSAGE_QUESTION,
                            gtk.BUTTONS_YES_NO,
                            question)
        self.set_default_response(gtk.RESPONSE_NO)
        self.connect('key_press_event', self.key_press_event_handler)

    def key_press_event_handler(self, widget, event, user_data=None):
        if event.string == 'y':
            widget.emit('response', gtk.RESPONSE_YES)
            return True
        elif event.string == 'n':
            widget.emit('response', gtk.RESPONSE_NO)
            return True
        return False


class EntryDialog(gtk.Dialog):
    def __init__(self, parent=None, title=None, label=None,
                 flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                 buttons=(gtk.STOCK_OK,     gtk.RESPONSE_OK,
                          gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)):
        gtk.Dialog.__init__(self, title, parent, flags, buttons)
        self.label = gtk.Label()
        if label: self.label.set_text(label)
        self.entry = gtk.Entry()
        self.entry.set_activates_default(True)
        self.vbox.pack_start(self.label)
        self.vbox.pack_start(self.entry)
        self.vbox.show_all()


class PrefsDialog(gtk.Dialog):
    def __init__(self, main_pref_list, behaviour_pref_list, parent=None):
        gtk.Dialog.__init__(self, "GutenPy Prefereces", parent,
                            gtk.DIALOG_DESTROY_WITH_PARENT,
                            (gtk.STOCK_OK, gtk.RESPONSE_OK,
                             gtk.STOCK_APPLY, gtk.RESPONSE_APPLY,
                             gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
        nb = gtk.Notebook()
        self.vbox.pack_start(nb)

        label = gtk.Label('Main')
        vbox = gtk.VBox()
        nb.append_page(vbox, label)
        for item in main_pref_list:
            hbox = gtk.HBox()
            hbox.set_homogeneous(False)
            title = item.get_data('title')
            if title: label = gtk.Label(title)
            else: label = gtk.Label(item.get_title())
            label.set_width_chars(18)
            hbox.pack_start(label,False)
            hbox.pack_start(item)
            vbox.pack_start(hbox)

        label = gtk.Label('Behaviour')
        vbox = gtk.VBox()
        for item in behaviour_pref_list:
            vbox.pack_start(item, False, False, 2)
        nb.append_page(vbox, label)
        
        self.vbox.show_all()


class GutenpyTextView(gtk.TextView):
    def __init__(self, parent, filename, text, enc):
        gtk.TextView.__init__(self)
        self.connect('button_press_event',
                     parent.mouse_button_press_event_handler)
        self.connect('key_press_event',
                     parent.scroll_key_press_event_handler)
        textbuffer = self.get_buffer()
        textbuffer.set_text(text)
        self.filename = filename
        self.charset = enc
        
        if parent.prefs.wrap_lines:
            self.set_wrap_mode(gtk.WRAP_WORD)
        else:
            self.set_wrap_mode(gtk.WRAP_NONE)
        self.set_left_margin(50)
        self.set_editable(False)
        self.set_cursor_visible(False)
        self.modify_font(pango.FontDescription(parent.prefs.font))
        r,g,b = parent.prefs.bg
        self.modify_base(gtk.STATE_NORMAL, gtk.gdk.Color(r,g,b))
        r,g,b = parent.prefs.fg
        self.modify_text(gtk.STATE_NORMAL, gtk.gdk.Color(r,g,b))
        
