/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.timeout;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;

public class Timeout {
    public static final String EXECUTOR_VARIABLE = "__executor__";

    public static void load(Ruby runtime2) {
        Timeout.define(runtime2.getOrCreateModule("Timeout"));
    }

    public static void define(RubyModule timeout2) {
        timeout2.defineAnnotatedMethods(Timeout.class);
        timeout2.setInternalVariable(EXECUTOR_VARIABLE, new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory()));
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, Block block) {
        return Timeout.timeout(context, recv2, seconds, context.nil, block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        return Timeout.timeout(context, recv2, seconds, exceptionType, RubyString.newString(context.runtime, "execution expired").freeze(context), block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, IRubyObject message2, Block block) {
        RubyModule timeout2 = context.runtime.getModule("Timeout");
        if (Timeout.nilOrZeroSeconds(context, seconds)) {
            return block.yieldSpecific(context);
        }
        Ruby runtime2 = context.runtime;
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        RubyObject id2 = new RubyObject(runtime2, runtime2.getObject());
        TimeoutTask timeoutRunnable = exceptionType.isNil() ? TimeoutTask.newAnonymousTask(currentThread, timeout2, latch, id2, message2.convertToString()) : TimeoutTask.newTaskWithException(currentThread, timeout2, latch, exceptionType, message2.convertToString());
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)timeout2.getInternalVariables().getInternalVariable(EXECUTOR_VARIABLE);
        try {
            return Timeout.yieldWithTimeout(executor, context, seconds, block, timeoutRunnable, latch);
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == Timeout.getDefaultException(timeout2) && exceptionType.isNil()) {
                Timeout.raiseTimeoutErrorIfMatches(context, timeout2, re, id2);
            }
            throw re;
        }
    }

    private static boolean nilOrZeroSeconds(ThreadContext context, IRubyObject seconds) {
        return seconds.isNil() || Helpers.invoke(context, seconds, "zero?").isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject yieldWithTimeout(ScheduledThreadPoolExecutor executor, ThreadContext context, IRubyObject seconds, Block block, Runnable runnable, AtomicBoolean latch) throws RaiseException {
        long micros = (long)(RubyTime.convertTimeInterval(context, seconds) * 1000000.0);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = executor.schedule(runnable, micros, TimeUnit.MICROSECONDS);
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        finally {
            if (timeoutFuture != null) {
                Timeout.killTimeoutThread(executor, context, timeoutFuture, latch);
            }
        }
    }

    private static void killTimeoutThread(ScheduledThreadPoolExecutor executor, ThreadContext context, Future timeoutFuture, AtomicBoolean latch) {
        if (latch.compareAndSet(false, true) && timeoutFuture.cancel(false)) {
            if (timeoutFuture instanceof Runnable) {
                executor.remove((Runnable)((Object)timeoutFuture));
            }
        } else {
            try {
                timeoutFuture.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.pollThreadEvents();
        }
    }

    private static IRubyObject raiseTimeoutErrorIfMatches(ThreadContext context, IRubyObject timeout2, RaiseException ex, IRubyObject id2) {
        if (ex.getException().getInternalVariable("__identifier__") == id2) {
            RubyException rubyException = ex.getException();
            return RubyKernel.raise(context, context.runtime.getKernel(), new IRubyObject[]{Timeout.getClassFrom(timeout2, "Error"), rubyException.callMethod(context, "message"), rubyException.callMethod(context, "backtrace")}, Block.NULL_BLOCK);
        }
        return null;
    }

    private static RubyClass getDefaultException(IRubyObject timeout2) {
        return Timeout.getClassFrom(timeout2, "Error");
    }

    private static RubyClass getClassFrom(IRubyObject timeout2, String name2) {
        return ((RubyModule)timeout2).getClass(name2);
    }

    private static class TimeoutTask
    implements Runnable {
        final RubyThread currentThread;
        final AtomicBoolean latch;
        final IRubyObject timeout;
        final IRubyObject id;
        final IRubyObject exception;
        final RubyString message;

        private TimeoutTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2, IRubyObject exception2, RubyString message2) {
            this.currentThread = currentThread;
            this.timeout = timeout2;
            this.latch = latch;
            this.id = id2;
            this.exception = exception2;
            this.message = message2;
        }

        static TimeoutTask newAnonymousTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, id2, null, message2);
        }

        static TimeoutTask newTaskWithException(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject exception2, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, null, exception2, message2);
        }

        @Override
        public void run() {
            if (this.latch.compareAndSet(false, true)) {
                if (this.exception == null) {
                    this.raiseAnonymous();
                } else {
                    this.raiseException();
                }
            }
        }

        private void raiseAnonymous() {
            IRubyObject anonException = Timeout.getDefaultException(this.timeout).newInstance(this.timeout.getRuntime().getCurrentContext(), this.message, Block.NULL_BLOCK);
            anonException.getInternalVariables().setInternalVariable("__identifier__", this.id);
            this.currentThread.raise(anonException);
        }

        private void raiseException() {
            this.currentThread.raise(this.exception, this.message);
        }
    }
}

