/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jruby.CompatVersion;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class AnnotationBinder
extends AbstractProcessor {
    private static final boolean DEBUG = false;
    @Deprecated
    public static final String SRC_GEN_DIR = "target/generated-sources/org/jruby/gen/";
    private static final String GEN_PACKAGE_NAME = "org.jruby.gen";
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    private static final String ANNOTATED_CLASSES_FILE = "annotated_classes.txt";
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private transient BufferedWriter out;
    private transient File generatedPackageDir;
    private String generatedSourcesPath = "target/generated-sources";

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        if (typeElements.isEmpty()) {
            return false;
        }
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            Writer annotated_classes = this.getAnnotatedClassesFileWriter();
            for (CharSequence name2 : this.classNames) {
                annotated_classes.append(name2).append('\n');
            }
            annotated_classes.close();
        }
        catch (IOException e) {
            this.printError(e);
        }
        return true;
    }

    public synchronized void processType(TypeElement type) {
        for (TypeElement innerType : ElementFilter.typesIn(type.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            ExecutableElement decl;
            String className = type.getQualifiedName().toString().replace('.', '$');
            if (!className.contains("org$jruby")) {
                return;
            }
            className = className + POPULATOR_SUFFIX;
            this.out = this.generatedJavaFileWriter(className);
            this.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
            this.println("package org.jruby.gen;");
            this.println("import org.jruby.Ruby;");
            this.println("import org.jruby.RubyModule;");
            this.println("import org.jruby.RubyClass;");
            this.println("import org.jruby.CompatVersion;");
            this.println("import org.jruby.anno.TypePopulator;");
            this.println("import org.jruby.internal.runtime.methods.CallConfiguration;");
            this.println("import org.jruby.internal.runtime.methods.JavaMethod;");
            this.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
            this.println("import org.jruby.runtime.Arity;");
            this.println("import org.jruby.runtime.Visibility;");
            this.println("import org.jruby.compiler.ASTInspector;");
            this.println("import java.util.Arrays;");
            this.println("import java.util.List;");
            this.println("import javax.annotation.Generated;");
            this.println("@Generated(\"org.jruby.anno.AnnotationBinder\")");
            this.println("public class " + className + " extends TypePopulator {");
            this.println("    public void populate(RubyModule cls, Class clazz) {");
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            boolean hasCompat = false;
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                hasAnno = true;
                hasMeta |= anno.meta();
                hasModule |= anno.module();
                hasCompat |= anno.compat() != CompatVersion.BOTH;
            }
            if (!hasAnno) {
                return;
            }
            this.println("        JavaMethod javaMethod;");
            this.println("        DynamicMethod moduleMethod;");
            if (hasMeta || hasModule) {
                this.println("        RubyClass singletonClass = cls.getSingletonClass();");
            }
            if (hasCompat) {
                this.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
            }
            this.println("        Ruby runtime = cls.getRuntime();");
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods1_8 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods1_8 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods1_9 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods1_9 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods2_0 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods2_0 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashSet frameAwareMethods = new HashSet();
            HashSet scopeAwareMethods = new HashSet();
            int methodCount = 0;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
                Name name2;
                JRubyMethod anno = executableElement.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                ++methodCount;
                if (executableElement.getThrownTypes().size() != 0) {
                    this.printWarning(type.toString() + "." + executableElement.toString() + " should not throw exceptions: " + executableElement.getThrownTypes().toString());
                }
                CharSequence charSequence = name2 = anno.name().length == 0 ? executableElement.getSimpleName() : anno.name()[0];
                HashMap<CharSequence, List<ExecutableElement>> methodsHash = executableElement.getModifiers().contains((Object)Modifier.STATIC) ? (anno.compat() == CompatVersion.RUBY1_8 ? staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? staticAnnotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? staticAnnotatedMethods2_0 : staticAnnotatedMethods))) : (anno.compat() == CompatVersion.RUBY1_8 ? annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? annotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? annotatedMethods2_0 : annotatedMethods)));
                ArrayList<ExecutableElement> methodDescs = (ArrayList<ExecutableElement>)methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<ExecutableElement>();
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(executableElement);
                boolean frame = false;
                boolean scope = false;
                if (anno.frame()) {
                    frame = true;
                }
                if (anno.scope()) {
                    scope = true;
                }
                for (FrameField field : anno.reads()) {
                    frame |= field.needsFrame();
                    scope |= field.needsScope();
                }
                for (FrameField field : anno.writes()) {
                    frame |= field.needsFrame();
                    scope |= field.needsScope();
                }
                if (frame) {
                    AnnotationHelper.addMethodNamesToSet(frameAwareMethods, (JRubyMethod)anno, (String)executableElement.getSimpleName().toString());
                }
                if (!scope) continue;
                AnnotationHelper.addMethodNamesToSet(scopeAwareMethods, (JRubyMethod)anno, (String)executableElement.getSimpleName().toString());
            }
            if (methodCount == 0) {
                return;
            }
            this.classNames.add(AnnotationBinder.getActualQualifiedName(type));
            this.processMethodDeclarations(staticAnnotatedMethods);
            for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            if (!staticAnnotatedMethods1_8.isEmpty()) {
                this.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods1_8);
                for (Map.Entry entry : staticAnnotatedMethods1_8.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            if (!staticAnnotatedMethods1_9.isEmpty()) {
                this.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods1_9);
                for (Map.Entry entry : staticAnnotatedMethods1_9.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            if (!staticAnnotatedMethods2_0.isEmpty()) {
                this.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods2_0);
                for (Map.Entry entry : staticAnnotatedMethods2_0.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            this.processMethodDeclarations(annotatedMethods);
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            if (!annotatedMethods1_8.isEmpty()) {
                this.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods1_8);
                for (Map.Entry entry : annotatedMethods1_8.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            if (!annotatedMethods1_9.isEmpty()) {
                this.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods1_9);
                for (Map.Entry entry : annotatedMethods1_9.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            if (!annotatedMethods2_0.isEmpty()) {
                this.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods2_0);
                for (Map.Entry entry : annotatedMethods2_0.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    AnnotationBinder.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.println("        }");
            }
            this.println("    }");
            this.println("    static {");
            if (!frameAwareMethods.isEmpty()) {
                StringBuilder frameMethodsString = new StringBuilder();
                boolean bl = true;
                for (CharSequence name2 : frameAwareMethods) {
                    boolean bl2;
                    if (!bl2) {
                        frameMethodsString.append(',');
                    }
                    bl2 = false;
                    frameMethodsString.append('\"').append(name2).append('\"');
                }
                this.println("        ASTInspector.addFrameAwareMethods(" + frameMethodsString + ");");
            }
            if (!scopeAwareMethods.isEmpty()) {
                StringBuilder scopeMethodsString = new StringBuilder();
                boolean bl = true;
                for (CharSequence name2 : scopeAwareMethods) {
                    boolean bl3;
                    if (!bl3) {
                        scopeMethodsString.append(',');
                    }
                    bl3 = false;
                    scopeMethodsString.append('\"').append(name2).append('\"');
                }
                this.println("        ASTInspector.addScopeAwareMethods(" + scopeMethodsString + ");");
            }
            this.println("    }");
            this.println("}");
            this.out.close();
            this.out = null;
        }
        catch (IOException ioe) {
            this.printError(ioe, type);
        }
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) throws IOException {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list = entry.getValue();
            if (list.size() == 1) {
                this.processMethodDeclaration(list.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list.get(0));
        }
    }

    public void processMethodDeclaration(ExecutableElement method) throws IOException {
        JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            boolean hasContext = AnnotationBinder.firstParamContext(method);
            boolean hasBlock = AnnotationBinder.lastParamBlock(method);
            StringBuilder params2 = new StringBuilder();
            boolean first = true;
            for (VariableElement variableElement : method.getParameters()) {
                if (!first) {
                    params2.append(", ");
                }
                first = false;
                params2.append(variableElement.asType()).append(".class");
            }
            int actualRequired = this.calculateActualRequired(method, method.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string = CodegenUtils.getAnnotatedBindingClassName((Name)method.getSimpleName(), (CharSequence)AnnotationBinder.getActualQualifiedName(method), (boolean)isStatic, (int)actualRequired, (int)anno.optional(), (boolean)false, (boolean)anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            Name qualifiedName = ((TypeElement)method.getEnclosingElement()).getQualifiedName();
            this.println("        javaMethod = new " + string + "(" + implClass + ", Visibility." + anno.visibility() + ");");
            this.println("        populateMethod(javaMethod, " + AnnotationHelper.getArityValue((JRubyMethod)anno, (int)actualRequired) + ", \"" + method.getSimpleName() + "\", " + isStatic + ", CallConfiguration." + AnnotationHelper.getCallConfigNameByAnno((JRubyMethod)anno) + ", " + anno.notImplemented() + ", " + qualifiedName + ".class, \"" + method.getSimpleName() + "\", " + method.getReturnType().toString() + ".class, new Class[] {" + params2 + "});");
            this.generateMethodAddCalls(method, anno);
        }
    }

    public void processMethodDeclarationMulti(ExecutableElement method) throws IOException {
        JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            boolean hasContext = AnnotationBinder.firstParamContext(method);
            boolean hasBlock = AnnotationBinder.lastParamBlock(method);
            StringBuilder params2 = new StringBuilder();
            boolean first = true;
            for (VariableElement variableElement : method.getParameters()) {
                if (!first) {
                    params2.append(", ");
                }
                first = false;
                params2.append(variableElement.asType()).append(".class");
            }
            int actualRequired = this.calculateActualRequired(method, method.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string = CodegenUtils.getAnnotatedBindingClassName((Name)method.getSimpleName(), (CharSequence)AnnotationBinder.getActualQualifiedName(method), (boolean)isStatic, (int)actualRequired, (int)anno.optional(), (boolean)true, (boolean)anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            Name qualifiedName = ((TypeElement)method.getEnclosingElement()).getQualifiedName();
            this.println("        javaMethod = new " + string + "(" + implClass + ", Visibility." + anno.visibility() + ");");
            this.println("        populateMethod(javaMethod, -1, \"" + method.getSimpleName() + "\", " + isStatic + ", CallConfiguration." + AnnotationHelper.getCallConfigNameByAnno((JRubyMethod)anno) + ", " + anno.notImplemented() + ", " + qualifiedName + ".class, \"" + method.getSimpleName() + "\", " + method.getReturnType().toString() + ".class, new Class[] {" + params2 + "});");
            this.generateMethodAddCalls(method, anno);
        }
    }

    private static void addCoreMethodMapping(CharSequence rubyName, ExecutableElement decl, BufferedWriter out) throws IOException {
        Name qualifiedName = ((TypeElement)decl.getEnclosingElement()).getQualifiedName();
        out.write(new StringBuilder(50).append("        runtime.addBoundMethod(").append('\"').append(qualifiedName).append('\"').append(',').append('\"').append(decl.getSimpleName()).append('\"').append(',').append('\"').append(rubyName).append('\"').append(");").toString());
        out.newLine();
    }

    private static boolean firstParamContext(ExecutableElement method) {
        TypeMirror type;
        List<? extends VariableElement> params2 = method.getParameters();
        return params2.size() > 0 && "org.jruby.runtime.ThreadContext".equals((type = params2.get(0).asType()).toString());
    }

    private static boolean lastParamBlock(ExecutableElement method) {
        TypeMirror type;
        List<? extends VariableElement> params2 = method.getParameters();
        return params2.size() > 0 && "org.jruby.runtime.Block".equals((type = params2.get(params2.size() - 1).asType()).toString());
    }

    private static CharSequence getActualQualifiedName(ExecutableElement method) {
        return AnnotationBinder.getActualQualifiedName((TypeElement)method.getEnclosingElement());
    }

    private static CharSequence getActualQualifiedName(TypeElement type) {
        if (type.getNestingKind() == NestingKind.MEMBER) {
            TypeElement enclosing = (TypeElement)type.getEnclosingElement();
            return AnnotationBinder.getActualQualifiedName(enclosing) + "$" + type.getSimpleName();
        }
        return type.getQualifiedName().toString();
    }

    private int calculateActualRequired(ExecutableElement md, int paramsLength, int optional, boolean rest, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int actualRequired;
        if (optional == 0 && !rest) {
            int args = paramsLength;
            if (args == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args;
                }
                if (hasContext) {
                    --args;
                }
                if (hasBlock) {
                    --args;
                }
                actualRequired = args;
            }
        } else {
            int args = paramsLength;
            if (args == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args;
                }
                if (hasContext) {
                    --args;
                }
                if (hasBlock) {
                    --args;
                }
                actualRequired = --args;
            }
            if (actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)md.getEnclosingElement()).getQualifiedName() + "." + md.toString());
            }
        }
        return actualRequired;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod jrubyMethod) throws IOException {
        if (jrubyMethod.meta()) {
            this.defineMethodOnClass("javaMethod", "singletonClass", jrubyMethod, md);
        } else {
            this.defineMethodOnClass("javaMethod", "cls", jrubyMethod, md);
            if (jrubyMethod.module()) {
                this.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                this.defineMethodOnClass("moduleMethod", "singletonClass", jrubyMethod, md);
            }
        }
    }

    private void defineMethodOnClass(String methodVar, String classVar, JRubyMethod jrubyMethod, ExecutableElement md) throws IOException {
        CharSequence baseName;
        if (jrubyMethod.name().length == 0) {
            baseName = md.getSimpleName();
            this.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + baseName + "\", " + methodVar + ");");
        } else {
            baseName = jrubyMethod.name()[0];
            for (String name2 : jrubyMethod.name()) {
                this.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + name2 + "\", " + methodVar + ");");
            }
        }
        if (jrubyMethod.alias().length > 0) {
            for (String alias : jrubyMethod.alias()) {
                this.println("        " + classVar + ".defineAlias(\"" + alias + "\", \"" + baseName + "\");");
            }
        }
    }

    private void println(String line) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException("null line");
        }
        this.out.write(line);
        this.out.newLine();
    }

    private BufferedWriter generatedJavaFileWriter(String className) throws IOException {
        if (this.processingEnv != null) {
            Filer filer = this.processingEnv.getFiler();
            JavaFileObject file = filer.createSourceFile("org.jruby.gen." + className, new Element[0]);
            Writer writer = file.openWriter();
            if (writer instanceof BufferedWriter) {
                return (BufferedWriter)writer;
            }
            return new BufferedWriter(writer);
        }
        if (this.generatedPackageDir == null) {
            String genPackagePath = GEN_PACKAGE_NAME.replace('.', '/');
            this.generatedPackageDir = new File(this.getGeneratedSourcesPath(), genPackagePath);
            this.generatedPackageDir.mkdirs();
        }
        File javaFile = new File(this.generatedPackageDir, className + ".java");
        return new BufferedWriter(new FileWriter(javaFile));
    }

    public String getGeneratedSourcesPath() {
        return this.generatedSourcesPath;
    }

    public void setGeneratedSourcesPath(String generatedSourcesPath) {
        this.generatedPackageDir = null;
        this.generatedSourcesPath = generatedSourcesPath;
    }

    private Writer getAnnotatedClassesFileWriter() throws IOException {
        if (this.processingEnv != null) {
            Filer filer = this.processingEnv.getFiler();
            FileObject file = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", ANNOTATED_CLASSES_FILE, new Element[0]);
            return file.openWriter();
        }
        return new FileWriter(new File(this.getGeneratedSourcesPath(), ANNOTATED_CLASSES_FILE));
    }

    private void printNote(String msg) {
        if (this.processingEnv != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        } else {
            System.out.println(msg);
        }
    }

    private void printWarning(String msg) {
        if (this.processingEnv != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
        } else {
            System.out.println(msg);
        }
    }

    private void printError(Exception e, TypeElement type) {
        this.printError(e.toString(), type);
    }

    private void printError(Exception e) {
        this.printError(e.toString());
    }

    private void printError(String msg) {
        if (this.processingEnv != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        } else {
            System.err.println(msg);
        }
    }

    private void printError(String msg, TypeElement type) {
        if (this.processingEnv != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, type);
        } else {
            System.err.println(msg);
        }
    }
}

